/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class VsDelNasDsSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6726202236876397709L;
    private static final Log logger = LogFactory.getInstance(VsDelNasDsSubProcessor.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsDelNasDsSubProcessor.";
    private static final String ALREADY_DELETED = "com.huawei.ism.drm.vsphere.recovery.process.VsDelNasDsSubProcessor.already.deleted";
    private static final String DELETE_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsDelNasDsSubProcessor.removeNasDs.failed";
    private String dsName;
    private String vcenterUuid;
    private String compResUuid;
    private String dsUuid;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.dsName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(ALREADY_DELETED, new String[]{this.dsName});
            logger.debug((Object)("The nas datastore has alreay deleted. dsName=" + this.dsName), 90160758786988L);
            return true;
        }
        try {
            int procType = this.getProcType();
            VsphereRecoveryUtils util = VsphereRecoveryUtils.getInstance();
            Site prodSite = util.getProductSite(context);
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != procType || prodSite.getSiteType() == 0) {
                DataStoreAction dsAction = new DataStoreAction();
                dsAction.removeDsFromCompRes(this.vcenterUuid, this.compResUuid, this.dsUuid);
            }
            logger.info((Object)("remove nas ds success:dsName=" + this.dsName + " dsUuid=" + this.dsUuid + " compResUuid=" + this.compResUuid));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("delete nas datastore failed:dsName=" + this.dsName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("delete nas datastore failed:dsName=" + this.dsName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(DELETE_FAILED, new String[]{this.dsName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getCompResUuid() {
        return this.compResUuid;
    }

    public void setCompResUuid(String compResUuid) {
        this.compResUuid = compResUuid;
    }

    public String getDsUuid() {
        return this.dsUuid;
    }

    public void setDsUuid(String dsUuid) {
        this.dsUuid = dsUuid;
    }
}

