/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;

public class VsRecoveryNoncriticalVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2879302086742999518L;
    private static final Log logger = LogFactory.getInstance(VsRecoveryNoncriticalVmSubProcessor.class);
    private String vmUuid = "";
    private String vmName = "";
    private String vcenterUuid;
    private String taskId;
    private long errorCode = 0L;

    protected boolean execute(RecoveryProcessorContext context) {
        logger.debug((Object)("resume vm " + this.vmName), 90160758786988L);
        this.updateProcessNameParams(new String[]{this.vmName});
        this.vcenterUuid = VsphereRecoveryUtils.getInstance().getDisVcenterUuid(context, this.getProcType());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.debug((Object)("this vm has started yet:vmName=" + this.vmName), 90160758786988L);
            return true;
        }
        if (0L != this.errorCode) {
            this.updateProcessDetail("lego.err." + this.errorCode, null);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((String)this.taskId)) {
            logger.error((Object)("taskid is empty:vmName=" + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        if (!this.monitorTask()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private boolean monitorTask() {
        ManagedObjectReference task = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.taskId, "Task");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(this.vcenterUuid);
        MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            VMAction action = new VMAction();
            LegoCheckedException legoExc = action.getPowerOnLegoException(fault);
            this.updateProcessDetail(legoExc);
            logger.error((Object)("poweron vm failed:vmName=" + this.vmName), (Throwable)legoExc, 90160758786989L);
            return false;
        }
        logger.info((Object)("power on vm sucessfully:vmName=" + this.vmName), 90160758786988L);
        return true;
    }

    public String getVmUuid() {
        return this.vmUuid;
    }

    public void setVmUuid(String vmUuid) {
        this.vmUuid = vmUuid;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

