/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsClSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsUnmountDsAndLunWithNativeProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4049724261902551302L;
    private static final Integer UNMOUNT_DS_PRIORITY = 0;
    private static final Integer UNMOUNT_LUN_PRIORITY = 1;
    private static final Log logger = LogFactory.getInstance(VsUnmountDsAndLunWithNativeProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        boolean createResult;
        Set subProcessors = this.getChildProc();
        if ((null == subProcessors || subProcessors.isEmpty()) && !(createResult = this.createSubProcessorsAndSetPriority(context))) {
            logger.error((Object)"create subprocessors failed.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority();
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithConcurrentSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean createSubProcessorsAndSetPriority(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> subProcessors = this.createClearSubProcessors(context);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Set<RecoveryProcessor> createClearSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> childProcessors = new HashSet<RecoveryProcessor>();
        List createProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, VsConfigDataStoreSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            logger.debug((Object)"start SubProcessor is empty", 90160758786988L);
            return childProcessors;
        }
        for (RecoveryProcessor p : createProcessors) {
            VsConfigDataStoreSubProcessor createDsSubProcessor = (VsConfigDataStoreSubProcessor)p;
            String newDsUuid = createDsSubProcessor.getNewDataStoreUuid();
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != createDsSubProcessor.getProcStatus()) continue;
            VsUnmountDsClSubProcessor processor = this.getVsUnmountDsClSubProcessorWhenClear(createDsSubProcessor, newDsUuid);
            childProcessors.add((RecoveryProcessor)processor);
        }
        return childProcessors;
    }

    private VsUnmountDsClSubProcessor getVsUnmountDsClSubProcessorWhenClear(VsConfigDataStoreSubProcessor createDsSubProcessor, String newDsUuid) {
        VsUnmountDsClSubProcessor processor = new VsUnmountDsClSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDataStoreUuid(newDsUuid);
        processor.setDataStoreName(createDsSubProcessor.getNewDataStoreName());
        processor.setHostMoId(createDsSubProcessor.getHostMoId());
        processor.setVcenterUuid(createDsSubProcessor.getVcenterUuid());
        return processor;
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority() {
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor childProc : childProcessor) {
            int priValue = UNMOUNT_DS_PRIORITY;
            if (childProc instanceof VsUnmountLunSubProcessor) {
                priValue = UNMOUNT_LUN_PRIORITY;
            }
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(childProc);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(childProc);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }
}

