/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnregisterVmSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsUnregisterVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5541792266450647907L;
    private static final Log logger = LogFactory.getInstance(VsUnregisterVmProcessor.class);
    private static final int DEFAULT_START_PRI = 10;

    public boolean execute(RecoveryProcessorContext context) {
        boolean createResult;
        Set subProcessors = this.getChildProc();
        if ((null == subProcessors || subProcessors.isEmpty()) && !(createResult = this.createSubProcessors(context))) {
            logger.error((Object)"create subprocessors error.", 90160758786988L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority(context);
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithConcurrentSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        if (null != type && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION == type) {
            this.setProcName("com.huawei.ism.drm.vsphere.recovery.process.VsUnregisterVmProcessor.product");
        } else {
            this.setProcName(((Object)((Object)this)).getClass().getName());
        }
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> unregisterVmProcessors = null;
        int procType = this.getProcType();
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            unregisterVmProcessors = this.generatePlanAndSnashotProcessors(context);
        } else if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue()) {
            unregisterVmProcessors = this.generateClearProcessors(context);
        }
        this.setChildProc(unregisterVmProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Set<RecoveryProcessor> generateClearProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> result = new HashSet<RecoveryProcessor>();
        List startProcessors = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue() ? this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, VsInitVmSubProcessor.class) : this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, VsInitVmSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)startProcessors)) {
            logger.info((Object)"startBdSubProcessor is empty", 90160758786988L);
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        ProtectGroup pg = context.getProtectGroup();
        RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pg.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
        String vCenterUuid = setting.getValue();
        for (RecoveryProcessor p : startProcessors) {
            VsInitVmSubProcessor initVmSubProc = (VsInitVmSubProcessor)p;
            if (VerifyUtil.isEmpty((String)initVmSubProc.getVmMoId())) continue;
            VsUnregisterVmSubProcessor processor = new VsUnregisterVmSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setVmMoId(initVmSubProc.getVmMoId());
            processor.setVmName(initVmSubProc.getVmName());
            processor.setVcenterUuid(vCenterUuid);
            processor.setVmxPath(initVmSubProc.getVmxFilePath());
            processor.setIsPlanned(false);
            result.add((RecoveryProcessor)processor);
        }
        return result;
    }

    private Set<RecoveryProcessor> generatePlanAndSnashotProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (null == pg) {
            logger.error((Object)"pg in context is null.");
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            VsUnregisterVmSubProcessor processor = new VsUnregisterVmSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(po.getUuid());
            processor.setVmMoId(po.getMoUuid());
            processor.setVmName(po.getName());
            processor.setVcenterUuid(po.getProviderSN());
            processor.setVmxPath((String)po.getProps().get("VMPATH"));
            processor.setIsPlanned(this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue());
            subProcessors.add((RecoveryProcessor)processor);
        }
        return subProcessors;
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority(RecoveryProcessorContext context) {
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor process : childProcessor) {
            VsUnregisterVmSubProcessor subProcess = (VsUnregisterVmSubProcessor)process;
            String poId = subProcess.getPoId();
            int priValue = this.getStartPrimary(recoverySettings, poId);
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(process);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(process);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    private int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = Integer.parseInt(setting.getValue());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("parseInt error : " + setting.getValue()), (Throwable)e, -1L);
            }
            break;
        }
        return priValue;
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnregisterVmProcessor.pm.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnregisterVmProcessor.cr.des");
        }
    }
}

