/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.process.DeleteSnapshotMappingProcessor;
import com.huawei.ism.drm.virtualization.recovery.process.DeleteSnapshotMappingSubProcessor;
import com.huawei.ism.drm.virtualization.recovery.process.MappingSnapshotProcessor;
import com.huawei.ism.drm.virtualization.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CleanSnapshotMappingProcessor
extends DeleteSnapshotMappingProcessor {
    private static final Log logger = LogFactory.getInstance(CleanSnapshotMappingProcessor.class);
    private static final String PROCESS_NAME = "com.huawei.ism.drm.virtualization.recovery.process.DeleteSnapshotMappingProcessor1";
    private static final String COPY_MAPPING_KEY = "mappingForVmRecovery";
    private static final Class<? extends RecoveryProcessor> MAPPING_PROCESSOR = MappingSnapshotProcessor.class;
    private static final Class<? extends RecoveryProcessor> MAPPING_SUB_PROCESSOR = MappingSnapshotSubProcessor.class;
    private static final Set<String> LUN_NOT_FOUND = new HashSet<String>();
    private final DrmEnumDefine.RecoveryPlanExecuteTypeE procType = DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK;

    public String getName() {
        return PROCESS_NAME;
    }

    public void updateProcessName() {
    }

    public boolean execute(RecoveryProcessorContext context) {
        List<RecoveryProcessor> currentSnapshotProcessors;
        this.updateProcessName(PROCESS_NAME);
        if (this.isCleanMode(context)) {
            logger.info((Object)"get snapshots from db.");
            currentSnapshotProcessors = this.getHisSnapshotProcessors();
        } else {
            currentSnapshotProcessors = this.getCurrentExecutionMapping();
        }
        if (VerifyUtil.isEmpty(currentSnapshotProcessors)) {
            logger.info((Object)"no snapshots in db. no need to delete snapshot mapping.");
            return this.success();
        }
        Set delSnapshotMappingSubProcessors = this.createDelSnapshotMappingSubProcessors(currentSnapshotProcessors);
        this.setChildProc(delSnapshotMappingSubProcessors);
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(delSnapshotMappingSubProcessors));
        executor.process(context);
        this.calcProcessResultBySubProc();
        return true;
    }

    private List<RecoveryProcessor> getCurrentExecutionMapping() {
        RecoveryProcessorContext context = this.getContextRef();
        List subProcessorList = context.getObjects(COPY_MAPPING_KEY, MappingSnapshotSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)subProcessorList)) {
            logger.info((Object)"prev mapping subProcessor is empty.");
            return Collections.emptyList();
        }
        return subProcessorList.stream().map(proc -> proc).collect(Collectors.toList());
    }

    protected DrmEnumDefine.RecoveryPlanExecuteTypeE getProcTypeForQuery() {
        return this.procType;
    }

    private List<RecoveryProcessor> getHisSnapshotProcessors() {
        RecoveryProcessorContext context = this.getContextRef();
        List storageResources = (List)context.getAttribute("Target_Storage");
        if (VerifyUtil.isEmpty((Collection)storageResources)) {
            logger.info((Object)"target storage resource is empty.");
            return Collections.emptyList();
        }
        List<RecoveryProcessor> currentExecutionMapping = this.getCurrentExecutionMapping();
        Set filteredMappingProcSet = currentExecutionMapping.stream().filter(proc -> proc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(proc -> (MappingSnapshotSubProcessor)proc).map(RecoveryProcessor::getProcId).collect(Collectors.toSet());
        Set snapshotWwnSet = storageResources.stream().map(StorageResource::getResourceIndentifier).collect(Collectors.toSet());
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List<RecoveryProcessor> resultList = this.getRecoveryProcessors(recoveryPlan, this.getProcTypeForQuery(), MAPPING_SUB_PROCESSOR).stream().filter(proc -> !filteredMappingProcSet.contains(proc.getProcId())).collect(Collectors.toList());
        resultList = resultList.stream().filter(processor -> snapshotWwnSet.contains(((MappingSnapshotSubProcessor)processor).getSnapshotWWN())).collect(Collectors.toList());
        return resultList;
    }

    public void endRecoveryProcessor() {
        RecoveryProcessorContext context = this.getContextRef();
        if (this.isCleanMode(context)) {
            Set<String> deletedMappingUniqueKey = this.getChildProc().stream().filter(this::isNeedToDelete).map(this::createKey).collect(Collectors.toSet());
            List<RecoveryProcessor> mappingToDelete = this.getDeleteHistMapping(deletedMappingUniqueKey);
            IRecoveryProcessService service = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            mappingToDelete.forEach(arg_0 -> ((IRecoveryProcessService)service).deleteRecoveryProcessor(arg_0));
        }
        super.endRecoveryProcessor();
    }

    private List<RecoveryProcessor> getDeleteCurrentMapping(RecoveryProcessorContext context, Set<String> deletedMappingUniqueKeySet) {
        List subProcessors = context.getObjects(COPY_MAPPING_KEY, MappingSnapshotSubProcessor.class);
        subProcessors = Optional.ofNullable(subProcessors).orElse(new ArrayList());
        return subProcessors.stream().filter(mapping -> deletedMappingUniqueKeySet.contains(this.createKey((RecoveryProcessor)mapping))).collect(Collectors.toList());
    }

    private List<RecoveryProcessor> getDeleteHistMapping(Set<String> deletedMappingUniqueKeySet) {
        List mappingProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), this.getProcTypeForQuery(), MappingSnapshotSubProcessor.class);
        return mappingProcessors.stream().filter(mapping -> deletedMappingUniqueKeySet.contains(this.createKey((RecoveryProcessor)mapping))).collect(Collectors.toList());
    }

    private boolean isCleanMode(RecoveryProcessorContext context) {
        Object cleanModeObj = context.getAttribute("cleanModeForVm");
        return Optional.ofNullable(cleanModeObj).isPresent();
    }

    private boolean isNeedToDelete(RecoveryProcessor child) {
        if (child.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return true;
        }
        String procDetail = Optional.ofNullable(child.getProcDetail()).orElse("");
        return LUN_NOT_FOUND.contains(procDetail);
    }

    private String createKey(RecoveryProcessor child) {
        if (child instanceof DeleteSnapshotMappingSubProcessor) {
            DeleteSnapshotMappingSubProcessor subProcessor = (DeleteSnapshotMappingSubProcessor)child;
            return subProcessor.getLunId() + ":" + subProcessor.getDeviceId() + ":" + subProcessor.getSnapshotId() + ":" + subProcessor.getSnapshotName();
        }
        if (child instanceof MappingSnapshotSubProcessor) {
            MappingSnapshotSubProcessor subProcessor = (MappingSnapshotSubProcessor)child;
            return subProcessor.getLunId() + ":" + subProcessor.getDeviceId() + ":" + subProcessor.getSnapshotId() + ":" + subProcessor.getSnapshotName();
        }
        return "";
    }

    static {
        LUN_NOT_FOUND.add("lego.err.1073810433");
        LUN_NOT_FOUND.add("lego.err.1077936859");
        LUN_NOT_FOUND.add("lego.err.50338574");
        LUN_NOT_FOUND.add("lego.err.1077937922");
        LUN_NOT_FOUND.add("lego.err.1077951816");
        LUN_NOT_FOUND.add("lego.err.1073744683");
    }
}

