/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVirtualMachineDiskTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class ConfigMigratedVmDiskTask
extends ConfigVirtualMachineDiskTask {
    public static final String NO_TARGET_VM = "com.huawei.ism.drm.vsphere.recovery.common.targetVmEmpty";
    private static final Log logger = LogFactory.getInstance(ConfigMigratedVmDiskTask.class);
    private VsphereVirtualMachine targetVm;
    private Map<String, String> dsChangeMap;

    public ConfigMigratedVmDiskTask() {
    }

    public ConfigMigratedVmDiskTask(VsphereVirtualMachine vm, RecoveryProcessor parentProcessor, Map<String, String> dsChangeMap) {
        super(vm, parentProcessor);
        this.targetVm = vm;
        this.dsChangeMap = dsChangeMap;
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)this.getTargetVm())) {
            logger.error((Object)"no target vm.");
            this.updateProcessNameParams(new String[]{"--"});
            throw new LegoCheckedException(NO_TARGET_VM);
        }
        this.updateProcessNameParams(new String[]{this.getTargetVm().getName()});
        return super.execute(context);
    }

    @Override
    protected Map<String, String> getDatastoreUrlMap() {
        if (VerifyUtil.isEmpty(this.dsChangeMap)) {
            logger.error((Object)"datastore change map is empty: vmName=%s", new Object[]{this.getTargetVm().getName()});
            throw new LegoCheckedException(2117645L);
        }
        return new HashMap<String, String>(this.dsChangeMap);
    }

    public VsphereVirtualMachine getTargetVm() {
        return this.targetVm;
    }
}

