/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.google.common.collect.Sets;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVirtualMachineRdmDiskSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.StorageResourceFinder;
import com.huawei.ism.drm.vsphere.sdk.model.VmConfigRdmInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigVirtualMachineRdmDiskTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(ConfigVirtualMachineRdmDiskTask.class);
    private static final HashSet<Integer> availableUnitNumSet = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15});
    private static final List<Integer> RDM_DISK_TYPES = Arrays.asList(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue());
    private static final List<String> VM_DISK_MODES = Arrays.asList("physicalMode", "virtualMode");
    private DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E type;
    private VsphereVirtualMachine virtualMachine;

    public ConfigVirtualMachineRdmDiskTask() {
    }

    public ConfigVirtualMachineRdmDiskTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E type) {
        this.virtualMachine = virtualMachine;
        this.setParentProc(parentProc);
        this.type = type;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.virtualMachine.getName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.rdm.already.config", new String[0]);
            return true;
        }
        this.createConfigRdmDiskSubTask(context);
        return this.serialExcuteChildProc(context);
    }

    private void createConfigRdmDiskSubTask(RecoveryProcessorContext context) {
        Map<String, String> productAndRecoveryWwnMap = this.solveProductAndRecoveryWwn();
        HashSet<ConfigVirtualMachineRdmDiskSubTask> subProcessors = new HashSet<ConfigVirtualMachineRdmDiskSubTask>();
        Set<VmVirtualDisk> diskSet = this.getConfigVmDiskSet(context);
        if (this.type == DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.Add) {
            this.setTargetVmDisMountParamsSet(context, diskSet);
            this.virtualMachine.setVirtualDisk(diskSet);
        }
        for (VmVirtualDisk disk : diskSet) {
            int storageType = disk.getDiskType();
            if (!RDM_DISK_TYPES.contains(storageType)) continue;
            String dcMoId = this.virtualMachine.getDcMoId();
            String vmPath = this.virtualMachine.getVmPath();
            String dataStoreName = VsphereCommUtil.getDatastoreName(vmPath);
            String newRdmFileName = disk.getStorageFileName().replaceFirst("(?<=\\[)(.*)(?=\\])", dataStoreName);
            List<VsphereDataStore> dataStoreList = new DataStoreAction().queryAllDsWithoutValidate((String)context.getAttribute("Target_vCenter"));
            Optional<VsphereDataStore> dataStoreOptional = dataStoreList.stream().filter(ds -> dataStoreName.equals(ds.getName())).findFirst();
            if (!dataStoreOptional.isPresent()) {
                logger.error((Object)"Config lun or snapshot of rdm disk[%s], but dataStore cannot find.", new Object[]{dataStoreName});
                throw new LegoCheckedException(2117645L);
            }
            String storageResourceWwn = "";
            String dataStoreOrLunUuid = disk.getDataStoreOrLunUuid();
            logger.info((Object)"Product storage wwn: %s.", new Object[]{dataStoreOrLunUuid});
            for (Map.Entry<String, String> wwn : productAndRecoveryWwnMap.entrySet()) {
                if (!dataStoreOrLunUuid.contains(wwn.getKey())) continue;
                storageResourceWwn = wwn.getValue();
            }
            if (VerifyUtil.isEmpty((String)storageResourceWwn)) {
                logger.error((Object)"Config rdm disk[wwn: %s], but replica storage cannot find.", new Object[]{storageResourceWwn});
                throw new LegoCheckedException(1073947393L);
            }
            VmConfigRdmInfo info = this.getVmConfigRdmInfo(dataStoreOptional.get(), dcMoId, storageResourceWwn, newRdmFileName, storageType);
            info.setVmVirtualDisk(disk);
            ConfigVirtualMachineRdmDiskSubTask configRdmDiskSubTask = new ConfigVirtualMachineRdmDiskSubTask(info, this.type);
            configRdmDiskSubTask.setParentProc((RecoveryProcessor)this);
            subProcessors.add(configRdmDiskSubTask);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Set<VmVirtualDisk> getConfigVmDiskSet(RecoveryProcessorContext context) {
        if (this.type == DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.REMOVE) {
            return this.getFilterVmDiskBeforeDelete(context);
        }
        return this.virtualMachine.getVirtualDisk();
    }

    private Set<VmVirtualDisk> getFilterVmDiskBeforeDelete(RecoveryProcessorContext context) {
        VsphereVirtualMachine vmInVcenter = this.getTargetVmInVcenter(context);
        if (VerifyUtil.isEmpty((Object)vmInVcenter)) {
            throw new LegoCheckedException(1073947393L, "vmInVcenter is null");
        }
        Set vCenterDiskSet = vmInVcenter.getVirtualDisk();
        Set mountedDiskSet = this.virtualMachine.getVirtualDisk();
        HashSet<VmVirtualDisk> disksAfterFilterSet = new HashSet<VmVirtualDisk>();
        for (VmVirtualDisk disk : mountedDiskSet) {
            for (VmVirtualDisk vCenterDisk : vCenterDiskSet) {
                if (!disk.getUnitNumber().equals(vCenterDisk.getUnitNumber())) continue;
                disk.setStorageFileName(vCenterDisk.getStorageFileName());
                disk.setDeviceKey(vCenterDisk.getDeviceKey());
                disksAfterFilterSet.add(disk);
            }
        }
        return disksAfterFilterSet;
    }

    private VmConfigRdmInfo getVmConfigRdmInfo(VsphereDataStore dataStore, String dcMoId, String storageResourceWwn, String rdmDiskFileName, int diskType) {
        VmConfigRdmInfo configRdmInfo = new VmConfigRdmInfo();
        configRdmInfo.setDataStore(dataStore);
        configRdmInfo.setDcMoId(dcMoId);
        configRdmInfo.setStorageResourceWwn(storageResourceWwn);
        configRdmInfo.setRdmDiskFileName(rdmDiskFileName);
        configRdmInfo.setDiskType(diskType);
        configRdmInfo.setVirtualMachine(this.virtualMachine);
        return configRdmInfo;
    }

    private void setTargetVmDisMountParamsSet(RecoveryProcessorContext context, Set<VmVirtualDisk> diskSet) {
        VsphereVirtualMachine vm = this.getTargetVmInVcenter(context);
        if (vm == null) {
            return;
        }
        Set diskSetInVcenter = vm.getVirtualDisk();
        HashSet exitUnitNumberSet = new HashSet();
        diskSetInVcenter.forEach(disk -> exitUnitNumberSet.add(disk.getUnitNumber()));
        List usableNumberList = availableUnitNumSet.stream().filter(exitNumber -> !exitUnitNumberSet.contains(exitNumber)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(usableNumberList)) {
            logger.error((Object)"No available disk node exists.");
            throw new LegoCheckedException(-1L);
        }
        Optional opt = diskSetInVcenter.stream().findFirst();
        if (!opt.isPresent()) {
            return;
        }
        int controllerKey = ((VmVirtualDisk)opt.get()).getControllerKey();
        int index = 0;
        for (VmVirtualDisk disk2 : diskSet) {
            if (diskSet.size() > usableNumberList.size()) {
                logger.error((Object)"No available disk node exists. usableNumberList= %s; diskSet= %s", new Object[]{usableNumberList.size(), diskSet.size()});
                throw new LegoCheckedException(-1L);
            }
            if (!RDM_DISK_TYPES.contains(disk2.getDiskType())) continue;
            if (index >= usableNumberList.size()) {
                logger.error((Object)"value of index= %s", (long)index);
                throw new LegoCheckedException(-1L);
            }
            disk2.setUnitNumber((Integer)usableNumberList.get(index++));
            disk2.setControllerKey(Integer.valueOf(controllerKey));
        }
    }

    private VsphereVirtualMachine getTargetVmInVcenter(RecoveryProcessorContext context) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(GetMoPropsValueUtils.getInstance().getMoid(this.virtualMachine.getVmMoId()));
        VMAction vmAction = new VMAction();
        List<VsphereVirtualMachine> allVms = vmAction.queryAllVms(conn);
        Optional<VsphereVirtualMachine> opt = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue() ? allVms.stream().filter(vm -> vm.getVmMoId().equals(this.virtualMachine.getVmMoId())).findFirst() : allVms.stream().filter(vm -> vm.getUuid().equals(this.virtualMachine.getUuid())).findAny();
        return opt.orElse(null);
    }

    private Map<String, String> solveProductAndRecoveryWwn() {
        RecoveryProcessorContext context = this.getContextRef();
        List resources = context.getObjects("Target_Storage", StorageResource.class);
        HashMap<String, String> productAndRecoveryWwnMap = new HashMap<String, String>();
        StorageResourceFinder storageResourceFinder = new StorageResourceFinder(context);
        for (StorageResource storageResource : resources) {
            String isReuseWwn;
            logger.info((Object)"Finding storage resource with wwn[%s].", new Object[]{storageResource.getResourceIndentifier()});
            ProtectObjectStorageInfo poStorageInfo = storageResourceFinder.getProtectObjectStorageInfo(storageResource);
            logger.debug((Object)"Found protect object storage info: [%s].", new Object[]{poStorageInfo.toJSONObject()});
            Map props = this.virtualMachine.getProps();
            String string = isReuseWwn = VerifyUtil.isEmpty((Map)props) ? "" : (String)props.get("REUSE_RDM_WWN");
            if ("true".equals(isReuseWwn)) {
                productAndRecoveryWwnMap.put(poStorageInfo.getLunWWN(), poStorageInfo.getLunWWN());
            } else {
                productAndRecoveryWwnMap.put(poStorageInfo.getLunWWN(), storageResource.getResourceIndentifier());
            }
            logger.debug((Object)"Storage wwn: [product: %s], [recovery: %s].", new Object[]{poStorageInfo.getLunWWN(), storageResource.getResourceIndentifier()});
        }
        return productAndRecoveryWwnMap;
    }
}

