/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DeleteVmFromDiskSubTask
extends OperateVsphereVmSubTask {
    private static final Log logger = LogFactory.getInstance(DeleteVmFromDiskSubTask.class);
    private static final String TARGET_VM_NOT_EXIST = "com.huawei.ism.drm.vsphere.recovery.task.DeleteVmFromDiskSubTask.targetVmNotExist";
    private static final String TARGET_VM_EMPTY = "com.huawei.ism.drm.vsphere.recovery.common.targetVmEmpty";

    public DeleteVmFromDiskSubTask(RecoveryProcessorContext ctx, VsphereVirtualMachine vm) {
        this.setContextRef(ctx);
        this.setVm(vm);
    }

    public DeleteVmFromDiskSubTask() {
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        if (this.getVm() == null) {
            logger.info((Object)"none vm to delete, as deleted.");
            this.updateProcessNameParams(new String[]{"--"});
            return this.success(TARGET_VM_EMPTY, null);
        }
        return super.execute(context);
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        boolean isSucc;
        VsphereVirtualMachine vm = this.getVm();
        VerifyUtil.checkObjs((Object[])new Object[]{vm});
        this.updateProcessNameParams(new String[]{vm.getName()});
        VerifyUtil.checkObjs((Object[])new Object[]{vm.getVmMoId(), vm.getDcMoId(), vm.getVmPath()});
        VMAction vmAction = new VMAction();
        String vCenterUuid = context.getProtectGroup().getPoProviderSN();
        ManagedObjectReference vmByPath = vmAction.findVmByPath(vCenterUuid, vm.getDcMoId(), vm.getVmPath());
        if (vmByPath == null) {
            logger.info((Object)"vm does not exist, as deleted: vmName=%s", new Object[]{vm.getName()});
            return this.success(TARGET_VM_NOT_EXIST, new String[]{vm.getName()});
        }
        try {
            isSucc = vmAction.deleteVmFromDisk(vCenterUuid, vm.getVmMoId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"failed to delete vm(moId=%s, vmPath=%s): %s", new Object[]{vm.getVmMoId(), vm.getVmPath(), ExceptionUtil.getErrorMessage((Throwable)e)});
            Object isCleanMode = context.getAttribute("cleanModeForVm");
            if (!VerifyUtil.isEmpty((Object)isCleanMode)) {
                return this.unregisterVmIfInClean(context, vm);
            }
            throw e;
        }
        return isSucc ? this.success() : this.failure();
    }

    private boolean unregisterVmIfInClean(RecoveryProcessorContext context, VsphereVirtualMachine vm) {
        logger.info((Object)"ready to unregister vm: vmMoId=%s, vmName=%s", new Object[]{vm.getVmMoId(), vm.getName()});
        List vmList = context.getObjects("latestVmsFromVCenter", VsphereVirtualMachine.class);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            logger.info((Object)"latest vms is empty.");
            return false;
        }
        Optional<VsphereVirtualMachine> vmToUnregisterOpt = vmList.stream().filter(vmTemp -> vmTemp.getVmMoId().equals(vmTemp.getVmMoId())).findFirst();
        if (!vmToUnregisterOpt.isPresent()) {
            logger.info((Object)"vm(vmMoId=%s, vmPath=%s) not found in vCenter", new Object[]{vm.getVmMoId(), vm.getVmPath()});
            return true;
        }
        VsphereVirtualMachine vmToUnregister = vmToUnregisterOpt.get();
        Set virtualDisk = vmToUnregister.getVirtualDisk();
        long count = virtualDisk.stream().filter(this::isInvalidDisk).count();
        if (count > 0L) {
            logger.info((Object)"invalid disk exists, ready to unregister vm: %s", new Object[]{vmToUnregister.getVmMoId()});
            VMAction vmAction = new VMAction();
            String vCenterUuid = (String)context.getAttribute("Target_vCenter");
            return vmAction.unregisterVM(vCenterUuid, vmToUnregister.getVmMoId());
        }
        logger.info((Object)"no invalid disk, no need to unregister vm, as deleted failed: vmMoId=%s, vmName=%s", new Object[]{vmToUnregister.getVmMoId(), vmToUnregister.getName()});
        return false;
    }

    private boolean isInvalidDisk(VmVirtualDisk disk) {
        String vmfs;
        String storageType = disk.getStorageType();
        String dsUuid = storageType.equals(vmfs = "VMFS") ? disk.getDataStoreOrLunUuid() : disk.getContentDataStoreUuid();
        return VerifyUtil.isEmpty((String)dsUuid) || dsUuid.endsWith(":");
    }
}

