/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMGroupPriSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class PowerOnVMTask
extends BaseRecoveryProcessor {
    private static final int DEFAULT_START_PRI = 10;
    private static final Log logger = LogFactory.getInstance(PowerOnVMTask.class);

    protected boolean execute(RecoveryProcessorContext context) {
        List virtualMachineList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        if (VerifyUtil.isEmpty((Collection)virtualMachineList)) {
            List targetVmList = context.getObjects("Rdm_Target_VM", VsphereVirtualMachine.class);
            if (!CollectionUtils.isEmpty((Collection)targetVmList)) {
                logger.info((Object)"not find powerOn target virtual machine and has rdm config vm.");
            }
            logger.info((Object)"Cannot find powerOn target virtual machine recovery context");
            return this.success("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMTask.noStratVM", null);
        }
        this.createSubProcessors(context);
        Set subProcSet = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)subProcSet)) {
            return this.success("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMTask.noStratVM", null);
        }
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)this.getChildProc());
        if (recoveryTemplate == null) {
            logger.error((Object)"CreateRecoveryProcessExecutorSort failed.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void createSubProcessors(RecoveryProcessorContext context) {
        Map<Integer, List<VsphereVirtualMachine>> posWithPriority = this.getPosByPriority(context);
        HashSet<PowerOnVMGroupPriSubTask> subProcSet = new HashSet<PowerOnVMGroupPriSubTask>();
        if (VerifyUtil.isEmpty(posWithPriority)) {
            logger.info((Object)"All vms should not be started");
            this.setChildProc(subProcSet);
            return;
        }
        ArrayList<Integer> priorityLevelList = new ArrayList<Integer>(posWithPriority.keySet());
        Collections.sort(priorityLevelList, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg0.compareTo(arg1);
            }
        });
        PowerOnVMGroupPriSubTask preProc = null;
        for (Integer startPriority : priorityLevelList) {
            List<VsphereVirtualMachine> currentPriorityVmList = posWithPriority.get(startPriority);
            if (currentPriorityVmList == null || currentPriorityVmList.isEmpty()) {
                logger.info((Object)("StartPriority " + startPriority + " not have vm start"));
                continue;
            }
            PowerOnVMGroupPriSubTask subTask = new PowerOnVMGroupPriSubTask(currentPriorityVmList, (RecoveryProcessor)this);
            subTask.setPriorityNum(startPriority);
            subTask.setPreviousProcessor((RecoveryProcessor)preProc);
            subTask.setNextProcessor(null);
            if (null != preProc) {
                preProc.setNextProcessor((RecoveryProcessor)subTask);
            }
            preProc = subTask;
            subProcSet.add(subTask);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Map<Integer, List<VsphereVirtualMachine>> getPosByPriority(RecoveryProcessorContext context) {
        List tmpVmList = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        List<VsphereVirtualMachine> allVmList = this.getVsphereVirtualMachines(context, tmpVmList);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        HashMap<Integer, List<VsphereVirtualMachine>> posWithPriority = new HashMap<Integer, List<VsphereVirtualMachine>>();
        for (VsphereVirtualMachine vm : allVmList) {
            ProtectObject po = this.getProtectObjectByPoId(vm.getUuid(), context);
            if (po != null) {
                boolean isTemplateVm = this.isTemplateVm(po);
                if (isTemplateVm || ProtectObjectStatusEnum.INVALID.getValue() == po.getPoStatus() || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == po.getPoStatus()) {
                    logger.info((Object)("vm[" + vm.getName() + "] isTemplateVm or ProtectObjectStatus is INVALID, UNSUPPORTED should not start"));
                    continue;
                }
            } else {
                logger.error((Object)("vm poid=" + vm.getUuid() + " not find ProtectObject."));
            }
            if (!context.getAttributeKeys().contains("noPoweredOnVmUuidList") && !VsphereRecoveryUtils.getInstance().isPoNeedStart(vm.getUuid(), context.getRecoveryPlan()).booleanValue()) {
                logger.info((Object)("The vm has been configured not start:vmName=" + vm.getName()));
                continue;
            }
            Integer priValue = this.getStartPrimary(recoverySettings, vm.getUuid());
            if (posWithPriority.containsKey(priValue)) {
                ((List)posWithPriority.get(priValue)).add(vm);
                continue;
            }
            ArrayList<VsphereVirtualMachine> processList = new ArrayList<VsphereVirtualMachine>();
            processList.add(vm);
            posWithPriority.put(priValue, processList);
        }
        return posWithPriority;
    }

    private List<VsphereVirtualMachine> getVsphereVirtualMachines(RecoveryProcessorContext context, List<VsphereVirtualMachine> tmpVmList) {
        ArrayList<VsphereVirtualMachine> allVmList = new ArrayList();
        List noPowerOnVmUuids = (List)context.getAttribute("noPoweredOnVmUuidList");
        if (CollectionUtils.isEmpty((Collection)noPowerOnVmUuids)) {
            allVmList = tmpVmList;
        } else {
            for (VsphereVirtualMachine vm : tmpVmList) {
                if (noPowerOnVmUuids.contains(vm.getUuid())) continue;
                allVmList.add(vm);
            }
        }
        return allVmList;
    }

    private ProtectObject getProtectObjectByPoId(String poId, RecoveryProcessorContext context) {
        ProtectObject po = null;
        Set poList = context.getRecoveryProtectObjects();
        for (ProtectObject item : poList) {
            if (!poId.equals(item.getUuid())) continue;
            return item;
        }
        poList = context.getProtectGroup().getPolist();
        for (ProtectObject item : poList) {
            if (!poId.equals(item.getUuid())) continue;
            return item;
        }
        return po;
    }

    private boolean isTemplateVm(ProtectObject po) {
        if (null == po || null == po.getProps().get("ISTEMPLATE")) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean((String)po.getProps().get("ISTEMPLATE"));
    }

    private int getStartPrimary(Set<RecoverySetting> recoverySettings, String poId) {
        int priValue = 10;
        for (RecoverySetting setting : recoverySettings) {
            if (!setting.getOwnerId().equals(poId) || !setting.getName().equals("startOrder")) continue;
            try {
                priValue = Integer.parseInt(setting.getValue());
            }
            catch (NumberFormatException e) {
                logger.error((Object)("parseInt error : " + setting.getValue() + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
            break;
        }
        return priValue;
    }
}

