/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.model.VmMappingRdmInfo;
import com.huawei.ism.drm.vsphere.recovery.task.VMwareRecoveryTaskInterceptor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.RecoveryTargetBean;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class RecoveryAlternateTargetPreparer
extends VMwareRecoveryTaskInterceptor {
    private static final Log logger = LogFactory.getInstance(RecoveryAlternateTargetPreparer.class);

    public RecoveryAlternateTargetPreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        String dcMoId = plan.getProperty("VSDATACENTERID");
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Assert.notNull((Object)replica, (String)"Connot find ProtectGroup Replica from recovery context.");
        this.setVmContextWithConfig(context);
        ArrayList<VsphereVirtualMachine> vsphereVirtualMachines = new ArrayList<VsphereVirtualMachine>();
        Set protectObjectReplicaSet = replica.getReplicas();
        List<VmMappingRdmInfo> vmMappingRdmInfos = this.getMappingVmLists(context);
        List<String> unRegisterVmUuids = this.getUnregisterVmList(context);
        HashMap<String, VsphereVirtualMachine> targetVmMap = new HashMap<String, VsphereVirtualMachine>();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaSet) {
            VsphereVirtualMachine virtualMachine;
            ProtectObject protectObject = protectObjectReplica.getProtectObject();
            if (null == protectObject) continue;
            int procType = this.getInterceptTask().getProcType();
            List selectedVmUuids = (List)context.getAttribute("selectedVmMoIdList");
            if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue() && !VerifyUtil.isEmpty((Collection)selectedVmUuids) && !selectedVmUuids.contains(protectObject.getUuid()) || null == (virtualMachine = VsphereVirtualMachineUtils.convertFrom(protectObject))) continue;
            Optional<VmMappingRdmInfo> opt = vmMappingRdmInfos.stream().filter(rdmMappingInfo -> Objects.equals(rdmMappingInfo.getOriVmUuid(), virtualMachine.getUuid())).findAny();
            if (opt.isPresent()) {
                virtualMachine.setDcMoId(dcMoId);
                this.setTargetVmWithOriVmVirtualDisk(opt.get(), virtualMachine, targetVmMap);
                continue;
            }
            if (!CollectionUtils.isEmpty(unRegisterVmUuids) && unRegisterVmUuids.contains(virtualMachine.getUuid())) continue;
            virtualMachine.setDcMoId(dcMoId);
            vsphereVirtualMachines.add(virtualMachine);
        }
        if (targetVmMap.size() != 0) {
            Collection valueCollection = targetVmMap.values();
            ArrayList targetVmList = new ArrayList(valueCollection);
            context.setAttribute("Rdm_Target_VM", targetVmList);
        }
        context.setAttribute("Target_VM", vsphereVirtualMachines);
    }

    private void setTargetVmWithOriVmVirtualDisk(VmMappingRdmInfo info, VsphereVirtualMachine oriVm, Map<String, VsphereVirtualMachine> targetVmMap) {
        VsphereVirtualMachine targetVm;
        String targetVmUuid = info.getTargetVmUuid();
        if (targetVmMap.containsKey(targetVmUuid)) {
            targetVm = targetVmMap.get(targetVmUuid);
        } else {
            targetVm = this.getVmByUuid(targetVmUuid);
            targetVmMap.put(targetVmUuid, targetVm);
        }
        Set targetVd = targetVm.getVirtualDisk();
        Set oriVmVdSet = oriVm.getVirtualDisk();
        List mappingRdms = info.getMappingRdms();
        oriVmVdSet.forEach(oriVmVd -> {
            if (mappingRdms.contains(oriVmVd.getStorageFileName())) {
                targetVd.add(oriVmVd);
            }
        });
        targetVm.setVirtualDisk(targetVd);
        targetVm.setDcMoId(oriVm.getDcMoId());
    }

    private VsphereVirtualMachine getVmByUuid(String uuid) {
        return (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)uuid);
    }

    private List<VmMappingRdmInfo> getMappingVmLists(RecoveryProcessorContext context) {
        ArrayList<VmMappingRdmInfo> vmMappingRdmsList = new ArrayList<VmMappingRdmInfo>();
        Map globalSettingMap = context.getRecoveryPlan().getGlobalSettings();
        if (!globalSettingMap.containsKey("mappingRdmsInfo")) {
            return vmMappingRdmsList;
        }
        JSONArray jsonArray = JSONArray.fromObject(globalSettingMap.get("mappingRdmsInfo"));
        if (jsonArray.size() == 0) {
            return vmMappingRdmsList;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            VmMappingRdmInfo rdmInfo = (VmMappingRdmInfo)JSONObject.toBean((JSONObject)json, VmMappingRdmInfo.class);
            vmMappingRdmsList.add(rdmInfo);
        }
        return vmMappingRdmsList;
    }

    private void setVmContextWithConfig(RecoveryProcessorContext context) {
        Map globalSettingMap = context.getRecoveryPlan().getGlobalSettings();
        if (globalSettingMap.containsKey("noPoweredOnVmUuidList")) {
            JSONArray array = JSONArray.fromObject(globalSettingMap.get("noPoweredOnVmUuidList"));
            List notPowerOnVmUuids = JSONArray.toCollection((JSONArray)array, String.class);
            context.setAttribute("noPoweredOnVmUuidList", (Object)notPowerOnVmUuids);
        }
    }

    private List<String> getUnregisterVmList(RecoveryProcessorContext context) {
        JSONArray jsonArray;
        List<String> unRegisters = new ArrayList<String>();
        Map globalSettingMap = context.getRecoveryPlan().getGlobalSettings();
        if (globalSettingMap.containsKey("unregisterVmUuidList") && (jsonArray = JSONArray.fromObject(globalSettingMap.get("unregisterVmUuidList"))).size() != 0) {
            unRegisters = JSONArray.toCollection((JSONArray)jsonArray, String.class);
        }
        return unRegisters;
    }

    @Override
    public void prepareTargetHost(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        RecoveryTargetBean targetBean = this.loadRecoveryTargetHost(context);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("computeResourceUuid", targetBean.getRemoteHostId());
        context.setAttribute("computeResourceUuid", (Object)targetBean.getRemoteHostId());
        ArrayList vsphereHostSystemList = new ArrayList();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        vsphereHostSystemList.addAll(moDao.findMoBy(VsphereHostSystem.class, props));
        context.setAttribute("Target_Host", vsphereHostSystemList);
    }

    @Override
    public void prepareTargetStoreageResource(RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Assert.notNull((Object)replica, (String)"Connot find ProtectGroup Replica from recovery context.");
        Set protectObjectReplicaSet = replica.getReplicas();
        ArrayList<StorageResource> storageResourceList = new ArrayList<StorageResource>();
        HashSet relicaStorageInfoSet = new HashSet();
        protectObjectReplicaSet.forEach(poReplica -> relicaStorageInfoSet.addAll(poReplica.getStorageInfos()));
        for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfoSet) {
            StorageResource storageResource = new StorageResource();
            String deviceSn = relicaStorageInfo.getStorageProviderSN();
            storageResource.setDevSn(deviceSn);
            storageResource.setResourceId(relicaStorageInfo.getStorageId());
            String wwn = relicaStorageInfo.getProtectObjectStorageWwn();
            if (null != wwn && wwn.contains(":")) {
                storageResource.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()));
            } else {
                storageResource.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
            }
            storageResourceList.add(storageResource);
        }
        context.setAttribute("Target_Storage", storageResourceList);
        this.updateTargetStorageResourceWwn(context);
    }

    @Override
    public void prepareTargetVCenter(RecoveryProcessorContext context) {
        RecoveryTargetBean target = this.loadRecoveryTargetHost(context);
        context.setAttribute("Target_vCenter", (Object)target.getRemoteVcenterId());
    }

    protected void updateTargetStorageResourceWwn(RecoveryProcessorContext context) {
    }

    private RecoveryTargetBean loadRecoveryTargetHost(RecoveryProcessorContext context) {
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        String key = (String)context.getAttribute("TargetHostKey");
        logger.debug((Object)"Recovery target type is %s", new Object[]{key});
        String recoveryHosts = plan.getProperty(key);
        logger.debug((Object)"Recovery hosts is %s", new Object[]{recoveryHosts});
        Collection recoveryTargets = plan.getProperties(key, RecoveryTargetBean.class);
        RecoveryTargetBean targetBean = null;
        if (null != recoveryTargets && !recoveryTargets.isEmpty()) {
            targetBean = (RecoveryTargetBean)recoveryTargets.iterator().next();
        }
        if (null == targetBean) {
            logger.error((Object)"Cannto load recovery hosts from recovery plan gloable settings");
            throw new LegoCheckedException(1073947393L);
        }
        return targetBean;
    }
}

