/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.recovery.task.RecoverySourcePreparer;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;

public class RecoveryVMResourcePreparer
extends RecoverySourcePreparer {
    public static final String NAME_SUFFIX = "snap";
    private static final Log logger = LogFactory.getInstance(RecoveryVMResourcePreparer.class);
    private static final String ALL_DATASTORE_KEY = "allDatastoreKey";
    private static final String SELECTED_LUN_WWN = "selectedLunWwn";
    private static final Set<String> RDM_DISK_TYPE = Sets.newHashSet((Object[])new String[]{"physicalMode", "virtualMode"});
    private static final Set<Integer> RDM_DISK_TYPE_SET = Sets.newHashSet((Object[])new Integer[]{DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue()});

    public RecoveryVMResourcePreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public boolean before() {
        BaseRecoveryProcessor interceptTask = this.getInterceptTask();
        RecoveryProcessorContext context = interceptTask.getContextRef();
        this.checkContext(context);
        boolean isRemoteVmRollback = VsphereRecoveryUtils.isRemoteVmRollbackScenario(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK);
        logger.info((Object)"Sets the remote VM recovery flag(%s). plan=%s", new Object[]{isRemoteVmRollback, context.getRecoveryPlan().getName()});
        context.setAttribute("isRemoteVmRollback", (Object)isRemoteVmRollback);
        context.setAttribute("migrationtype", (Object)Integer.parseInt((String)interceptTask.getProps().get("migrationtype")));
        context.setAttribute("NameSuffixKey", (Object)NAME_SUFFIX);
        context.getRecoveryPlan().getGlobalSettings().put("PG_DISASTER_HOST", context.getProtectGroup().getPoProviderSN());
        String vCenter = context.getProtectGroup().getPoProviderSN();
        DataStoreAction dataStoreAction = new DataStoreAction();
        List<VsphereDataStore> dataStoreList = dataStoreAction.queryAllDsWithoutValidate(vCenter);
        context.setAttribute(ALL_DATASTORE_KEY, dataStoreList);
        interceptTask.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        for (RecoveryProcessor tmpNextProcessor = interceptTask.getNextProcessor(); tmpNextProcessor != null; tmpNextProcessor = tmpNextProcessor.getNextProcessor()) {
            tmpNextProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        }
        try {
            return super.before();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"vm prepare failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            interceptTask.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)"vm prepare failed with unknown error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            interceptTask.failure(new LegoCheckedException(1073947393L));
        }
        return false;
    }

    public boolean after() {
        BaseRecoveryProcessor baseRecoveryProcessor = this.getInterceptTask();
        VerifyUtil.checkObjs((Object[])new Object[]{baseRecoveryProcessor});
        if (baseRecoveryProcessor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue()) {
            return false;
        }
        RecoveryProcessorContext contextRef = baseRecoveryProcessor.getContextRef();
        this.checkContext(contextRef);
        this.filterRecoveryTask(contextRef);
        this.updateSlaveKeyInTasks(contextRef);
        this.addMappingInfo(contextRef);
        this.updateDataConsistencyCheck(contextRef);
        return true;
    }

    private void updateSlaveKeyInTasks(RecoveryProcessorContext contextRef) {
        HashMap<String, Integer> poAndTypeMap = new HashMap<String, Integer>();
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)contextRef.getAttribute("Recovery_PgReplica");
        Set replicas = protectGroupReplica.getReplicas();
        for (ProtectObjectReplica poReplica : replicas) {
            if (!poReplica.getPgReplica().isLocalStorageSnapshotReplica()) continue;
            String poId = poReplica.getPoId();
            Set storageInfos = poReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageInfos) {
                String poResKey = (String)poId + ":" + storageInfo.getStorageId();
                poAndTypeMap.put(poResKey, poReplica.getProtectObject().getPoType());
            }
        }
        HashMap slaveKeyMap = new HashMap();
        Set pgReplicaList = contextRef.getProtectGroup().getReplicaList();
        for (ProtectGroupReplica pgReplica : pgReplicaList) {
            if (!pgReplica.isLocalStorageSnapshotReplica()) continue;
            Set poReplicaSet = pgReplica.getReplicas();
            poReplicaSet.forEach(protectObjectReplica -> protectObjectReplica.getStorageInfos().forEach(replicaStorageInfo -> this.fillMapWithSlaveKey((RelicaStorageInfo)replicaStorageInfo, slaveKeyMap, poAndTypeMap)));
        }
        Collection recoveryTasks = (Collection)contextRef.getAttribute("recoveryTasks");
        if (!VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            recoveryTasks.forEach(recoveryTask -> this.updateMapInTask((RecoveryTask)recoveryTask, slaveKeyMap, (Map<String, Integer>)poAndTypeMap, contextRef.getProtectGroup().getUuid()));
        }
    }

    private void filterRecoveryTask(RecoveryProcessorContext contextRef) {
        Collection recoveryTasks = (Collection)contextRef.getAttribute("recoveryTasks");
        HashSet wwnSet = (HashSet)contextRef.getAttribute(SELECTED_LUN_WWN);
        logger.info((Object)"recovery vm resource prepare before select wwn :%s, recover task nums:%s", new Object[]{wwnSet.toString(), recoveryTasks.size()});
        ArrayList filteredTask = new ArrayList();
        if (!VerifyUtil.isEmpty((Collection)recoveryTasks) && !VerifyUtil.isEmpty((Collection)wwnSet)) {
            for (String wwn : wwnSet) {
                recoveryTasks.stream().filter(task -> task.getSrcStorageWwns().contains(wwn)).forEach(filteredTask::add);
            }
        }
        logger.info((Object)"recovery vm resource prepare after select wwn :%s, recover task nums:%s", new Object[]{wwnSet.toString(), filteredTask.size()});
        contextRef.setAttribute("recoveryTasks", filteredTask);
    }

    private void addMappingInfo(RecoveryProcessorContext contextRef) {
        String key = (String)contextRef.getAttribute("TargetHostKey");
        List hosts = (List)contextRef.getAttribute("Target_Host");
        VsphereHostSystem vsphereHostSystem = (VsphereHostSystem)hosts.get(0);
        String vCenterId = (String)contextRef.getAttribute("Target_vCenter");
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)vCenterId);
        String vCenterName = vCenter.getName();
        JSONArray jsonArr = new JSONArray();
        JSONObject json = new JSONObject();
        json.put((Object)"srcVcenterId", (Object)vCenterId);
        json.put((Object)"srcVcenterName", (Object)vCenterName);
        json.put((Object)"srcHostId", (Object)vsphereHostSystem.getComputeResourceUuid());
        json.put((Object)"srcHostName", (Object)vsphereHostSystem.getName());
        json.put((Object)"remoteVcenterId", (Object)vCenterId);
        json.put((Object)"remoteVcenterName", (Object)vCenterName);
        json.put((Object)"remoteHostId", (Object)vsphereHostSystem.getComputeResourceUuid());
        json.put((Object)"remoteHostName", (Object)vsphereHostSystem.getName());
        jsonArr.add((Object)json);
        contextRef.getRecoveryPlan().getGlobalSettings().put(key, jsonArr.toString());
    }

    private void updateDataConsistencyCheck(RecoveryProcessorContext contextRef) {
        Collection recoveryTasks = (Collection)contextRef.getAttribute("recoveryTasks");
        RecoveryProcessResult processResult = contextRef.getProcessResult();
        for (RecoveryTask next : recoveryTasks) {
            Map lunAndHostMap = next.getLunAndHostMap();
            Set slaveKeys = lunAndHostMap.keySet();
            for (String slaveKey : slaveKeys) {
                String lunId = RecoveryProcessUtil.getLunIdFromLunAndHostMapKey((String)slaveKey);
                String deviceId = next.getTgtDevcieId();
                processResult.addProcessResult(RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)deviceId, (String)lunId), Boolean.TRUE.booleanValue());
            }
        }
    }

    private void updateMapInTask(RecoveryTask recoveryTask, Map<String, String> slaveKeyMap, Map<String, Integer> poAndTypeMap, String pgUUid) {
        Map lunAndHostMap = recoveryTask.getLunAndHostMap();
        Map lunAndPgMap = recoveryTask.getLunAndPgMap();
        Map lunAndPoMap = recoveryTask.getLunAndPoMap();
        if (VerifyUtil.isEmpty((Map)lunAndHostMap) && VerifyUtil.isEmpty((Map)lunAndPgMap) && VerifyUtil.isEmpty((Map)lunAndPoMap)) {
            logger.info((Object)"lun maps of task are empty. protectName=%s", new Object[]{recoveryTask.getProtectName()});
            return;
        }
        this.updateKeyInMap(slaveKeyMap, lunAndHostMap);
        this.updateKeyInMap(slaveKeyMap, lunAndPoMap);
        this.updateKeyInMap(slaveKeyMap, poAndTypeMap);
        if (recoveryTask.getResourceAndTypeMap() == null) {
            recoveryTask.setResourceAndTypeMap(new HashMap());
        }
        List<String> pgIdList = Collections.singletonList(pgUUid);
        Set newSlaveKeyOfTask = lunAndPoMap.keySet();
        for (String newSlaveKey : newSlaveKeyOfTask) {
            lunAndPgMap.put(newSlaveKey, pgIdList);
            recoveryTask.getResourceAndTypeMap().put(newSlaveKey, poAndTypeMap.get(newSlaveKey));
        }
    }

    private <T> void updateKeyInMap(Map<String, String> slaveKeyMap, Map<String, T> mapToUpdate) {
        String[] oldSlaveKeySetInHostMap;
        for (String oldKey : oldSlaveKeySetInHostMap = mapToUpdate.keySet().toArray(new String[0])) {
            if (!slaveKeyMap.containsKey(oldKey)) continue;
            T value = mapToUpdate.remove(oldKey);
            mapToUpdate.put(slaveKeyMap.get(oldKey), value);
        }
    }

    private void fillMapWithSlaveKey(RelicaStorageInfo replicaStorageInfo, Map<String, String> slaveKeyMap, Map<String, Integer> poAndTypeMap) {
        if (!(replicaStorageInfo instanceof LocalStorageReplica)) {
            return;
        }
        String oldSlaveKey = replicaStorageInfo.getStorageId();
        if (slaveKeyMap.containsKey(oldSlaveKey)) {
            return;
        }
        String newSlaveKey = RecoveryProcessUtil.generateLunAndHostMapKey((String)replicaStorageInfo.getStorageId(), (String)replicaStorageInfo.getSrcStorageProviderSN(), (String)replicaStorageInfo.getSrcStorageId(), (String)replicaStorageInfo.getStorageProviderSN(), (String)replicaStorageInfo.getSrcStorageId());
        slaveKeyMap.put(oldSlaveKey, newSlaveKey);
        String poId = replicaStorageInfo.getPoReplica().getPoId();
        String poResKey = poId + ":" + replicaStorageInfo.getStorageId();
        if (poAndTypeMap.containsKey(poResKey)) {
            Integer poType = poAndTypeMap.remove(poResKey);
            poAndTypeMap.put(oldSlaveKey, poType);
        }
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        this.checkContext(context);
        this.checkVmRollback();
        String selectedVmUuidStr = (String)context.getRecoveryPlan().getGlobalSettings().remove("selectedVmMoIdList");
        List<String> selectedVMUuidList = this.splitToList(selectedVmUuidStr, ",");
        if (VerifyUtil.isEmpty(selectedVMUuidList)) {
            logger.error((Object)"selected vm uuid list is empty: pgName=%s, recoveryPlanName=%s", new Object[]{context.getProtectGroup().getName(), context.getRecoveryPlan().getName()});
            throw new LegoCheckedException(1073948950L);
        }
        String vCenterUuid = context.getProtectGroup().getPoProviderSN();
        List allDsList = (List)context.getAttribute(ALL_DATASTORE_KEY);
        Map<String, VsphereDataStore> lunAndDatastoreMap = this.getLunAndDatastoreMap(vCenterUuid, allDsList);
        ProtectGroupReplica pgReplica = this.getPgReplicaInfo(context);
        Set replicas = pgReplica.getReplicas();
        List<VsphereVirtualMachine> selectedVMs = replicas.stream().filter(poReplica -> selectedVMUuidList.contains(poReplica.getPoId())).map(poReplica -> this.convertToVm(poReplica.getProtectObject(), lunAndDatastoreMap)).collect(Collectors.toList());
        Set selectedHostUUIDs = selectedVMs.stream().map(VsphereVirtualMachine::getHostUuid).collect(Collectors.toSet());
        context.setAttribute("TargetHostUuidList", selectedHostUUIDs);
        context.setAttribute("selectedVmMoIdList", selectedVMUuidList);
        Set selectedPoIdSet = selectedVMs.stream().map(ManagedObject::getUuid).collect(Collectors.toSet());
        List<VsphereVirtualMachine> vmsToShutdown = context.getProtectGroup().getPolist().stream().filter(po -> selectedPoIdSet.contains(po.getUuid())).map(VsphereVirtualMachineUtils::convertFrom).collect(Collectors.toList());
        String dcId = this.getDataCenterMoId(context, context.getProtectGroup().getPolist());
        selectedVMs.forEach(vm -> vm.setDcMoId(dcId != null ? dcId : vm.getDcMoId()));
        vmsToShutdown.forEach(vm -> vm.setDcMoId(dcId != null ? dcId : vm.getDcMoId()));
        context.setAttribute("oldTargetVMs", selectedVMs);
        context.setAttribute("Target_VM", vmsToShutdown);
    }

    private VsphereVirtualMachine convertToVm(ProtectObject protectObject, Map<String, VsphereDataStore> lunAndDsMap) {
        VsphereVirtualMachine vm = VsphereVirtualMachineUtils.convertFrom(protectObject);
        HashSet<VmVirtualDisk> disks = new HashSet<VmVirtualDisk>();
        String vmConfigJson = protectObject.getProperty("VirtualDisk");
        Set usedStorageResourceSet = protectObject.getUsedStorageResourceSet();
        JSONArray jsonArray = JSONArray.fromObject((Object)vmConfigJson);
        for (Object obj : jsonArray) {
            JSONObject vmDiskInfo = (JSONObject)obj;
            Object devKeyObj = vmDiskInfo.get("devKey");
            Object unitNumberObj = vmDiskInfo.get("unitNumber");
            if (VerifyUtil.isEmpty((Object)devKeyObj) || VerifyUtil.isEmpty((Object)unitNumberObj)) {
                logger.info((Object)"can't get device key from vm config: poName=%s, poId=%s", new Object[]{protectObject.getName(), protectObject.getUuid()});
                throw new LegoCheckedException(1073948960L);
            }
            String dsVmfsIdFromDisk = (String)vmDiskInfo.get("datastoreId");
            if (VerifyUtil.isEmpty((String)dsVmfsIdFromDisk)) {
                logger.error((Object)"can't find datastoreId of datastore: %s", new Object[]{vmDiskInfo});
                throw new LegoCheckedException(1073948960L);
            }
            int devKey = Integer.parseInt(devKeyObj.toString());
            int unitNumber = Integer.parseInt(unitNumberObj.toString());
            ProtectObjectStorageInfo storageInfo = this.getStorageInfoByDatastoreId(usedStorageResourceSet, dsVmfsIdFromDisk, vmDiskInfo);
            DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E vmDiskTypeE = DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.getType((int)storageInfo.getStorageType());
            VerifyUtil.checkObject((Object)vmDiskTypeE);
            Optional<VsphereDataStore> dataStoreOpt = this.findDatastoreByDiskAndLun(lunAndDsMap, dsVmfsIdFromDisk, storageInfo);
            if (!dataStoreOpt.isPresent()) {
                logger.error((Object)"datastore not found by dsUuid in vm disk info: dsUuid=%s", new Object[]{dsVmfsIdFromDisk});
                throw new LegoCheckedException(2117645L);
            }
            VsphereDataStore dataStore = dataStoreOpt.get();
            String datastoreId = VsphereCommUtil.getDatastoreId(dataStore.getUrl());
            VmVirtualDisk newVmDisk = this.createNewVmDisk(devKey, datastoreId, unitNumber, storageInfo, vmDiskTypeE);
            disks.add(newVmDisk);
        }
        vm.setVirtualDisk(disks);
        return vm;
    }

    private Optional<VsphereDataStore> findDatastoreByDiskAndLun(Map<String, VsphereDataStore> lunAndDsMap, String dsVmfsUuidFromDisK, ProtectObjectStorageInfo storageInfo) {
        String mountPoint = storageInfo.getMountPoint();
        String datastoreId = VsphereCommUtil.getDatastoreId(mountPoint);
        if (!Objects.equals(dsVmfsUuidFromDisK, datastoreId)) {
            logger.warn((Object)"dsUuidFromDisk(%s) is not equal to dsUuidFromStorageInfo(%s)", new Object[]{dsVmfsUuidFromDisK, datastoreId});
            return Optional.empty();
        }
        String lunWWN = storageInfo.getLunWWN();
        if (lunAndDsMap.containsKey(lunWWN)) {
            return Optional.of(lunAndDsMap.get(lunWWN));
        }
        logger.warn((Object)"can't find datastore by lunWwn: lunWwn=%s, dsUuid=%s", new Object[]{lunWWN, dsVmfsUuidFromDisK});
        return Optional.empty();
    }

    private VmVirtualDisk createNewVmDisk(int devKey, String datastoreId, int unitNumber, ProtectObjectStorageInfo storageInfo, DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E vmDiskTypeE) {
        VmVirtualDisk newVmDisk = new VmVirtualDisk();
        newVmDisk.setDeviceKey(Integer.valueOf(devKey));
        newVmDisk.setDiskType(storageInfo.getStorageType().intValue());
        newVmDisk.setStorageType(vmDiskTypeE.name());
        newVmDisk.setDataStoreOrLunUuid(datastoreId);
        newVmDisk.setUnitNumber(Integer.valueOf(unitNumber));
        newVmDisk.setDatastoreId(datastoreId);
        if (vmDiskTypeE == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM || vmDiskTypeE == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM) {
            newVmDisk.setDataStoreOrLunUuid(storageInfo.getLunWWN());
            newVmDisk.setStorageFileName(storageInfo.getDeviceName());
            newVmDisk.setContentDataStoreUuid(datastoreId);
            newVmDisk.setSharing(storageInfo.getStorageShareType());
        }
        return newVmDisk;
    }

    private ProtectObjectStorageInfo getStorageInfoByDatastoreId(Set<ProtectObjectStorageInfo> usedStorageResourceSet, String datastoreId, JSONObject diskInfo) {
        Object deviceName = diskInfo.get("storageFileName");
        String diskType = diskInfo.getString("storageType");
        ProtectObjectStorageInfo protectObjectStorageInfo = null;
        for (ProtectObjectStorageInfo storageInfo : usedStorageResourceSet) {
            DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E storageType = DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.getType((int)storageInfo.getStorageType());
            boolean isStorageRdm = storageType == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM || storageType == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM;
            boolean isDiskRDM = RDM_DISK_TYPE.contains(diskType);
            if (isStorageRdm && isDiskRDM && Objects.equals(storageInfo.getDeviceName(), deviceName)) {
                protectObjectStorageInfo = storageInfo;
                break;
            }
            if (!isDiskRDM && !isStorageRdm && Objects.equals(VsphereCommUtil.getDatastoreId(storageInfo.getMountPoint()), datastoreId)) {
                protectObjectStorageInfo = storageInfo;
                break;
            }
            protectObjectStorageInfo = null;
        }
        if (VerifyUtil.isEmpty(protectObjectStorageInfo)) {
            logger.error((Object)"can't find protectObject storage info from usedStorageResourceSet: datastoreId=%s", new Object[]{datastoreId});
            throw new LegoCheckedException(2117645L);
        }
        return protectObjectStorageInfo;
    }

    @Override
    public void prepareTargetDatastore(RecoveryProcessorContext context) {
        this.checkContext(context);
        this.checkVmRollback();
        this.validateDatastoreInReplica(context);
        ArrayList<VsphereDataStore> selectedDatastore = new ArrayList<VsphereDataStore>();
        HashMap<String, VsphereDataStore> vmToDatastoreMap = new HashMap<String, VsphereDataStore>();
        this.filterDatastoreOfSelectedVMs(context, selectedDatastore, vmToDatastoreMap);
        context.setAttribute("selectedVmToDatastore", vmToDatastoreMap);
        context.setAttribute("datastoreRefToSelectedVMs", selectedDatastore);
        context.setAttribute("Target_Datastore", selectedDatastore);
        context.setAttribute("datastoreChangeMap", new HashSet());
    }

    private void validateDatastoreInReplica(RecoveryProcessorContext context) {
        if (((Boolean)context.getAttributeOrDefault("isRemoteVmRollback", Boolean.class, (Object)Boolean.FALSE)).booleanValue()) {
            logger.info((Object)"No need to validate datastore in scenario of remote vm rollback.");
            return;
        }
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica", ProtectGroupReplica.class);
        HashSet dsInReplicaSet = new HashSet();
        for (ProtectObjectReplica replica : protectGroupReplica.getReplicas()) {
            Set storageInfoSet = replica.getProtectObject().getUsedStorageResourceSet();
            storageInfoSet.forEach(info -> dsInReplicaSet.add(VsphereCommUtil.getDatastoreId(info.getMountPoint())));
        }
        List dataStoreList = context.getObjects(ALL_DATASTORE_KEY, VsphereDataStore.class);
        Set datastoreFromVcenter = dataStoreList.stream().map(ds -> VsphereCommUtil.getDatastoreId(ds.getUrl())).collect(Collectors.toSet());
        for (String dsUuid : dsInReplicaSet) {
            if (datastoreFromVcenter.contains(dsUuid)) continue;
            logger.error((Object)"Datastore does not exist: %s", new Object[]{dsUuid});
            throw new LegoCheckedException(1073948102L);
        }
    }

    private Set<ProtectObjectStorageInfo> filterPoStorageInfoBySelectedVMs(RecoveryProcessorContext context) {
        HashSet<ProtectObjectStorageInfo> storageInfos = new HashSet<ProtectObjectStorageInfo>();
        List selectedVMUuidList = (List)context.getAttribute("selectedVmMoIdList");
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica");
        if (VerifyUtil.isEmpty((Collection)selectedVMUuidList) || VerifyUtil.isEmpty((Object)pgReplica)) {
            logger.info((Object)"Empty pgReplica or selectedVMUuidList for filterPoStorageInfoBySelectedVMs ");
            return storageInfos;
        }
        Set replicas = pgReplica.getReplicas();
        for (ProtectObjectReplica replica : replicas) {
            if (!selectedVMUuidList.contains(replica.getPoId())) continue;
            storageInfos.addAll(replica.getProtectObject().getUsedStorageResourceSet());
        }
        return storageInfos;
    }

    private void filterDatastoreOfSelectedVMs(RecoveryProcessorContext context, List<VsphereDataStore> selectedDatastore, Map<String, VsphereDataStore> vmToDatastoreMap) {
        Set<ProtectObjectStorageInfo> storageInfos = this.filterPoStorageInfoBySelectedVMs(context);
        List selectedVMUuidList = (List)context.getAttribute("selectedVmMoIdList");
        HashMap<String, VsphereDataStore> distinctDatastoreMap = new HashMap<String, VsphereDataStore>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            VsphereDataStore dataStore;
            if (VerifyUtil.isEmpty((String)storageInfo.getMountPoint()) || !selectedVMUuidList.contains(storageInfo.getProtectObject().getUuid())) continue;
            String mountInfo = storageInfo.getMountPoint();
            String dsId = VsphereCommUtil.getDatastoreId(mountInfo);
            if (!distinctDatastoreMap.containsKey(dsId)) {
                dataStore = (VsphereDataStore)CommonDAOLocator.getMoDao().getMo(VsphereDataStore.class, "url", (Object)mountInfo);
                if (dataStore == null) {
                    logger.error((Object)"can't find datastore from db: dsId=%s", new Object[]{dsId});
                    throw new LegoCheckedException(2117645L);
                }
                logger.info((Object)"selected datastore: dsUuid=%s", new Object[]{dataStore.getUuid()});
                selectedDatastore.add(dataStore);
                distinctDatastoreMap.put(dsId, dataStore);
            } else {
                dataStore = (VsphereDataStore)distinctDatastoreMap.get(dsId);
            }
            vmToDatastoreMap.put(storageInfo.getProtectObject().getName(), dataStore);
        }
    }

    private ProtectGroupReplica getPgReplicaInfo(RecoveryProcessorContext context) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)context.getAttribute("Recovery_PgReplica");
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            logger.error((Object)"can't find selected replica: pgId=%s, recoveryPlanId=%s", new Object[]{context.getProtectGroup().getUuid(), context.getRecoveryPlan().getUuid()});
            throw new LegoCheckedException(1073947393L);
        }
        return protectGroupReplica;
    }

    @Override
    public void prepareTargetStoreageResource(RecoveryProcessorContext context) {
        ArrayList<StorageResource> targetStorageList = new ArrayList<StorageResource>();
        HashSet<String> selectedLunWwn = new HashSet<String>();
        Set<ProtectObjectStorageInfo> storageInfos = this.filterPoStorageInfoBySelectedVMs(context);
        List selectedVMUuidList = (List)context.getAttribute("selectedVmMoIdList");
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (VerifyUtil.isEmpty((String)storageInfo.getMountPoint()) || !selectedVMUuidList.contains(storageInfo.getProtectObject().getUuid())) continue;
            selectedLunWwn.add(storageInfo.getLunWWN());
            StorageResource storageRes = new StorageResource();
            storageRes.setDevSn(storageInfo.getResourceProviderSN());
            storageRes.setResourceId(storageInfo.getResourceId());
            storageRes.setResourceIndentifier(storageInfo.getLunWWN());
            logger.info((Object)"Prepare Target Storage Resource wwn:%s, sn:%s", new Object[]{storageInfo.getLunWWN(), storageInfo.getResourceProviderSN()});
            targetStorageList.add(storageRes);
        }
        HashSet<String> rdmSnapshotIdSet = new HashSet<String>();
        HashSet rdmWwn = new HashSet();
        List selectedVms = (List)context.getAttribute("oldTargetVMs");
        for (VsphereVirtualMachine selectedVm : selectedVms) {
            selectedVm.getVirtualDisk().stream().filter(disk -> RDM_DISK_TYPE_SET.contains(disk.getDiskType())).forEach(disk -> rdmWwn.add(disk.getDataStoreOrLunUuid()));
        }
        ProtectGroupReplica pgReplicaInfo = this.getPgReplicaInfo(context);
        for (ProtectObjectReplica replica : pgReplicaInfo.getReplicas()) {
            Set storageResourceSet = replica.getStorageInfos();
            for (RelicaStorageInfo relicaStorageInfo : storageResourceSet) {
                LocalStorageReplica localReplicaInfo = (LocalStorageReplica)relicaStorageInfo;
                String srcLunWwn = localReplicaInfo.getProtectObjectStorageWwn();
                if (!rdmWwn.contains(srcLunWwn)) continue;
                rdmSnapshotIdSet.add(localReplicaInfo.getStorageProviderSN() + ":" + localReplicaInfo.getStorageId());
            }
        }
        context.setAttribute("Target_Storage", targetStorageList);
        context.setAttribute("rdmWwnKey", rdmSnapshotIdSet);
        context.setAttribute(SELECTED_LUN_WWN, selectedLunWwn);
    }

    private Map<String, VsphereDataStore> getLunAndDatastoreMap(String vCenterUuid, List<VsphereDataStore> allDsList) {
        HashMap<String, VsphereDataStore> lunAndDatastoreMap = new HashMap<String, VsphereDataStore>();
        DataStoreAction dataStoreAction = new DataStoreAction();
        for (VsphereDataStore dataStore : allDsList) {
            String datastoreId = VsphereCommUtil.getDatastoreId(dataStore.getUrl());
            List<String> lunFromDataStore = dataStoreAction.getLunFromDataStore(vCenterUuid, Collections.singletonList(datastoreId));
            lunFromDataStore.forEach(lunWnn -> lunAndDatastoreMap.put((String)lunWnn, dataStore));
        }
        return lunAndDatastoreMap;
    }

    private void checkContext(RecoveryProcessorContext context) {
        if (context == null || context.getProtectGroup() == null || context.getRecoveryPlan() == null) {
            logger.error((Object)"context info is wrong.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkVmRollback() {
        int procType = this.getInterceptTask().getProcType();
        if (procType != DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue()) {
            logger.error((Object)"The processType is wrong, this process is about vm rollback: procType=%s", new Object[]{procType});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private List<String> splitToList(String targetString, String regex) {
        if (VerifyUtil.isEmpty((String)targetString)) {
            return Collections.emptyList();
        }
        String[] split = targetString.split(regex, -1);
        return Arrays.asList(split);
    }
}

