/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class RenameVmSubTask
extends OperateVsphereVmSubTask {
    private static final Log logger = LogFactory.getInstance(RenameVmSubTask.class);
    private static final String TARGET_VM_EMPTY = "com.huawei.ism.drm.vsphere.recovery.common.targetVmEmpty";
    private String originalName;
    private String targetName;

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        VsphereVirtualMachine vm = this.getVm();
        if (VerifyUtil.isEmpty((Object)vm)) {
            logger.error((Object)"vm is null, can't do rename action.");
            return this.failure(TARGET_VM_EMPTY, null);
        }
        VerifyUtil.checkObjs((Object[])new Object[]{vm.getVmMoId()});
        if (VerifyUtil.isEmpty((String)this.getTargetName())) {
            logger.error((Object)"target name is empty: vmName=%s", new Object[]{vm.getName()});
            this.updateProcessNameParams(new String[]{vm.getName(), "--"});
            return this.failure(new LegoCheckedException(1073947393L));
        }
        this.updateProcessNameParams(new String[]{vm.getName(), this.getTargetName()});
        if (this.getTargetName().equals(vm.getName())) {
            logger.error((Object)"the name(%s) of vm is same as target name(%s)", new Object[]{vm.getName(), this.getTargetName()});
            return this.failure(new LegoCheckedException(1073948888L));
        }
        logger.info((Object)"rename vm(%s) to: %s", new Object[]{this.getVm().getName(), this.targetName});
        VMAction vmAction = new VMAction();
        boolean isRenameSucc = vmAction.renameVM(context.getProtectGroup().getPoProviderSN(), vm.getVmMoId(), this.getTargetName());
        return isRenameSucc ? this.success() : this.failure();
    }

    public void endRecoveryProcessor() {
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            logger.info((Object)"update name of vm to: %s", new Object[]{this.targetName});
            this.getVm().setName(this.targetName);
        }
        super.endRecoveryProcessor();
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getTargetName() {
        return this.targetName;
    }
}

