/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public abstract class RescanHostSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(RescanHostSubTask.class);
    private VsphereHostSystem hostSystem;

    public RescanHostSubTask() {
    }

    public RescanHostSubTask(VsphereHostSystem hostSystem, RecoveryProcessor parentProc) {
        this.hostSystem = hostSystem;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (null == this.hostSystem) {
            logger.error((Object)"Rescan host failed, host is null.");
            return this.failure("lego.err.2117645", null);
        }
        String hostName = this.hostSystem.getName();
        String hostMoId = this.hostSystem.getHostMoId();
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        this.updateProcessNameParams(new String[]{hostName});
        logger.debug((Object)"Start to rescan HBA for host[%s] in vCenter[%s]", new Object[]{hostMoId, vCenterUuid});
        if (VerifyUtil.isEmpty((String)vCenterUuid) || VerifyUtil.isEmpty((String)hostMoId)) {
            logger.error((Object)"Start to rescan HBA, error parameter: host[%s], vCenter[%s].", new Object[]{hostMoId, vCenterUuid});
            return this.failure("lego.err.1073947393", null);
        }
        try {
            this.doRescan(vCenterUuid, hostMoId);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Rescan failed, vCenterUuid[%s], hostMoId[%s]", vCenterUuid, hostMoId), (Throwable)e);
            return this.failure("com.huawei.ism.drm.vsphere.recovery.process.VsRescanProcessor.fail", null);
        }
        logger.info((Object)"Rescan HBA for host[%s] in vCenter[%s] succeed.", new Object[]{hostMoId, vCenterUuid});
        return this.success();
    }

    protected abstract void doRescan(String var1, String var2);
}

