/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ShutdownVMTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachineConnectionState;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.HashMap;

public class ShutdownVMSubTask
extends OperateVsphereVmSubTask {
    private static final Log logger = LogFactory.getInstance(ShutdownVMTask.class);

    public ShutdownVMSubTask() {
    }

    public ShutdownVMSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        super(virtualMachine, parentProc);
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        return this.shutdownVirtualMachine(context);
    }

    private boolean shutdownVirtualMachine(RecoveryProcessorContext context) {
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        VsphereVirtualMachine vm = this.getVm();
        String vmMoId = vm.getVmMoId();
        return this.shutdownVirtualMachine(vcenterUuid, vmMoId);
    }

    private boolean shutdownVirtualMachine(String vCenterUuid, String vmMoId) {
        VsphereVirtualMachine vm = this.getVm();
        String vmxPath = vm.getVmPath();
        String vmName = vm.getName();
        VMAction vmAction = new VMAction();
        String dcMoId = vm.getDcMoId();
        if (vmAction.findVmByPath(vCenterUuid, dcMoId, vmxPath) == null) {
            logger.info((Object)"Virtaul Machine[%s] will be shutodnw has been deleted! ", new Object[]{vmName});
            return this.success("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{vmName});
        }
        VirtualMachinePowerState powerState = vmAction.getVMPowerState(vCenterUuid, vmMoId);
        VirtualMachineConnectionState connState = vmAction.getVMRuntimeState(vCenterUuid, vmMoId, "connectionState", VirtualMachineConnectionState.class);
        VirtualMachineToolsRunningStatus toolRunningState = vmAction.getGuestVMToolState(vCenterUuid, vmMoId);
        if (VirtualMachinePowerState.POWERED_OFF == powerState || VirtualMachineConnectionState.INVALID == connState) {
            logger.info((Object)"Virtual machine is power off[%s] or connection state[%s] is invalid", new Object[]{powerState, connState});
            return this.success("ism.drm.recovery.vsphere.vm.is.poweroffOrInvalid", null);
        }
        if (VirtualMachinePowerState.POWERED_ON == powerState && VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING != toolRunningState) {
            logger.error((Object)"The VM[%s] will be shutdown is not installed vmtools, cannot be shutdown!", new Object[]{vmName});
            return this.failure("lego.err.1073948868", null);
        }
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(vmMoId);
        DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E state = vmAction.getGuestOSState(vCenterUuid, vmMor);
        if (state != DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.NOTRUNNING) {
            logger.info((Object)"Virtaul Machine named %s status is %s", new Object[]{vmName, state});
            try {
                vmAction.shutdownGuest(vCenterUuid, vmMoId);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Shutdown  Virtual Machine %s failed.", new Object[]{vmName});
                return this.failure(e);
            }
            VirtualMachinePowerState expectedState = VirtualMachinePowerState.POWERED_OFF;
            if (!VsphereVirtualMachineUtils.isVMPowerStateEquals(vmMoId, vCenterUuid, expectedState)) {
                return this.failure("ism.drm.recovery.vsphere.vm.shutdown.failed", new String[]{vmName});
            }
        }
        logger.info((Object)"Shutdown vm[%s] success.", new Object[]{vmName});
        return this.success();
    }

    private boolean shutdownVirtualMachine(String vCenterUuid, String vmMoId, Site remoteSite) {
        VsphereRecoveryUtils util = VsphereRecoveryUtils.getInstance();
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("planId", plan.getPlanId());
        params.put("vmSn", vmMoId);
        params.put("vcenterId", vCenterUuid);
        String vmName = this.getVm().getName();
        String errMsg = "Shutdown vm from remote site[%s] failed:vmName=%s, errMsg=%s";
        try {
            util.sendRestToRemoteSite(remoteSite, "/ws/vcenters/{vcenterId}/action/stopVm?planId={planId}&vmSn={vmSn}", params);
            logger.info((Object)"shutdown vm from remote site[%s] success:vmName=%s", new Object[]{remoteSite.getName(), vmName});
            return this.success();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)errMsg, new Object[]{remoteSite.getName(), vmName, ExceptionUtil.getErrorMessage((Throwable)e)});
            return this.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)errMsg, new Object[]{remoteSite.getName(), vmName, ExceptionUtil.getErrorMessage((Throwable)e)});
            return this.failure("ism.drm.recovery.vsphere.vm.shutdown.failed", new String[]{vmName});
        }
    }
}

