/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class UmountDatastoreSubTask
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(UmountDatastoreSubTask.class);
    private VsphereDataStore dataStore;

    public UmountDatastoreSubTask() {
    }

    public UmountDatastoreSubTask(VsphereDataStore dataStore, RecoveryProcessor parentProc) {
        this.dataStore = dataStore;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (null == vCenterUuid) {
            LOGGER.error((Object)"Cannot find vCenterUuid from recovery context");
            return this.failure(null, null);
        }
        if (null == this.dataStore) {
            LOGGER.error((Object)"Datastore is null");
            return this.failure(null, null);
        }
        this.updateProcessNameParams(new String[]{this.dataStore.getName()});
        String dsMoId = this.dataStore.getUuid();
        String dsName = this.dataStore.getName();
        try {
            LOGGER.debug((Object)"Begin to umount datastore[%s] from vCenter[%s]", new Object[]{dsName, vCenterUuid});
            this.unmountDatastore(vCenterUuid);
            LOGGER.debug((Object)"Successful umount datastore[%s] from vCenter[%s]", new Object[]{dsName, vCenterUuid});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Unmount datastore failed:dsName=%s dsMoId=%s" + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{dsName, dsMoId});
            return this.failure(e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unmount datastore failed:dsName=%s dsMoId=%s" + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{dsName, dsMoId});
            return this.failure("ism.drm.recovery.vsphere.datastore.unmount.failed", new String[]{dsName});
        }
        return this.success();
    }

    private void unmountDatastore(String vCenterUuid) {
        HostSystemAction hostAction = new HostSystemAction();
        hostAction.unmountDataStoreByUuid(vCenterUuid, this.dataStore.getUuid());
    }

    public VsphereDataStore getDataStore() {
        return this.dataStore;
    }
}

