/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.google.common.collect.Sets;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.vsphere.recovery.task.CleanVmRecoveryProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.CleanVmResourcePreparer;
import com.huawei.ism.drm.vsphere.recovery.task.DeleteVmFromDiskSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.DeleteVmFromDiskTask;
import com.huawei.ism.drm.vsphere.recovery.task.DetachScsiLunSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ShutdownVMSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ShutdownVMTask;
import com.huawei.ism.drm.vsphere.recovery.task.UmountDatastoreSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class VmRecoveryCallbackTask
implements ICallBackExcuteRecoveryTask {
    private static final Log logger = LogFactory.getInstance(VmRecoveryCallbackTask.class);

    public void afterExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        CleanVmRecoveryProcessor cleanVmRecoveryProcessor = this.createCleanProcessor(context, recoveryPlan);
        HashSet cleanVmRecoveryProcessors = Sets.newHashSet((Object[])new RecoveryProcessor[]{cleanVmRecoveryProcessor});
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)cleanVmRecoveryProcessors);
        executor.process(context);
        int procStatus = cleanVmRecoveryProcessor.getProcStatus();
        logger.info((Object)"clean callback result for vm recovery: %s", new Object[]{String.valueOf(procStatus)});
        List<String> tipInfoList = this.collectParamInfo(cleanVmRecoveryProcessor);
        boolean hasTipInfo = tipInfoList.stream().anyMatch(tip -> !tip.equals("--"));
        logger.info((Object)"tip info list is: %s", new Object[]{tipInfoList});
        try {
            if (!hasTipInfo) {
                this.cleanLastAlert(context, recoveryPlan);
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(recoveryPlan.getPlanId());
                params.addAll(tipInfoList);
                this.createAlert(context, recoveryPlan, params);
            }
        }
        catch (Exception e) {
            logger.error((Object)"handle alarm for vm recovery failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private List<String> collectParamInfo(CleanVmRecoveryProcessor cleanVmRecoveryProcessor) {
        Set childProc = cleanVmRecoveryProcessor.getChildProc();
        String vmName = "--";
        String dsName = "--";
        String lunDevice = "--";
        for (RecoveryProcessor recoveryProcessor : childProc) {
            if (recoveryProcessor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) continue;
            vmName = this.getVmName(vmName, recoveryProcessor);
            dsName = this.getDsName(dsName, recoveryProcessor);
            lunDevice = this.getLunWwn(lunDevice, recoveryProcessor);
        }
        return Arrays.asList(vmName, dsName, lunDevice);
    }

    private String getVmName(String vmName, RecoveryProcessor vmTask) {
        String tempName = null;
        if (vmTask instanceof ShutdownVMTask) {
            ShutdownVMTask shutdownVMTask = (ShutdownVMTask)vmTask;
            Set<RecoveryProcessor> childProc = this.getFailedChildProc((RecoveryProcessor)shutdownVMTask);
            tempName = this.getShutdownFailVm(childProc);
        }
        if (vmTask instanceof DeleteVmFromDiskTask) {
            DeleteVmFromDiskTask deleteVmFromDiskTask = (DeleteVmFromDiskTask)vmTask;
            Set<RecoveryProcessor> failedChildProc = this.getFailedChildProc((RecoveryProcessor)deleteVmFromDiskTask);
            tempName = this.getDeleteVmFailed(failedChildProc);
        }
        return VerifyUtil.isEmpty(tempName) ? vmName : tempName;
    }

    private String getDeleteVmFailed(Set<RecoveryProcessor> childProc) {
        ArrayList<String> vmDeletedFailed = new ArrayList<String>();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            if (!(recoveryProcessor instanceof DeleteVmFromDiskSubTask)) continue;
            DeleteVmFromDiskSubTask deleteFailedTask = (DeleteVmFromDiskSubTask)recoveryProcessor;
            VsphereVirtualMachine vm = deleteFailedTask.getVm();
            vmDeletedFailed.add(vm.getName());
        }
        return String.join((CharSequence)",", vmDeletedFailed);
    }

    private String getShutdownFailVm(Set<RecoveryProcessor> shutdownVMTasks) {
        ArrayList<String> vmShutdownFailed = new ArrayList<String>();
        for (RecoveryProcessor recoveryProcessor : shutdownVMTasks) {
            if (!(recoveryProcessor instanceof ShutdownVMSubTask)) continue;
            ShutdownVMSubTask shutdownVMSubTask = (ShutdownVMSubTask)recoveryProcessor;
            VsphereVirtualMachine vm = shutdownVMSubTask.getVm();
            vmShutdownFailed.add(vm.getName());
        }
        return String.join((CharSequence)",", vmShutdownFailed);
    }

    private String getDsName(String dsName, RecoveryProcessor recoveryProcessor) {
        ArrayList<String> dsNames = new ArrayList<String>();
        Set<RecoveryProcessor> childProc = this.getFailedChildProc(recoveryProcessor);
        for (RecoveryProcessor umountSubProcessor : childProc) {
            if (!(umountSubProcessor instanceof UmountDatastoreSubTask)) continue;
            UmountDatastoreSubTask umountSubTask = (UmountDatastoreSubTask)umountSubProcessor;
            VsphereDataStore dataStore = umountSubTask.getDataStore();
            dsNames.add(dataStore.getName());
        }
        String tempName = String.join((CharSequence)",", dsNames);
        return VerifyUtil.isEmpty((String)tempName) ? dsName : tempName;
    }

    private String getLunWwn(String lunDevice, RecoveryProcessor recoveryProcessor) {
        ArrayList<String> lunWwns = new ArrayList<String>();
        Set<RecoveryProcessor> failedChild = this.getFailedChildProc(recoveryProcessor);
        for (RecoveryProcessor processor : failedChild) {
            if (!(processor instanceof DetachScsiLunSubTask)) continue;
            DetachScsiLunSubTask detachScsiLunSubTask = (DetachScsiLunSubTask)processor;
            StorageResource storageResource = detachScsiLunSubTask.getStorageResource();
            lunWwns.add(storageResource.getResourceIndentifier());
        }
        String tempLunWwns = String.join((CharSequence)",", lunWwns);
        return VerifyUtil.isEmpty((String)tempLunWwns) ? lunDevice : tempLunWwns;
    }

    private Set<RecoveryProcessor> getFailedChildProc(RecoveryProcessor recoveryProcessor) {
        Set childProc = recoveryProcessor.getChildProc();
        if (VerifyUtil.isEmpty((Collection)childProc)) {
            return Collections.emptySet();
        }
        int failed = DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        return childProc.stream().filter(child -> child.getProcStatus() == failed).collect(Collectors.toSet());
    }

    private CleanVmRecoveryProcessor createCleanProcessor(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        CleanVmRecoveryProcessor cleanVmRecoveryProcessor = new CleanVmRecoveryProcessor();
        Map props = cleanVmRecoveryProcessor.getProps();
        props.put("prepareclass", CleanVmResourcePreparer.class.getName());
        props.put("refproctype", "12");
        props.put("targethosttype", "recoveryHosts");
        cleanVmRecoveryProcessor.setIsNeedSave(false);
        cleanVmRecoveryProcessor.setIsNeedCreateDetail(false);
        cleanVmRecoveryProcessor.setProcType(DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue());
        return cleanVmRecoveryProcessor;
    }

    private void cleanLastAlert(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
        logger.info((Object)"restore vm recovery alert.");
        AlarmReporter.restoreAlarm((long)52625520L, (String[])new String[]{recoveryPlan.getPlanId()});
    }

    private void createAlert(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, List<String> params) {
        FaultEnum.AlarmSeverity severity = FaultEnum.AlarmSeverity.getSeverity((int)3);
        AlarmReporter.sendAlarm((long)52625520L, (String)"", (String)"", (FaultEnum.AlarmSeverity)severity, (String[])params.toArray(new String[0]));
    }

    public void beforeExecuteRecoveryPlan(RecoveryProcessorContext context, RecoveryPlan recoveryPlan) {
    }
}

