/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.utils;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class StorageResourceFinder {
    private static final Log logger = LogFactory.getInstance(StorageResourceFinder.class);
    private final RecoveryProcessorContext context;

    public StorageResourceFinder(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"Recovery context cannot be null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (null == protectGroupReplica) {
            String errorMsg = "Cannot find protection group replia from recovery context";
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(2117645L, errorMsg);
        }
        this.context = context;
    }

    public ProtectObjectStorageInfo getProtectObjectStorageInfo(StorageResource oneStorageResource) {
        ProtectGroupReplica protectGroupReplica = this.context.getProtectGroupReplica();
        logger.debug((Object)"Storage resource info: resource id=%s, wwn=%s, deviceSn=%s", new Object[]{oneStorageResource.getResourceId(), oneStorageResource.getResourceIndentifier(), oneStorageResource.getDevSn()});
        RelicaStorageInfo oneStorageInfo = null;
        for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
            logger.info((Object)"Protect object replica: %s", new Object[]{protectObjectReplica.toJson().toString()});
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                if (!storageInfo.getStorageProviderSN().equals(oneStorageResource.getDevSn())) continue;
                if (storageInfo.getStorageId().equals(oneStorageResource.getResourceId())) {
                    oneStorageInfo = storageInfo;
                    break;
                }
                if (storageInfo.getSrcStorageId().equals(oneStorageResource.getParentResourceId())) {
                    oneStorageInfo = storageInfo;
                    break;
                }
                if (!storageInfo.getStorageId().equals(oneStorageResource.getParentResourceId())) continue;
                oneStorageInfo = storageInfo;
                break;
            }
            if (null == oneStorageInfo) continue;
            break;
        }
        if (null == oneStorageInfo) {
            logger.warn((Object)"Cannot find RelicaStorageInfo by storage sn[%s], storage id[%s]", new Object[]{oneStorageResource.getDevSn(), oneStorageResource.getResourceId()});
        }
        ProtectObjectStorageInfo protectObjectStorage = this.getProtectObjectStorageInfo(oneStorageResource, protectGroupReplica, oneStorageInfo);
        return protectObjectStorage;
    }

    private ProtectObjectStorageInfo getProtectObjectStorageInfo(StorageResource oneStorageResource, ProtectGroupReplica protectGroupReplica, RelicaStorageInfo oneStorageInfo) {
        String wwn = null != oneStorageInfo ? oneStorageInfo.getProtectObjectStorageWwn() : oneStorageResource.getResourceIndentifier();
        logger.debug((Object)"Protect object storage www is %s", new Object[]{wwn});
        ProtectObjectStorageInfo protectObjectStorage = null;
        for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
            ProtectObject protectObject = protectObjectReplica.getProtectObject();
            if (null == protectObject) {
                logger.error((Object)"Protect object is null in protect object replica, ProtectGroupReplica name is % and id is %s, ProtectObjectReplica id is %s", new Object[]{protectGroupReplica.getName(), protectGroupReplica.getId(), protectObjectReplica.getId()});
                throw new LegoCheckedException(1073947393L);
            }
            logger.debug((Object)"Protect object info: %s", new Object[]{protectObject.toJSONString()});
            protectObjectStorage = protectObject.getUsedStorageResourceSet().stream().filter(item -> item.getLunWWN().equals(wwn)).findFirst().orElse(null);
            if (null != protectObjectStorage) {
                protectObjectStorage.setPoReplica(protectObjectReplica);
                break;
            }
            protectObjectStorage = protectObject.getUsedStorageResourceSet().stream().filter(item -> item.getLunWWN().equals(oneStorageResource.getResourceIndentifier())).findFirst().orElse(null);
            if (null == protectObjectStorage) continue;
            protectObjectStorage.setPoReplica(protectObjectReplica);
            break;
        }
        return protectObjectStorage;
    }
}

