/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.ScopeManagerUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.virtualization.sdk.model.PhysicalStorageDevice;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereResourcePool;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.service.IVsphereService;
import com.huawei.ism.drm.vsphere.sdk.vo.QueryViews;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.vsphere.sdk.service.IVsphereService", desc="", interfaceClass=IVsphereService.class)
public class VsphereServiceImpl
extends BaseService
implements IVsphereService {
    private static final Log logger = LogFactory.getInstance(VsphereServiceImpl.class);

    public Page pageQueryAllVsphereBySiteId(String siteId, String orderBy, int pageNo, int pageSize, boolean isAsc, Long userId) {
        List<String> sns;
        if (null == userId) {
            return new Page();
        }
        try {
            sns = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select deviceSn from DrVsphereCenter where siteId=?", (Object[])new String[]{siteId});
        }
        catch (DataAccessException ex) {
            logger.error((Object)("failed to get sn:" + siteId), (Throwable)ex, 90160758786874L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
        if (null == sns || sns.isEmpty()) {
            return new Page();
        }
        Site site = (Site)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Site.class, (Serializable)((Object)siteId));
        if (null == site) {
            return new Page();
        }
        if (0 == site.getSiteType()) {
            sns = this.filterDrResourceSN(sns, userId);
        }
        if (sns.isEmpty()) {
            return new Page();
        }
        ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("deviceSn", (Object)sns.toArray());
        QueryCondition siteIdCondition = new QueryCondition("siteId", (Object)siteId);
        queryCondition.add(condition);
        queryCondition.add(siteIdCondition);
        try {
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
            Page page = CommonDAOLocator.getBaseDao().pagedQuery(DrVsphereCenter.class, pageNo, pageSize, criterionList, orderBy, isAsc);
            return page;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"pageQueryRessources Exception.", 90160758787071L);
            throw e;
        }
    }

    public List<VsphereVirtualMachine> getVirtualMachinesByVsphere(String vsphereSn) {
        logger.debug((Object)"getVirtualMachinesByVsphere start");
        if (null == vsphereSn || vsphereSn.isEmpty()) {
            return new ArrayList<VsphereVirtualMachine>();
        }
        List result = CommonDAOLocator.getMoDao().find("from VsphereVirtualMachine where parentMo.uuid = ? order by name", new Object[]{vsphereSn});
        return result;
    }

    private List<String> filterDrResourceSN(List<String> sns, Long userId) {
        logger.debug((Object)"filterDrResourceSN start");
        if (sns.isEmpty()) {
            return new ArrayList<String>();
        }
        List filterEntities = ScopeManagerUtil.filterManagedObjectByScope(sns, (Long)userId, NetworkEntity.class);
        if (filterEntities.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> fiterSns = new ArrayList<String>();
        for (NetworkEntity entity : filterEntities) {
            fiterSns.add(entity.getSn());
        }
        return fiterSns;
    }

    public VsphereCenter getVsphereCenter(String vsphereSn) {
        if (null == vsphereSn || vsphereSn.isEmpty()) {
            logger.error((Object)"vsphereSn is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)vsphereSn);
        return vCenter;
    }

    public DrVsphereCenter getDrVsphereCenter(String vcenterUuid) {
        if (VerifyUtil.isEmpty((String)vcenterUuid)) {
            logger.error((Object)"vsphereSn is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List drVcenterList = CommonDAOLocator.getBaseDao().find("from DrVsphereCenter where deviceSn=?", new Object[]{vcenterUuid});
        if (VerifyUtil.isEmpty((Collection)drVcenterList)) {
            return null;
        }
        return (DrVsphereCenter)drVcenterList.get(0);
    }

    public Page pageQueryVirtualMachinesByVsphere(String vsphereSn, String hostOrClusterId, String orderBy, int pageNo, int pageSize, boolean isAsc, String filterName, String filterValue) {
        Object[] poolIds;
        if (null == vsphereSn || vsphereSn.isEmpty()) {
            return new Page();
        }
        if (null == orderBy || orderBy.isEmpty()) {
            orderBy = "name";
        }
        ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("topMoUuid", (Object)vsphereSn);
        queryCondition.add(condition);
        if ("name".equalsIgnoreCase(filterName) && !filterValue.isEmpty()) {
            QueryCondition conditionValue = new QueryCondition("name", (Object)filterValue);
            queryCondition.add(conditionValue);
        } else if ("status".equalsIgnoreCase(filterName) && !filterValue.isEmpty()) {
            int filterValueInt = CommUtil.convertToInteger((Object)filterValue);
            QueryCondition conditionValue = new QueryCondition("osStatus", (Object)filterValueInt);
            queryCondition.add(conditionValue);
        } else if (!VerifyUtil.isEmpty((String)hostOrClusterId) && !VerifyUtil.isEmpty((Object[])(poolIds = this.queryResourcePoolIdsByHostOrClusterId(vsphereSn, hostOrClusterId)))) {
            queryCondition.add(new QueryCondition("resourcePoolUuid", (Object)poolIds));
        }
        try {
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
            Page page = CommonDAOLocator.getBaseDao().pagedQuery(VsphereVirtualMachine.class, pageNo, pageSize, criterionList, orderBy, isAsc);
            return page;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"pageQueryRessources Exception.", 90160758787071L);
            throw e;
        }
    }

    private String[] queryResourcePoolIdsByHostOrClusterId(String vCenterId, String hostOrClusterId) {
        VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)hostOrClusterId);
        if (VerifyUtil.isEmpty((Object)compRes) || !compRes.getTopMoUuid().equals(vCenterId)) {
            throw new LegoCheckedException(1073947393L, "computeResource does not exist or not match vCenter: vCenterId=" + vCenterId + ", hostOrClusterId=" + hostOrClusterId);
        }
        List resPoolList = CommonDAOLocator.getMoDao().getAllSubMo(compRes.getMoId().longValue(), VsphereResourcePool.class);
        if (VerifyUtil.isEmpty((Collection)resPoolList)) {
            return new String[0];
        }
        String[] poolIds = new String[resPoolList.size()];
        for (int i = 0; i < resPoolList.size(); ++i) {
            poolIds[i] = ((VsphereResourcePool)resPoolList.get(i)).getUuid();
        }
        return poolIds;
    }

    public List<VsNetWork> getRecoveryVirtualNetWorkByVsphere(String vCenterSn) {
        List<Object> result = new ArrayList<VsNetWork>();
        if (VerifyUtil.isEmpty((String)vCenterSn)) {
            return result;
        }
        String hql = "from VsNetWork where topMoUuid = ? order by name asc";
        try {
            result = CommonDAOLocator.getMoDao().find(hql, new Object[]{vCenterSn});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"pageQueryRessources Exception.", 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"pageQueryRessources Exception.", (long)-1L, null, (Log)logger);
        }
        return null == result ? new ArrayList() : result;
    }

    public String getAllComputeResByVcenterUuid(String vcenterUuid) {
        if (VerifyUtil.isEmpty((String)vcenterUuid)) {
            logger.error((Object)"vCenterUuid or siteid is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        DrVsphereCenter vcenter = this.getDrVsphereCenter(vcenterUuid);
        if (null == vcenter) {
            logger.error((Object)("vCenter is null:" + vcenterUuid), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(vcenter.getSiteId());
        if (null == site) {
            logger.error((Object)("site is null:" + vcenter.getSiteId()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List comResList = CommonDAOLocator.getMoDao().getMoList(VsphereComputeResource.class, "topMoUuid", (Object)vcenterUuid);
        JSONArray array = new JSONArray();
        for (VsphereComputeResource comres : comResList) {
            String type = "Host";
            if (comres.getIsCluster().booleanValue()) {
                type = "Cluster";
            }
            JSONObject obj = new JSONObject();
            obj.put((Object)"name", (Object)comres.getName());
            obj.put((Object)"uuid", (Object)comres.getUuid());
            obj.put((Object)"type", (Object)type);
            array.add((Object)obj);
        }
        return array.toString();
    }

    public List<VsphereComputeResource> getCompResByResPools(Set<String> resPoolUuidSet) {
        logger.debug((Object)"getCompResByResPools start");
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        props.put("uuid", resPoolUuidSet.toArray(new String[resPoolUuidSet.size()]));
        List poolList = CommonDAOLocator.getMoDao().findMoBy(VsphereResourcePool.class, props);
        HashSet<Long> poolParentIdSet = new HashSet<Long>();
        for (VsphereResourcePool pool : poolList) {
            poolParentIdSet.add(pool.getParentId());
        }
        props.clear();
        props.put("moId", poolParentIdSet.toArray(new String[poolParentIdSet.size()]));
        List compResList = CommonDAOLocator.getMoDao().findMoBy(VsphereComputeResource.class, props);
        return compResList;
    }

    public String getNetWorkByHostOrClusterId(String vcenterUuid, String hostOrClusterId) {
        if (VerifyUtil.isEmpty((String)vcenterUuid)) {
            logger.error((Object)"vcenterUuid is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        DrVsphereCenter vcenter = this.getDrVsphereCenter(vcenterUuid);
        if (null == vcenter) {
            logger.error((Object)"vcenter is not existed.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostOrClusterId)) {
            return this.getAllVCenterNetWorks();
        }
        return this.getNetWorkByLocalHostOrCluster(vcenterUuid, hostOrClusterId);
    }

    private String getAllVCenterNetWorks() {
        List networkList = CommonDAOLocator.getMoDao().getAllMo(VsNetWork.class);
        ArrayList<VsNetWork> retList = new ArrayList<VsNetWork>();
        JSONArray array = new JSONArray();
        for (VsNetWork network : networkList) {
            String hostUuids = network.getHostUuids();
            if (VerifyUtil.isEmpty((String)hostUuids) || retList.contains(network)) continue;
            retList.add(network);
            JSONObject obj = new JSONObject();
            obj.put((Object)"remoteNetworkId", (Object)network.getUuid());
            obj.put((Object)"remoteNetworkName", (Object)network.getName());
            obj.put((Object)"usedVirtualMachines", (Object)this.queryUsedVirtualMachines(network.getVmUuids()));
            array.add((Object)obj);
        }
        return array.toString();
    }

    private String getNetWorkByLocalHostOrCluster(String vcenterUuid, String hostOrClusterId) {
        logger.debug((Object)("getNetWorkByLocalHostOrCluster start:hostOrClusterId=" + hostOrClusterId));
        List hostList = CommonDAOLocator.getMoDao().getMoList(VsphereHostSystem.class, "computeResourceUuid", (Object)hostOrClusterId);
        List networkList = CommonDAOLocator.getMoDao().getAllMo(VsNetWork.class);
        ArrayList<VsNetWork> retList = new ArrayList<VsNetWork>();
        JSONArray array = new JSONArray();
        for (VsphereHostSystem host : hostList) {
            if (!vcenterUuid.equals(host.getTopMoUuid()) || host.getStatus() != 0) continue;
            String hostUuid = host.getUuid();
            for (VsNetWork network : networkList) {
                String hostUuids = network.getHostUuids();
                if (VerifyUtil.isEmpty((String)hostUuids) || !hostUuids.contains(hostUuid) || retList.contains(network)) continue;
                retList.add(network);
                JSONObject obj = new JSONObject();
                obj.put((Object)"remoteNetworkId", (Object)network.getUuid());
                obj.put((Object)"remoteNetworkName", (Object)network.getName());
                obj.put((Object)"usedVirtualMachines", (Object)this.queryUsedVirtualMachines(network.getVmUuids()));
                array.add((Object)obj);
            }
        }
        return array.toString();
    }

    private String queryUsedVirtualMachines(String vmUuids) {
        if (VerifyUtil.isEmpty((String)vmUuids)) {
            logger.debug((Object)"vmUuids is null");
            return new JSONArray().toString();
        }
        QueryCondition condition = new QueryCondition("uuid", (Object)vmUuids.split(";"));
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(condition);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, conditions);
        if (VerifyUtil.isEmpty((Collection)vmList)) {
            logger.debug((Object)"vmList is null");
            return new JSONArray().toString();
        }
        JSONArray vms = new JSONArray();
        for (VsphereVirtualMachine vsphereVirtualMachine : vmList) {
            JSONObject vm = new JSONObject();
            vm.put((Object)"vmUuid", (Object)vsphereVirtualMachine.getVmUuid());
            vm.put((Object)"vmName", (Object)vsphereVirtualMachine.getName());
            vms.add((Object)vm);
        }
        return vms.toString();
    }

    public List<ProtectGroup> getProtectGroupByVmUuid(String vmUuid) {
        logger.debug((Object)("getProtectGroupByVmUuid start:vmUuid=" + vmUuid));
        ArrayList<ProtectGroup> result = new ArrayList<ProtectGroup>();
        if (VerifyUtil.isEmpty((String)vmUuid)) {
            return result;
        }
        List list = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select protectGroup.uuid, protectGroup.name from ProtectObject where moUuid=?", new Object[]{vmUuid});
        for (Object object : list) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(CommUtil.convertToString((Object)values[0]));
            protectGroup.setName(CommUtil.convertToString((Object)values[1]));
            result.add(protectGroup);
        }
        return result;
    }

    public VsphereComputeResource getVsphereComputeResource(String clusterUuid) {
        if (VerifyUtil.isEmpty((String)clusterUuid)) {
            logger.error((Object)"clusterUuid is empty.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)clusterUuid);
    }

    public boolean modifVsphereHostSystem(String hostUuid, String nvme) {
        VsphereHostSystem host = (VsphereHostSystem)CommonDAOLocator.getMoDao().getMo(VsphereHostSystem.class, "uuid", (Object)hostUuid);
        if (VerifyUtil.isEmpty((Object)host)) {
            return false;
        }
        host.setNvme(nvme);
        List physicalDevices = CommonDAOLocator.getMoDao().getAllSubMo(host.getMoId().longValue(), PhysicalStorageDevice.class);
        for (PhysicalStorageDevice physicalStorageDevice : physicalDevices) {
            if (!"NVMe_over_RoCE".equalsIgnoreCase(physicalStorageDevice.getDeviceType())) continue;
            physicalStorageDevice.setStorageWwn(nvme);
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)physicalStorageDevice);
        }
        CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)host);
        return true;
    }

    public Page getHostByVCenter(String vCenterUuid, int pageNo, int pageSize, QueryViews queryViews) {
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            return new Page();
        }
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("topMoUuid", (Object)vCenterUuid);
        queryConditions.add(condition);
        if (!VerifyUtil.isEmpty((String)queryViews.getFilterValue())) {
            QueryCondition conditionValue;
            if ("NVME".equalsIgnoreCase(queryViews.getFilterName())) {
                conditionValue = new QueryCondition("nvme", (Object)queryViews.getFilterValue());
                queryConditions.add(conditionValue);
            }
            if ("IPADDRESS".equalsIgnoreCase(queryViews.getFilterName())) {
                conditionValue = new QueryCondition("ipAddress", (Object)queryViews.getFilterValue());
                queryConditions.add(conditionValue);
            }
        }
        try {
            List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryConditions);
            Page page = CommonDAOLocator.getBaseDao().pagedQuery(VsphereHostSystem.class, pageNo, pageSize, criterionList, queryViews.getOrderBy(), queryViews.isAsc());
            ArrayList<VsphereHostSystem> vms = new ArrayList<VsphereHostSystem>();
            for (VsphereHostSystem vm : page.getResult()) {
                if (VerifyUtil.isEmpty((String)vm.getIpAddress())) continue;
                vm.setIpAddress(vm.getIpAddress().split(";")[0]);
                vms.add(vm);
            }
            page.setResult(vms);
            return page;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"pageQueryRessources Exception.", new Object[]{Long.toString(90160758787071L)});
            throw e;
        }
    }
}

