/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.service.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.alarm.AlarmGenerator;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IVirtualMachineManager;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VmDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsVMObjectHelper;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class VsphereVirtualMachineManager
implements IVirtualMachineManager {
    private static final List<Integer> RDM_DISK_TYPES = Arrays.asList(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue());
    private static final List<Integer> CONFIG_RDM_TEMPS = Arrays.asList(2, 19);
    private static final Log logger = LogFactory.getInstance(VsphereVirtualMachineManager.class);

    public int getAppType() {
        logger.debug((Object)"getAppType start");
        return 10;
    }

    public Set<String> getUnsupportedVm(Set<String> vmUuidSet, int protectType) {
        logger.debug((Object)"getUnsupportedVm start");
        List<VsphereVirtualMachine> vms = this.getVmsByVmuuids(vmUuidSet);
        return this.checkProtectedVm(vms);
    }

    public Set<String> getSpecialInvalidVm(Set<String> vmUuidSet, int templateType) {
        logger.debug((Object)"getSpecialInvalidVm start");
        return new HashSet<String>();
    }

    public Set<String> getInvalidVm(Set<String> vmUuidSet, Set<String> dsUuidSet, int templateType) {
        logger.debug((Object)"getInvalidVm start");
        HashSet<String> invalidVmSet = new HashSet<String>();
        if (2 != templateType && 19 != templateType) {
            return invalidVmSet;
        }
        if (VerifyUtil.isEmpty(vmUuidSet)) {
            return invalidVmSet;
        }
        if (VerifyUtil.isEmpty(dsUuidSet)) {
            return vmUuidSet;
        }
        String[] vmUuids = new String[vmUuidSet.size()];
        int index = 0;
        for (String vmUuid : vmUuidSet) {
            vmUuids[index++] = vmUuid;
        }
        Map<String, Set<String>> vmDataStore = this.getVmDataStoreByVmUuids(vmUuids);
        block1: for (Map.Entry<String, Set<String>> entry : vmDataStore.entrySet()) {
            String vmUuid = entry.getKey();
            Set<String> vmDsSet = entry.getValue();
            for (String dsId : vmDsSet) {
                if (dsUuidSet.contains(dsId)) continue;
                invalidVmSet.add(vmUuid);
                continue block1;
            }
        }
        return invalidVmSet;
    }

    public void updateProtectObjectInfo(ProtectGroup protectGroup, Set<String> invalidVms, Set<String> unsupportedVms) {
        String[] uuids = new String[protectGroup.getPolist().size()];
        int index = 0;
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)uuids, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        qcList.add(new QueryCondition("topMoUuid", (Object)protectGroup.getPoProviderSN(), 1));
        List vms = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, qcList);
        for (ProtectObject po : protectGroup.getPolist()) {
            VsVMObjectHelper.getInstance().generateVmBaseInfo(vms, po);
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                po.setUuid(UUIDGenerator.getUUID());
            }
            if (!VerifyUtil.isEmpty(invalidVms) && invalidVms.contains(po.getMoUuid())) {
                po.setPoStatus(ProtectObjectStatusEnum.INVALID.getValue());
                continue;
            }
            if (VerifyUtil.isEmpty(unsupportedVms) || !unsupportedVms.contains(po.getMoUuid())) continue;
            po.setPoStatus(ProtectObjectStatusEnum.UNSUPPORTED.getValue());
        }
        try {
            VsVMObjectHelper.getInstance().getComputeResourceInfo(vms, protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)("save pg topo info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
    }

    public void updateProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"updateProtectObjectStorageInfo start");
        VsVMObjectHelper.getInstance().getProtectObjectStorageInfo(protectObjectList);
    }

    public void updateProtectObjectRdmInfo(ProtectGroup protectGroup) {
        if (!CONFIG_RDM_TEMPS.contains(protectGroup.getTemplate().getType())) {
            return;
        }
        Set poSet = protectGroup.getPolist();
        ArrayList poList = new ArrayList(poSet);
        Collections.sort(poList, Comparator.comparing(ProtectObject::getName));
        JSONArray array = new JSONArray();
        for (ProtectObject po : poList) {
            JSONObject vmJson = new JSONObject();
            VsphereVirtualMachine vsphereVirtualMachine = VsphereVirtualMachineUtils.convertFrom(po);
            vmJson.put((Object)"uuid", (Object)vsphereVirtualMachine.getUuid());
            vmJson.put((Object)"vmName", (Object)vsphereVirtualMachine.getName());
            Set diskSet = vsphereVirtualMachine.getVirtualDisk();
            HashSet rdmSet = new HashSet();
            diskSet.forEach(disk -> {
                if (RDM_DISK_TYPES.contains(disk.getDiskType())) {
                    String vmPath = vsphereVirtualMachine.getVmPath();
                    String dataStoreName = VsphereCommUtil.getDatastoreName(vmPath);
                    String rdmDiskName = disk.getStorageFileName().replaceFirst("(?<=\\[)(.*)(?=\\])", dataStoreName);
                    rdmSet.add(rdmDiskName);
                }
            });
            if (!CollectionUtils.isEmpty(rdmSet)) {
                vmJson.put((Object)"rdmDisks", rdmSet);
            }
            array.add((Object)vmJson);
        }
        protectGroup.getProps().put("pgVmRdmsInfo", JSONArray.fromObject((Object)array).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getVmDataStoreByVmUuids(String[] vmUuids) {
        HashMap<String, Set<String>> queryResult = new HashMap<String, Set<String>>();
        if (VerifyUtil.isEmpty((Object[])vmUuids)) {
            return queryResult;
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "select vds.id.vmUuid, vds from VmDataStore as vds where vds.id.vmUuid in (:uuid)";
            List results = session.createQuery(hql).setParameterList("uuid", (Object[])vmUuids).list();
            for (Object o : results) {
                if (null == o) continue;
                Object[] obj = (Object[])o;
                String vmuuid = (String)obj[0];
                VmDataStore dataStore = (VmDataStore)obj[1];
                if (VerifyUtil.isEmpty((String)vmuuid) || null == dataStore) continue;
                if (!queryResult.containsKey(vmuuid)) {
                    HashSet dsSet = new HashSet();
                    queryResult.put(vmuuid, dsSet);
                }
                ((Set)queryResult.get(vmuuid)).add(dataStore.getDataStoreUuid());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query datastore error.vms is " + StringUtil.arrayToString((Object[])vmUuids) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return queryResult;
    }

    public Page getVirtualMachineByVmUuid(Set<String> vmUuidSet, String orderBy, int pageNo, int pageSize, boolean isAsc) {
        try {
            Page page;
            List vms;
            StringBuilder hql = new StringBuilder("from VsphereVirtualMachine where uuid in (");
            int length = vmUuidSet.size();
            Object[] params = new Object[length];
            int i = 0;
            for (String vmUuid : vmUuidSet) {
                params[i] = vmUuid;
                hql.append("?");
                if (i == length - 1) continue;
                hql.append(',');
                ++i;
            }
            hql.append(")");
            if (orderBy != null && orderBy.matches("\\w+")) {
                hql.append(" order by ").append(orderBy).append(isAsc ? " asc" : " desc");
            }
            if ((vms = (page = CommonDAOLocator.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, params)).getResult()) != null) {
                for (VsphereVirtualMachine vm : vms) {
                    Map props = vm.getProps() != null ? vm.getProps() : new HashMap();
                    vm.setProps(props);
                    VsVMObjectHelper.setVmConfigToProps(props, vm);
                    props.put("GUESTOSTYPE", vm.getGuestFamily());
                }
            }
            return page;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"pageQueryRessources Exception.", 90160758787071L);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getStorageResourceByVms(Set<String> vmUuidSet) {
        ArrayList<Map<String, Object>> arrayList;
        ArrayList<Map<String, Object>> jsonMap = new ArrayList<Map<String, Object>>();
        if (VerifyUtil.isEmpty(vmUuidSet)) {
            return jsonMap;
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hqls = "select distinct vd.name, lun from Lun as lun, VmDataStore as vds, VsphereVirtualMachine as vm, VsphereDataStore as vd where vm.uuid = vds.id.vmUuid and vds.id.lunWwn = lun.wwn and vd.uuid = vds.dataStoreUuid and vm.uuid in (:uuids)";
            List results = session.createQuery(hqls).setParameterList("uuids", vmUuidSet).list();
            this.dealQueryResult(results, jsonMap);
            arrayList = jsonMap;
        }
        catch (Exception e) {
            ArrayList<Map<String, Object>> arrayList2;
            try {
                logger.error((Object)("query datastore error.vms is " + vmUuidSet.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                arrayList2 = jsonMap;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return arrayList2;
        }
        DBOperationUtil.closeSession((Session)session);
        return arrayList;
    }

    public boolean isVirtualMachineInSamePlatform(VirtualDataStoreGroup dsg) {
        return true;
    }

    public List<ProtectGroup> getAllProtectGroupByProviderSn(String providerSn) {
        logger.debug((Object)"getAllProtectGroupByProviderSn start");
        String hql = "from ProtectGroup where poProviderSN = ? and poType = ? and poProviderSN in (select deviceSn from DrResource where siteId in (select siteId from Site where siteType = 0))";
        List list = CommonDAOLocator.getBaseDao().find(hql, new Object[]{providerSn, 10});
        return null == list ? new ArrayList() : list;
    }

    public void handleVmAlarm(String pgId, VirtualDataStoreGroup dsg) {
        logger.debug((Object)"handleVmAlarm start");
    }

    public void sendVmDeleteAlarm(ProtectGroup protectGroup, Set<ProtectObject> poToBeDeleted) {
        AlarmGenerator.sendProtectObjectRemoveAlarm((String)protectGroup.getUuid(), (String)protectGroup.getName(), poToBeDeleted);
    }

    public boolean checkDsgProviderSn(String pgProviderSn, String dsgProviderSn) {
        logger.debug((Object)"checkDsgProviderSn start");
        if (null == pgProviderSn || null == dsgProviderSn) {
            throw new LegoCheckedException(1073947393L);
        }
        return pgProviderSn.equals(dsgProviderSn);
    }

    private void dealQueryResult(List results, List<Map<String, Object>> jsonList) {
        logger.debug((Object)"dealQueryResult start");
        HashMap queryResult = new HashMap();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            for (Object o : results) {
                if (null == o) continue;
                Object[] obj = (Object[])o;
                String dataStoreName = (String)obj[0];
                Lun lunMo = (Lun)obj[1];
                if (!queryResult.containsKey(dataStoreName)) {
                    ArrayList value = new ArrayList();
                    queryResult.put(dataStoreName, value);
                }
                ((List)queryResult.get(dataStoreName)).add(lunMo);
            }
        }
        for (Map.Entry entry : queryResult.entrySet()) {
            String dataStoreName = (String)entry.getKey();
            ArrayList lunJsonList = new ArrayList();
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("virtualStorageName", dataStoreName);
            List luns = (List)queryResult.get(dataStoreName);
            for (Lun lun : luns) {
                HashMap<String, String> lunMap = new HashMap<String, String>();
                lunMap.put("name", lun.getName());
                lunMap.put("wwn", lun.getWwn());
                lunMap.put("storageDeviceName", lun.getParentMo().getParentMo().getName());
                lunJsonList.add(lunMap);
            }
            jsonMap.put("storageResource", lunJsonList);
            jsonList.add(jsonMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VsphereVirtualMachine> getVmsByVmuuids(Set<String> vmUuidSet) {
        ArrayList<VsphereVirtualMachine> results = new ArrayList<VsphereVirtualMachine>();
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "from VsphereVirtualMachine where uuid in (:uuids)";
            List params = DBOperationUtil.createBatchQueryParameters(new ArrayList<String>(vmUuidSet), (int)48);
            for (List param : params) {
                Query query = session.createQuery(hql);
                query.setParameterList("uuids", (Collection)param);
                List result = query.list();
                if (VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    results.add((VsphereVirtualMachine)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query datastore error.vms is " + vmUuidSet.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return results;
    }

    private Set<String> checkProtectedVm(List<VsphereVirtualMachine> vms) {
        logger.debug((Object)"checkProtectedVm start");
        HashSet<String> unsupportedVms = new HashSet<String>();
        if (VerifyUtil.isEmpty(vms)) {
            return unsupportedVms;
        }
        for (VsphereVirtualMachine vm : vms) {
            if (vm.getIsVApp().booleanValue()) {
                unsupportedVms.add(vm.getUuid());
                continue;
            }
            if (!vm.getVmConfig().contains("UNSUPPORTED")) continue;
            unsupportedVms.add(vm.getUuid());
        }
        return unsupportedVms;
    }
}

