/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.tools;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.vsphere.tools.FileHelperEx;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileHelperMgr {
    private static final FileHelperMgr MANAGER = new FileHelperMgr();
    private static final Log LOG = LogFactory.getInstance(FileHelperMgr.class);
    private final Map<String, FileHelperEx> map = new ConcurrentHashMap<String, FileHelperEx>();

    public static FileHelperMgr getInstance() {
        return MANAGER;
    }

    public synchronized FileHelperEx getFileHelper(String ip, String port, String userName, String passwd) {
        String key;
        if (VerifyUtil.isEmpty((String)ip) || VerifyUtil.isEmpty((String)port) || VerifyUtil.isEmpty((String)userName) || VerifyUtil.isEmpty((String)passwd)) {
            LOG.error((Object)"Param is empty: ip=%s, port=%s, userName=%s", new Object[]{ip, port, userName});
            throw new LegoCheckedException(1073947393L);
        }
        if (!(!"IPV6".equals(AddressUtil.ipType((String)ip)) || ip.startsWith("[") && ip.endsWith("]"))) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        if (!this.map.containsKey(key = ip + ":" + port) || this.map.get(key) == null) {
            FileHelperEx fileHelperEx = new FileHelperEx(ip, port, userName, passwd);
            this.map.put(key, fileHelperEx);
        }
        return this.map.get(key);
    }

    public synchronized FileHelperEx getFileHelper(NeMgrProtocolExtend neMgrProtocolExtend) {
        String ip = neMgrProtocolExtend.getNetworkIpAddress();
        String userName = neMgrProtocolExtend.getNetworkUserName();
        String passWd = neMgrProtocolExtend.getNetworkPassword();
        String port = (String)neMgrProtocolExtend.getExtendParams().get("port");
        return this.getFileHelper(ip, port, userName, passWd);
    }

    public void removeFileHelper(String ip, String port) {
        this.map.remove(ip + ":" + port);
    }
}

