/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.topology;

import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.topology.model.VsComputResourceTopoInfo;
import com.huawei.ism.drm.vsphere.topology.model.VsHostTopoInfo;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.Group;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-vSphere")
public class VsphereGlobalTopoBuilder
extends AbstractGlobalTopoBuilder {
    private static final Log logger = LogFactory.getInstance(VsphereGlobalTopoBuilder.class);
    private static final List<Integer> SAN_ACTIVE_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(15, 18, 23, 28, 19));
    private boolean whole = true;
    private final Collection<VsComputResourceTopoInfo> computResourceTopoInfos = new ArrayList<VsComputResourceTopoInfo>();

    public boolean isWhole() {
        return this.whole;
    }

    public void setWhole(boolean whole) {
        this.whole = whole;
    }

    public void buildTopo(TopoBaseContext context) {
        logger.debug((Object)"Vsphere global topo builder starts to build", 90160758786988L);
        this.computResourceTopoInfos.clear();
        ProtectGroup protectGroup = context.getProtectGroup();
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        ElementBox box = context.getElementBox();
        try {
            this.prepareData(protectGroup);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"error when prepare data", (Throwable)e, -1L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"error when prepare data", (long)-1L, null, (Log)logger);
        }
        int pgTemplateType = protectGroup.getTemplate().getType();
        if (SAN_ACTIVE_TEMPLATE_TYPE_LIST.contains(pgTemplateType) || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pgTemplateType) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)protectGroup)) {
            this.buildHyperMetroTopo(context, protectGroup, layout, box);
            return;
        }
        logger.debug((Object)"Vsphere global topo builder starts draw computeresource", 90160758786988L);
        for (VsComputResourceTopoInfo computeResource : this.computResourceTopoInfos) {
            List<Node> childs = this.getChildNodes(context, protectGroup, layout, box, computeResource);
            ProtectObjectStorageInfo poStorageInfo = context.getTopoBaseService().getProtectObjectStorageInfoByPgId(protectGroup.getUuid());
            String sn = poStorageInfo.getResourceProviderSN();
            Node productArrayNode = this.addStorageNode(sn, context, layout, protectGroup);
            for (Node each : childs) {
                this.createHostStorageLink(context, each, productArrayNode, true);
            }
        }
        this.computResourceTopoInfos.clear();
    }

    private List<Node> getChildNodes(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout, ElementBox box, VsComputResourceTopoInfo computeResource) {
        Set<VsHostTopoInfo> hostSystems = computeResource.getHosts();
        ArrayList<Node> childs = new ArrayList<Node>();
        for (VsHostTopoInfo hostSystem : hostSystems) {
            DrResource drHostSystem = this.getDrResourceInContext(context, hostSystem.getUuid());
            if (null == drHostSystem) continue;
            Site prodSite = this.getSiteInContext(context, drHostSystem.getSiteId());
            Group group = this.getOrCreateGroup(box, prodSite, layout);
            Node hostNode = (Node)box.getElementByID((Object)(hostSystem.getUuid() + "---" + computeResource.getComputResourceUuid()));
            if (hostNode == null) {
                hostNode = this.createHostNode(hostSystem, prodSite, computeResource);
                this.initNodeLocation(hostNode, (Node)group, layout);
                group.addChild((IData)hostNode);
                TopoServiceUtil.addElementToBox((ElementBox)box, (IData)hostNode);
            }
            childs.add(hostNode);
            this.addIdtoList(context.getHostNodeIds(), (String)hostNode.getID());
            this.addProtectGroupIDToElement((Element)hostNode, protectGroup.getUuid());
        }
        return childs;
    }

    private void buildHyperMetroTopo(TopoBaseContext context, ProtectGroup protectGroup, ElementBox layout, ElementBox box) {
        for (VsComputResourceTopoInfo computeResource : this.computResourceTopoInfos) {
            Set<VsHostTopoInfo> hostSystems = computeResource.getHosts();
            for (VsHostTopoInfo hostSystem : hostSystems) {
                DrResource drHostSystem = this.getDrResourceInContext(context, hostSystem.getUuid());
                if (null == drHostSystem) continue;
                Site prodSite = this.getSiteInContext(context, drHostSystem.getSiteId());
                Group group = this.getOrCreateGroup(box, prodSite, layout);
                Node hostNode = (Node)box.getElementByID((Object)(hostSystem.getUuid() + "---" + computeResource.getComputResourceUuid()));
                if (hostNode == null) {
                    hostNode = this.createHostNode(hostSystem, prodSite, computeResource);
                    this.initNodeLocation(hostNode, (Node)group, layout);
                    group.addChild((IData)hostNode);
                    TopoServiceUtil.addElementToBox((ElementBox)box, (IData)hostNode);
                    this.addIdtoList(context.getHostNodeIds(), (String)hostNode.getID());
                }
                context.getVmEsxNode().add(hostNode);
                this.addProtectGroupIDToElement((Element)hostNode, protectGroup.getUuid());
            }
        }
    }

    private void prepareData(ProtectGroup pg) {
        String topoString = (String)pg.getProps().get("pg_topo");
        JSONArray array = JSONArray.fromObject((Object)topoString);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            VsComputResourceTopoInfo info = new VsComputResourceTopoInfo();
            String computeResourceUuid = obj.getString("computResourceUuid");
            info.setComputResourceUuid(computeResourceUuid);
            info.setComputeResourceName(obj.getString("computeResourceName"));
            HashSet<VsHostTopoInfo> hostSet = new HashSet<VsHostTopoInfo>();
            JSONArray hosts = obj.getJSONArray("hosts");
            if (null == hosts) {
                logger.info((Object)"the hosts is empty");
                continue;
            }
            for (int j = 0; j < hosts.size(); ++j) {
                int healthStatus;
                int status;
                JSONObject host = hosts.getJSONObject(j);
                try {
                    status = Integer.parseInt(host.get("status").toString());
                    healthStatus = Integer.parseInt(host.get("healthStatus").toString());
                }
                catch (NumberFormatException e) {
                    logger.error((Object)"parseInt error.", (Throwable)e, 90160758787071L);
                    throw new LegoCheckedException(1073947393L, (Throwable)e);
                }
                VsHostTopoInfo hostInfo = new VsHostTopoInfo();
                hostInfo.setComputeResourceUuid(computeResourceUuid);
                hostInfo.setUuid(host.getString("uuid"));
                hostInfo.setName(host.getString("name"));
                hostInfo.setStatus(status);
                hostInfo.setHealthStatus(healthStatus);
                hostInfo.setVersion(host.getString("version"));
                hostSet.add(hostInfo);
            }
            info.setHosts(hostSet);
            this.computResourceTopoInfos.add(info);
        }
    }

    private Node addStorageNode(String sn, TopoBaseContext context, ElementBox layout, ProtectGroup protectGroup) {
        ElementBox box = context.getElementBox();
        DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, sn);
        if (drStorage == null) {
            return null;
        }
        String productStorageSiteID = drStorage.getSiteId();
        Site productStorageSite = this.getSiteInContext(context, productStorageSiteID);
        Group productStorageSiteGroup = this.getOrCreateGroup(box, productStorageSite, layout);
        Node productArrayNode = (Node)box.getElementByID((Object)(drStorage.getDeviceSn() + "---" + productStorageSiteID));
        if (productArrayNode == null) {
            productArrayNode = this.createStorageNode(drStorage);
            this.initNodeLocation(productArrayNode, (Node)productStorageSiteGroup, layout);
            productStorageSiteGroup.addChild((IData)productArrayNode);
            TopoServiceUtil.addElementToBox((ElementBox)box, (IData)productArrayNode);
        }
        this.addProtectGroupIDToElement((Element)productArrayNode, protectGroup.getUuid());
        return productArrayNode;
    }

    private Node createStorageNode(DrStorage storage) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node storageNode = new Node((Object)(storage.getDeviceSn() + "---" + storage.getSiteId()));
        storageNode.setStyle("label.color", 35020);
        StorageElement.setImageByStatus((Node)storageNode, (Integer)Integer.valueOf(storage.getStatus()));
        storageNode.setStyle("label.bold", false);
        storageNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        storageNode.setClient("isHostOrStorage", (Object)"isstorage");
        storageNode.setClient("imageWidth", 48.0);
        storageNode.setClient("imageHeight", 60.0);
        storageNode.setName(TopoServiceUtil.getNodeShowName((String)storage.getName()));
        storageNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)storage));
        storageNode.setStyle("select.alpha", 1.0);
        storageNode.setStyle("select.style", (Object)"none");
        return storageNode;
    }

    private Node createHostNode(VsHostTopoInfo hostInfo, Site site, VsComputResourceTopoInfo computeResource) {
        Node hostNode = new Node((Object)(hostInfo.getUuid() + "---" + computeResource.getComputResourceUuid()));
        this.setVsphereHostSystemImage(hostNode, hostInfo);
        if (site.getSiteType() == 0) {
            this.setLocalHostInfo(hostInfo, site, hostNode);
        }
        hostNode.setClient("imageWidth", 48.0);
        hostNode.setClient("imageHeight", 60.0);
        hostNode.setClient("netWorkPrimalName", (Object)hostInfo.getName());
        hostNode.setName(TopoServiceUtil.getNodeShowName((String)hostInfo.getName()));
        hostNode.setClient("clusterSn", (Object)computeResource.getComputResourceUuid());
        hostNode.setToolTip(this.createVsphereHostSystemToolTip(hostInfo));
        this.setNodeExtName(hostNode, hostInfo.getName(), computeResource.getComputeResourceName(), "ism.drm.topo.hypermetro.cluster");
        this.setHostNodeStyle(hostNode);
        return hostNode;
    }

    private void setHostNodeStyle(Node hostNode) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        hostNode.setStyle("label.bold", false);
        hostNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostNode.setStyle("select.alpha", 1.0);
        hostNode.setStyle("select.style", (Object)"none");
        hostNode.setStyle("label.color", 35020);
        String[] nameArray = new String[1];
        String langInfo = resourceManager.getLangInfo();
        nameArray[0] = "zh".equals(langInfo) ? "/theme/recoverydirector/images/topo/virtualization_server_icon_cn.png" : "/theme/recoverydirector/images/topo/virtualization_server_icon_en.png";
        hostNode.setStyle("icons.names", (Object)nameArray);
        hostNode.setStyle("icons.position", (Object)"top.top");
        hostNode.setStyle("icons.xgap", 5.0);
        hostNode.setStyle("icons.ygap", -20.0);
    }

    private void setLocalHostInfo(VsHostTopoInfo hostInfo, Site site, Node hostNode) {
        hostNode.setClient("isHostOrStorage", (Object)"isvsphere");
        hostNode.setClient("devSN", (Object)hostInfo.getUuid());
        hostNode.setClient("srcSiteID", (Object)site.getSiteId());
        hostNode.setClient("srcSiteName", (Object)("<![CDATA[" + site.getName() + "]]>"));
        hostNode.setClient("topoHostName", (Object)("<![CDATA[" + hostInfo.getName() + "]]>"));
    }

    private String createVsphereHostSystemToolTip(VsHostTopoInfo hostInfo) {
        StringBuilder tooltipBuilder = new StringBuilder();
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.name", (String)StringEscapeUtil.escape((String)hostInfo.getName()));
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.vsphere.hostsystem.version", (String)hostInfo.getVersion());
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        int hostStatus = hostInfo.getStatus();
        if (hostStatus == 0) {
            int healthStatus = hostInfo.getHealthStatus();
            String status = resourceManager.getText("ism.drm.topo.vsphere.status." + healthStatus);
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.storage.status", (String)status);
        } else if (hostStatus == -1) {
            String status = resourceManager.getText("ism.drm.host.offline");
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.storage.status", (String)status);
        } else {
            String status = resourceManager.getText("ism.drm.host.unheard");
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.storage.status", (String)status);
        }
        return tooltipBuilder.toString();
    }

    private void setVsphereHostSystemImage(Node node, VsHostTopoInfo hostInfo) {
        int hostStatus = hostInfo.getStatus();
        if (hostStatus == 0) {
            int healthStatus = hostInfo.getHealthStatus();
            if (healthStatus == DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E.GREEN.getValue()) {
                node.setImage("/theme/recoverydirector/images/topo/esxserver.png");
            } else if (healthStatus == DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E.YELLOW.getValue()) {
                node.setImage("/theme/recoverydirector/images/topo/esxserver_warning.png");
            } else if (healthStatus == DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E.RED.getValue()) {
                node.setImage("/theme/recoverydirector/images/topo/esxserver_warning.png");
            } else {
                node.setImage("/theme/recoverydirector/images/topo/esxserver_unknown.png");
            }
        } else if (hostStatus == -1) {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_offline.png");
        } else {
            node.setImage("/theme/recoverydirector/images/topo/esxserver_unknown.png");
        }
    }
}

