/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.detect;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.detect.AbstractStorageEventDetector;
import com.huawei.ism.drm.detect.ResourceEventIterator;
import com.huawei.ism.drm.storage.hvs.detect.HvsStorageEventIteratorBuilder;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceEvent;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceQuery;
import com.huawei.ism.drm.storage.manager.StorageManagerUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HvsStorageEventDetector
extends AbstractStorageEventDetector<HvsDeviceEvent> {
    public static final String START_SUPPORT_VERSION = "V600R005C26";
    private static final Log LOG = LogFactory.getInstance(HvsStorageEventDetector.class);
    private static final Map<String, Long> ERROR_STORAGE_DELAY_MAP = new HashMap<String, Long>();
    private static final Set<Long> ERRORS_TO_DELAY = new HashSet<Long>(Arrays.asList(1077949061L, 1077949071L, 1077949006L, 1077949001L));
    private static final int DELAY_TIME = 300;
    private final BiFunction<RestConnection, HvsDeviceQuery, List<HvsDeviceEvent>> function;
    private final Map<String, Object> filters;

    public HvsStorageEventDetector(BiFunction<RestConnection, HvsDeviceQuery, List<HvsDeviceEvent>> function, Map<String, Object> filters) {
        super("REST");
        this.function = Objects.requireNonNull(function);
        this.filters = Objects.requireNonNull(filters);
    }

    private static boolean isDelayTimeValid(Long delayTime) {
        if (delayTime == null) {
            return false;
        }
        long balance = delayTime - Instant.now().getEpochSecond();
        return balance <= 300L && balance > 0L;
    }

    private static boolean detectStorage(DrStorage drStorage) {
        RestConnection hvsConnection;
        try {
            hvsConnection = RestConnectionManager.getInstance().getConnection(drStorage.getDeviceSn());
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Get hvs conn failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        if (hvsConnection != null && hvsConnection.isValid()) {
            ERROR_STORAGE_DELAY_MAP.remove(drStorage.getDeviceSn());
            return true;
        }
        return false;
    }

    protected boolean checkStorage(StorageNE storageNe) {
        return super.checkStorage(storageNe) && StorageManagerUtil.versionCompare((String)storageNe.getVersion(), (String)START_SUPPORT_VERSION) >= 0;
    }

    public boolean isDetectable(DrStorage drStorage) {
        if (!ERROR_STORAGE_DELAY_MAP.containsKey(drStorage.getDeviceSn())) {
            return true;
        }
        long delayTime = ERROR_STORAGE_DELAY_MAP.get(drStorage.getDeviceSn());
        if (HvsStorageEventDetector.isDelayTimeValid(delayTime)) {
            return false;
        }
        boolean isStorageAvailable = HvsStorageEventDetector.detectStorage(drStorage);
        if (isStorageAvailable) {
            ERROR_STORAGE_DELAY_MAP.remove(drStorage.getDeviceSn());
            return true;
        }
        this.updateStorageDetectDelayTime(drStorage);
        return false;
    }

    private void updateStorageDetectDelayTime(DrStorage drStorage) {
        Long delayTime = ERROR_STORAGE_DELAY_MAP.get(drStorage.getDeviceSn());
        if (HvsStorageEventDetector.isDelayTimeValid(delayTime)) {
            return;
        }
        delayTime = Instant.now().getEpochSecond() + 300L;
        ERROR_STORAGE_DELAY_MAP.put(drStorage.getDeviceSn(), delayTime);
    }

    public void handleException(DrStorage drStorage, LegoCheckedException e) {
        if (ERRORS_TO_DELAY.contains(e.getErrorCode())) {
            this.updateStorageDetectDelayTime(drStorage);
        }
    }

    public void unlockResourceDetect(String devSn) {
        ERROR_STORAGE_DELAY_MAP.remove(devSn);
    }

    public long queryClock(DrStorage storage) {
        RestConnection hvsConnection = RestConnectionManager.getInstance().getConnection(storage.getDeviceSn());
        if (hvsConnection == null) {
            return 0L;
        }
        List events = (List)hvsConnection.use(this.function).apply(HvsDeviceQuery.builder().count(1).filters(this.filters).build());
        return events.stream().mapToLong(event -> NumberUtil.convertToLong((Object)event.getSequence(), (long)0L)).max().orElse(0L);
    }

    public ResourceEventIterator<DrStorage, HvsDeviceEvent> detect(DrStorage storage, long timestamp) {
        HashMap<String, Object> conditions = new HashMap<String, Object>(this.filters);
        String sequence = String.valueOf(timestamp);
        conditions.put("startSeq", sequence);
        return new HvsStorageEventIteratorBuilder(storage, this.function.andThen(this.exclude(sequence)), conditions).build();
    }

    private Function<List<HvsDeviceEvent>, List<HvsDeviceEvent>> exclude(String sequence) {
        return events -> events.stream().filter(event -> !sequence.equals(event.getSequence())).collect(Collectors.toList());
    }
}

