/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.detect.configuration;

import com.huawei.ism.drm.storage.hvs.detect.HvsStorageEventDetector;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyExtend;
import com.huawei.ism.drm.storage.hvs.discovery.proxy.HvsDeviceProxyLocator;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HvsStorageEventDetectorConfiguration {
    private static final int EVENT = 0;
    private static final int CLEARED_ALARM = 2;
    private static final int OPERATION_LOG = 3;

    @Bean
    public HvsDeviceProxyExtend hvsDeviceProxyExtend() {
        return HvsDeviceProxyLocator.getInstance().getHvsDeviceProxyExtend();
    }

    @Bean
    public HvsStorageEventDetector hvsStorageCurrentAlarmDetector(HvsDeviceProxyExtend extend) {
        return new HvsStorageEventDetector(extend::queryCurrentAlarms, Collections.emptyMap());
    }

    @Bean
    public HvsStorageEventDetector hvsStorageHistoryEventDetector(HvsDeviceProxyExtend extend) {
        return new HvsStorageEventDetector(extend::queryHistoryEvents, Collections.singletonMap("type", 0));
    }

    @Bean
    public HvsStorageEventDetector hvsStorageHistoryClearedAlarmDetector(HvsDeviceProxyExtend extend) {
        return new HvsStorageEventDetector(extend::queryHistoryEvents, Collections.singletonMap("type", 2));
    }

    @Bean
    public HvsStorageEventDetector hvsStorageHistoryOperationLogDetector(HvsDeviceProxyExtend extend) {
        return new HvsStorageEventDetector(extend::queryHistoryEvents, Collections.singletonMap("type", 3));
    }
}

