/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.HyperVault;
import com.huawei.ism.array.sdk.model.HyperVaultCopy;
import com.huawei.ism.array.sdk.model.HyperVaultJob;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageHyperVaultHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyperVaultHandlerImpl
extends AbstractRestStorageHandler
implements IStorageHyperVaultHandler {
    public List<HyperVault> queryHyperVaultByResName(String sn, String resName) {
        VerifyUtil.checkStrs((String[])new String[]{sn});
        StringBuilder url = new StringBuilder("/rest/${deviceID}/HyperVault");
        if (!VerifyUtil.isEmpty((String)resName)) {
            url.append("?filter=LOCALRESOURCENAME::").append(resName);
            url.append("&range=[0-65536]");
        } else {
            url.append("?range=[0-65536]");
        }
        logger.debug((Object)"Get HyperVault: url = %s, deviceId = %s", new Object[]{url, sn});
        List records = this.getConnection(sn).getBatch(url.toString(), null);
        ArrayList<HyperVault> list = new ArrayList<HyperVault>();
        for (Map record : records) {
            list.add(HVSRestTransition.transitionHyperVault((String)sn, (Map)record));
        }
        return list;
    }

    public HyperVault createHyperVault(HyperVault info, boolean backupsInit) {
        if (null == info) {
            logger.error((Object)"parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String sn = info.getDevSn();
        Integer resourceType = info.getResourceType();
        String localResourceId = info.getLocalResourceId();
        String remoteDeviceId = info.getRemoteDeviceId();
        String remoteResourceId = info.getRemoteResourceId();
        VerifyUtil.checkStrs((String[])new String[]{sn, localResourceId, remoteDeviceId, remoteResourceId});
        if (null == resourceType) {
            resourceType = XveMOType.FILESYSTEM.getValue();
        }
        StringBuilder url = new StringBuilder("/rest/${deviceID}/HyperVault");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("TYPE", Integer.toString(XveMOType.HyperVault.getValue()));
        param.put("RESOURCETYPE", resourceType.toString());
        param.put("LOCALRESOURCEID", localResourceId);
        param.put("ENABLEREMOTEBACKUP", "0");
        param.put("REMOTEDEVICEID", remoteDeviceId);
        param.put("REMOTERESOURCEID", remoteResourceId);
        param.put("STARTBACKUPAFTERCREATE", backupsInit ? "0" : "1");
        param.put("RECOVERPOLICY", "2");
        param.put("BACKUPRATE", "2");
        logger.debug((Object)"Post createHyperVault: url = %s, deviceId = %s, localResourceId = %s, remoteResourceId = %s, backupsInit = %s", new Object[]{url, sn, localResourceId, remoteResourceId, backupsInit});
        Map record = this.getConnection(sn).post(url.toString(), param);
        if (!VerifyUtil.isEmpty((Map)record)) {
            logger.debug((Object)"createHyperVault success. response is %s", new Object[]{record});
        }
        HyperVault hyperVault = HVSRestTransition.transitionHyperVault((String)sn, (Map)record);
        return hyperVault;
    }

    public HyperVaultJob queryJob(String sn, String jobId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, jobId});
        String url = "/rest/${deviceID}/HyperVaultJob/" + jobId;
        logger.debug((Object)"Get hyperVaultJob: url = %s, deviceID = %s", new Object[]{url, sn});
        Map record = this.getConnection(sn).get(url, null);
        logger.debug((Object)("Get hyperVaultJob success. Job =" + record));
        HyperVaultJob job = HVSRestTransition.transitionHyperVaultJob((String)sn, (Map)record);
        return job;
    }

    public List<HyperVaultCopy> queryCopysByHyperVault(String sn, String vaultId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, vaultId});
        StringBuilder url = new StringBuilder("/rest/${deviceID}/HyperVaultCopy");
        url.append("?PARENTTYPE=").append(XveMOType.HyperVault.getValue());
        url.append("&PARENTID=").append(vaultId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"Get copysByHyperVault: url = %s, deviceID = %s", new Object[]{url, sn});
        List records = this.getConnection(sn).getBatch(url.toString(), null);
        ArrayList<HyperVaultCopy> list = new ArrayList<HyperVaultCopy>();
        for (Map record : records) {
            list.add(HVSRestTransition.transitionHyperVaultCopy((String)sn, (Map)record));
        }
        return list;
    }

    public void deleteCopy(String sn, String copyId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, copyId});
        String url = "/rest/${deviceID}/HyperVaultCopy/" + copyId;
        logger.debug((Object)"Delete copyByHyperVault: url = %s, deviceID = %s", new Object[]{url, sn});
        this.getConnection(sn).delete(url, null);
    }

    public void disablePolicy(String sn, String policyId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, policyId});
        String url = "/rest/${deviceID}/HyperVaultPolicy/" + policyId;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("POLICYSTATUS", "1");
        logger.debug((Object)"Put disablePolicy: url = %s, deviceID = %s, param = %s", new Object[]{url, sn, param});
        this.getConnection(sn).put(url, param);
    }

    public String manualBackup(String sn, String vaultId, XveEnumDefine.VAULT_ACTION_TYPE_E actionType) {
        VerifyUtil.checkStrs((String[])new String[]{sn, vaultId});
        if (null == actionType) {
            logger.error((Object)"actionType is null");
            throw new LegoCheckedException(1073947393L);
        }
        String url = "/rest/${deviceID}/HyperVault/start";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("TYPE", Integer.toString(XveMOType.HyperVault.getValue()));
        param.put("ID", vaultId);
        param.put("ACTIONTYPE", Integer.toString(actionType.getValue()));
        logger.debug((Object)"Put manualBackup: url = %s, deviceID = %s, param = %s", new Object[]{url, sn, param});
        Map response = this.getConnection(sn).put(url, param);
        logger.debug((Object)"manual backup success. jobId = %s", new Object[]{response.get("JOBID")});
        return (String)response.get("JOBID");
    }

    public String restoreHyperVaultCopy(String sn, String copyId) {
        VerifyUtil.checkStrs((String[])new String[]{sn, copyId});
        String url = "/rest/${deviceID}/HyperVaultCopy/RestoreHyperVaultCopy";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("TYPE", Integer.toString(XveMOType.HyperVaultCopy.getValue()));
        param.put("ID", copyId);
        logger.debug((Object)"Put restoreHyperVaultCopy: url = %s, deviceID = %s, param = %s", new Object[]{url, sn, param});
        Map response = this.getConnection(sn).put(url, param);
        logger.debug((Object)"restoreHyperVaultCopy success. jobId = %s", new Object[]{response.get("JOBID")});
        return (String)response.get("JOBID");
    }

    public List<RemoteDevice> queryRemoteDevices(String sn) {
        if (VerifyUtil.isEmpty((String)sn)) {
            logger.error((Object)"sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = "/rest/${deviceID}/REMOTE_DEVICE?filter=ARRAYTYPE::" + XveEnumDefinePParent.EPL_ARRAY_TYPE_E.EPL_ARRAY_PRIVATE.getValue();
        logger.debug((Object)"Get remoteDevices: url = %s, deviceID = %s", new Object[]{url, sn});
        List records = this.getConnection(sn).getBatch(url, null);
        ArrayList<RemoteDevice> list = new ArrayList<RemoteDevice>();
        for (Map record : records) {
            list.add(HVSRestTransition.transitionRemoteDevice((String)sn, (Map)record));
        }
        return list;
    }

    public List<StorageResource> queryRemoteResource(String sn, long capacityByte, String remoteDeviceId, XveEnumDefinePParent.EPL_ARRAY_TYPE_E arrayType, XveMOType resType, XveEnumDefine.RSSLUN_TYPE_E rssType) {
        VerifyUtil.checkStrs((String[])new String[]{sn, remoteDeviceId});
        if (null == arrayType) {
            logger.error((Object)"arrayType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == resType) {
            logger.error((Object)"resType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == rssType) {
            logger.error((Object)"rssType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        StringBuilder url = new StringBuilder("/rest/${deviceID}/REMOTE_LUN");
        url.append("?ARRAYTYPE=").append(arrayType.getValue());
        url.append("&USED=false");
        url.append("&RESTYPE=").append(resType.getValue());
        url.append("&RSSTYPE=").append(rssType.getValue());
        url.append("&DEVICEID=").append(remoteDeviceId);
        url.append("&filter=HEALTHSTATUS::1%20and%20CAPACITYBYTE:[").append(capacityByte).append(",)");
        url.append("&range=[0-65536]");
        logger.debug((Object)"Get remoteResource: url = %s, deviceID = %s", new Object[]{url.toString(), sn});
        List records = this.getConnection(sn).getBatch(url.toString(), null);
        ArrayList<StorageResource> list = new ArrayList<StorageResource>();
        switch (resType) {
            case LUN: {
                for (Map record : records) {
                    list.add((StorageResource)HVSRestTransition.transitionXveLun((String)sn, (Map)record));
                }
                break;
            }
            case FILESYSTEM: {
                for (Map record : records) {
                    NasFileSystem fileSystem = HVSRestTransition.transitionFileSystem((String)sn, (Map)record);
                    fileSystem.setResourceId(this.parseRemoteResourceId(fileSystem.getResourceId()));
                    list.add((StorageResource)fileSystem);
                }
                break;
            }
            default: {
                logger.info((Object)("not supported resource type: " + resType));
            }
        }
        return list;
    }

    private String parseRemoteResourceId(String remoteResourceId) {
        if (VerifyUtil.isEmpty((String)remoteResourceId)) {
            return remoteResourceId;
        }
        String[] split = remoteResourceId.split(";");
        if (split.length > 1) {
            return split[1];
        }
        return remoteResourceId;
    }

    public List<String> queryPolicyIds(String sn, String vaultId, String policyType) {
        VerifyUtil.checkStrs((String[])new String[]{sn, vaultId});
        StringBuilder url = new StringBuilder("/rest/${deviceID}/HyperVaultPolicy");
        url.append("?TYPE=").append(XveMOType.HyperVaultPolicy.getValue());
        url.append("&PARENTTYPE=").append(XveMOType.HyperVault.getValue());
        url.append("&PARENTID=").append(vaultId);
        url.append("&filter=PARENTID:").append(vaultId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"Get policyIds: url = %s, deviceID = %s", new Object[]{url.toString(), sn});
        List records = this.getConnection(sn).getBatch(url.toString(), null);
        ArrayList<String> list = new ArrayList<String>();
        for (Map record : records) {
            String id = (String)record.get("ID");
            if (VerifyUtil.isEmpty((String)id)) {
                logger.warn((Object)("one policy's id is empty, sn=" + sn + ", vaultId=" + vaultId));
                continue;
            }
            String type = (String)record.get("POLICYTYPE");
            if (!VerifyUtil.isEmpty((String)policyType)) {
                if (!policyType.equals(type)) continue;
                list.add(id);
                continue;
            }
            list.add(id);
        }
        return list;
    }
}

