/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.sdk.model.BackupImage;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageBackupImageHandlerImpl
extends AbstractRestStorageHandler {
    private static final Long SECTOR_SIZE_HVS = 512L;

    public String restore(String devSn, String imageId, Map<String, String> lunRelationships) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{devSn, imageId, lunRelationships});
        logger.debug((Object)"start restore backup image.imageId:[%s].lunRelationship:[%s]", new Object[]{imageId, lunRelationships.toString()});
        RestConnection connection = this.getConnection(devSn);
        JSONObject params = new JSONObject();
        JSONObject targetLocation = new JSONObject();
        JSONArray lunRelationshipArray = new JSONArray();
        for (Map.Entry<String, String> entry : lunRelationships.entrySet()) {
            JSONObject lunRelation = new JSONObject();
            String srcLunInfo = entry.getKey();
            String tgtLunInfo = entry.getValue();
            String[] srcLunInfoArr = srcLunInfo.split(":");
            String[] tgtLunInfoArr = tgtLunInfo.split(":");
            String srcLunId = srcLunInfoArr[0];
            String tgtLunId = tgtLunInfoArr[0];
            lunRelation.put((Object)"sID", (Object)srcLunId);
            lunRelation.put((Object)"tID", (Object)tgtLunId);
            if (srcLunInfoArr.length > 1 && tgtLunInfoArr.length > 1) {
                String srcWWN = srcLunInfoArr[1];
                String tgtWWN = tgtLunInfoArr[1];
                lunRelation.put((Object)"sWWN", (Object)srcWWN);
                lunRelation.put((Object)"tWWN", (Object)tgtWWN);
            }
            lunRelationshipArray.add((Object)lunRelation);
        }
        targetLocation.put((Object)"LunRelationships", (Object)lunRelationshipArray);
        params.put((Object)"protectObjectType", (Object)6);
        params.put((Object)"imageID", (Object)imageId);
        params.put((Object)"targetLocation", (Object)targetLocation);
        String url = "/rest/${deviceID}/cloudbackup_restore/cb_lun_luncg_restore";
        logger.debug((Object)"Put restore.param:[%s], url = %s, deviceID = %s", new Object[]{params.toString(), url, devSn});
        Map response = connection.putForObject(url, (Object)params);
        logger.debug((Object)"restore.response:[%s]", new Object[]{response.toString()});
        return (String)response.get("requestID");
    }

    public BackupImage query(String engineId, String imageId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId, imageId});
        RestConnection connection = this.getConnection(engineId);
        String url = "/rest/${deviceID}/backup_image/" + imageId;
        try {
            logger.debug((Object)"Get backupImage: url = %s, devSn = %s", new Object[]{url, engineId});
            Map map = connection.get(url, null);
            logger.debug((Object)"Get backupImage result is %s", new Object[]{map});
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)map)) {
                return this.transitionBackupImage(engineId, map);
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("queryImage error. url is " + url + ", deviceID is " + engineId), (Throwable)le);
            if (348346369L == le.getErrorCode()) {
                return null;
            }
            logger.error((Object)"queryImage error.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("queryImage error. url is " + url + ", deviceID is " + engineId), (Throwable)e);
            throw new LegoCheckedException("queryImage failed.", (Throwable)e);
        }
    }

    public List<BackupImage> query(String engineId, Map<String, String> filter) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId});
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject(filter);
        RestConnection connection = this.getConnection(engineId);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/backup_image?filter=");
        try {
            ArrayList<BackupImage> backupImages = new ArrayList<BackupImage>();
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                url.append(entry.getKey()).append("::").append(entry.getValue()).append("&");
            }
            url.append("range=[0-100]");
            logger.debug((Object)"Get backupImages: url = %s, devSn = %s", new Object[]{url, engineId});
            List results = connection.getBatch(url.toString(), null, false);
            for (Map result : results) {
                backupImages.add(this.transitionBackupImage(engineId, result));
            }
            return backupImages;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query BackupImage error. url = " + url + ", devSn = " + engineId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query BackupImage error. url = " + url + ", devSn = " + engineId), (Throwable)e);
            throw new LegoCheckedException("query BackupImage failed.", (Throwable)e);
        }
    }

    public String delete(String engineId, String imageId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{engineId, imageId});
        logger.debug((Object)("deleteImage: devSn:" + engineId + ", imageId:" + imageId));
        RestConnection connection = this.getConnection(engineId);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/backup_image/" + imageId);
        try {
            logger.debug((Object)"Delete backupImage: url = %s, devSn = %s", new Object[]{url, engineId});
            Map response = connection.deleteForObject(url.toString(), null);
            logger.debug((Object)"Delete backupImage. response request id = %s", new Object[]{response.get("requestID")});
            return (String)response.get("requestID");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete BackupImage error. url is " + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete BackupImage failed. url is " + url), (Throwable)e);
            throw new LegoCheckedException("delete BackupImage failed.", (Throwable)e);
        }
    }

    BackupImage transitionBackupImage(String engineId, Map<String, String> resultMap) {
        if (VerifyUtil.isEmpty(resultMap)) {
            logger.error((Object)"parameter error. input param resultMap is null");
            throw new LegoCheckedException(1073947393L);
        }
        BackupImage image = new BackupImage();
        image.setId(resultMap.get("ID"));
        image.setRepositoryID(resultMap.get("repositoryID"));
        image.setBackupPlanId(resultMap.get("backupPlanID"));
        image.setCreateTime(Long.parseLong(resultMap.get("createTime")));
        String pathStr = resultMap.get("backupPath");
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)pathStr)) {
            BackupImage.BackupPath path = (BackupImage.BackupPath)JSONObject.toBean((String)pathStr, BackupImage.BackupPath.class);
            image.setBackupPath(path);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)resultMap.get("lunList"))) {
            String listStr = resultMap.get("lunList");
            JSONArray listObj = JSONArray.fromObject((Object)listStr);
            ArrayList<Lun> lunList = new ArrayList<Lun>();
            for (Object obj : listObj) {
                JSONObject jsonObject = JSONObject.fromObject(obj);
                String lunId = jsonObject.containsKey((Object)"lunID") ? jsonObject.get("lunID").toString() : jsonObject.get("objectID").toString();
                String lunName = jsonObject.containsKey((Object)"lunName") ? jsonObject.get("lunName").toString() : jsonObject.get("name").toString();
                Long capacity = jsonObject.containsKey((Object)"lunSize") ? Long.valueOf(jsonObject.get("lunSize").toString()) : Long.valueOf(jsonObject.get("size").toString());
                String lunWwn = jsonObject.containsKey((Object)"lunWwn") ? jsonObject.get("lunWwn").toString() : jsonObject.get("diskKey").toString();
                Lun lun = new Lun();
                lun.setLunId(lunId);
                lun.setName(lunName);
                lun.setCapacity(Long.valueOf(capacity / SECTOR_SIZE_HVS));
                lun.setWwn(lunWwn);
                lun.setDevSn(engineId);
                lunList.add(lun);
            }
            image.setLunList(lunList);
        }
        return image;
    }
}

