/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageHostHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageHostHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageHostHandler {
    public ArrayHost createHost(String devSn, String name, int operationSystem, String description, String ip) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)name)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/host";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.HOST.getValue()));
        params.put("NAME", name);
        params.put("OPERATIONSYSTEM", Integer.toString(operationSystem));
        if (!VerifyUtil.isEmpty((String)description)) {
            params.put("DESCRIPTION", description);
        }
        if (!VerifyUtil.isEmpty((String)ip)) {
            params.put("IP", ip);
        }
        logger.debug((Object)"start createHost, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, params});
        Map record = connection.post(url, params);
        logger.debug((Object)"end createHost, url: %s, devsn: %s", new Object[]{url, devSn});
        ArrayHost host = HVSRestTransition.transitionArrayHost((String)devSn, (Map)record);
        return host;
    }

    public ArrayHostGroup createHostGroup(String devSn, String name, String description) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)name)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/hostgroup";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.HOSTGROUP.getValue()));
        params.put("NAME", name);
        params.put("DESCRIPTION", null == description ? "" : description);
        logger.debug((Object)"start createHostGroup, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, params});
        Map record = connection.post(url, params);
        logger.debug((Object)"end createHostGroup, url: %s, devsn: %s", new Object[]{url, devSn});
        ArrayHostGroup hg = HVSRestTransition.transitionArrayHostGroup((String)devSn, (Map)record);
        return hg;
    }

    public void addHostToHostGroup(String devSn, String hostGroupId, String hostId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostId)) {
            throw new LegoCheckedException(1073947393L);
        }
        List<ArrayHost> realHosts = this.queryHostsByHostGroup(devSn, hostGroupId);
        for (ArrayHost realHost : realHosts) {
            if (!hostId.equals(realHost.getHostId())) continue;
            return;
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/hostgroup/associate";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TYPE", Integer.toString(XveMOType.HOSTGROUP.getValue()));
        params.put("ID", hostGroupId);
        params.put("ASSOCIATEOBJTYPE", Integer.toString(XveMOType.HOST.getValue()));
        params.put("ASSOCIATEOBJID", hostId);
        logger.debug((Object)"start addHostToHostGroup, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, params});
        connection.post(url, params);
        logger.debug((Object)"end addHostToHostGroup, url: %s, devsn: %s", new Object[]{url, devSn});
    }

    public ArrayHost queryHost(String devSn, Initiator init) {
        logger.info((Object)"DevSn:%s", new Object[]{devSn});
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        if (init == null) {
            logger.error((Object)"Init is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (init.getIsFree() == null || init.getIsFree().booleanValue()) {
            logger.debug((Object)"Initiator is free.");
            return null;
        }
        String hostUuid = init.getHostUUID();
        logger.info((Object)"HostUuid:%s", new Object[]{hostUuid});
        String hostId = this.getId(hostUuid);
        if (VerifyUtil.isEmpty((String)hostId)) {
            throw new LegoCheckedException(1073947393L);
        }
        return this.queryHost(devSn, hostId);
    }

    private String getId(String uuid) {
        String[] splits;
        if (VerifyUtil.isEmpty((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        String prefix = "id=";
        for (String split : splits = uuid.split(", ")) {
            int index = split.lastIndexOf(prefix);
            if (index < 0) continue;
            return split.substring(prefix.length(), split.length() - 1);
        }
        return null;
    }

    public List<ArrayHostGroup> queryHostGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/hostgroup/associate");
        url.append("?TYPE=").append(XveMOType.HOSTGROUP.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(associateObjType.getValue());
        url.append("&ASSOCIATEOBJID=").append(associateObjId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"start queryHostGroups, url: %s, devsn: %s", new Object[]{url.toString(), devSn});
        List records = connection.getBatch(url.toString(), null);
        logger.debug((Object)"end queryHostGroups, url: %s, devsn: %s", new Object[]{url.toString(), devSn});
        ArrayList<ArrayHostGroup> hgs = new ArrayList<ArrayHostGroup>();
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                ArrayHostGroup hg = HVSRestTransition.transitionArrayHostGroup((String)devSn, (Map)record);
                hgs.add(hg);
            }
        }
        return hgs;
    }

    public List<ArrayHost> queryHostsByHostGroup(String devSn, String hostGroupId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/host/associate");
        url.append("?TYPE=").append(XveMOType.HOST.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(XveMOType.HOSTGROUP.getValue());
        url.append("&ASSOCIATEOBJID=").append(hostGroupId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"start queryHostsByHostGroup, url: %s, devsn: %s", new Object[]{url.toString(), devSn});
        List records = connection.getBatch(url.toString(), null);
        logger.debug((Object)"end queryHostsByHostGroup, url: %s, devsn: %s", new Object[]{url.toString(), devSn});
        ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
        for (Map record : records) {
            ArrayHost host = HVSRestTransition.transitionArrayHost((String)devSn, (Map)record);
            hosts.add(host);
        }
        return hosts;
    }

    public ArrayHost queryHost(String devSn, String hostId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)hostId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/host/" + hostId;
        logger.debug((Object)"start queryHost, url: %s, devsn: %s", new Object[]{url, devSn});
        Map record = connection.get(url, null);
        logger.debug((Object)"end queryHost, url: %s, devsn: %s", new Object[]{url, devSn});
        ArrayHost host = null;
        if (null != record) {
            host = HVSRestTransition.transitionArrayHost((String)devSn, (Map)record);
        }
        return host;
    }
}

