/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageSnapshotScheduleHandlerImpl;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class StorageHyperCDPScheduleHandlerImpl
extends StorageSnapshotScheduleHandlerImpl {
    @Override
    protected Map<String, String> constructCreateScheduleParameter(SnapshotSchedule schedule) {
        Long frequencyValue = schedule.getFrequencyValue();
        Integer snapshotMaxNum = schedule.getSnapshotMaxNum();
        if (null == frequencyValue || null == snapshotMaxNum) {
            logger.error((Object)("create snapshotSchedule error parameter,frequencyValue:" + frequencyValue + ",snapshotMaxNum:" + snapshotMaxNum));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", schedule.getName());
        paramMap.put("FREQUENCYVALUE", String.valueOf(frequencyValue));
        paramMap.put("FREQUENCYNUM", String.valueOf(snapshotMaxNum));
        paramMap.put("SCHEDULETYPE", String.valueOf(SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue()));
        Map props = schedule.getProps();
        if (NumberUtil.convertToInteger(props.get("DAILYSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "DAYHOURS");
            this.putValueToParam(paramMap, props, "DAYMINUTE");
            this.putValueToParam(paramMap, props, "DAILYSNAPSHOTNUM");
        }
        if (NumberUtil.convertToInteger(props.get("WEEKLYSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "WEEKLYDAYS");
            this.putValueToParam(paramMap, props, "STARTTIMEOFWEEK");
            this.putValueToParam(paramMap, props, "WEEKLYSNAPSHOTNUM");
        }
        if (NumberUtil.convertToInteger(props.get("MONTHSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "MONTHDAYS");
            this.putValueToParam(paramMap, props, "STARTTIMEOFMONTH");
            this.putValueToParam(paramMap, props, "MONTHSNAPSHOTNUM");
        }
        return paramMap;
    }

    @Override
    protected Map<String, String> constructModifyScheduleParameter(SnapshotSchedule schedule) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Long frequencyValue = schedule.getFrequencyValue();
        Integer snapshotMaxNum = schedule.getSnapshotMaxNum();
        if (null != frequencyValue && frequencyValue > 0L) {
            paramMap.put("FREQUENCYVALUE", String.valueOf(frequencyValue));
        }
        if (null != snapshotMaxNum && snapshotMaxNum > 0) {
            paramMap.put("FREQUENCYNUM", String.valueOf(snapshotMaxNum));
        }
        paramMap.put("SCHEDULETYPE", String.valueOf(schedule.getScheduleType()));
        Map props = schedule.getProps();
        if (NumberUtil.convertToInteger(props.get("DAILYSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "DAYHOURS");
            this.putValueToParam(paramMap, props, "DAYMINUTE");
            this.putValueToParam(paramMap, props, "DAILYSNAPSHOTNUM");
        } else if (NumberUtil.convertToInteger(props.get("DAILYSNAPSHOTNUM")) == 0) {
            paramMap.put("DAYHOURS", "[]");
            paramMap.put("DAYMINUTE", String.valueOf(0xFFFFFFFFL));
            paramMap.put("DAILYSNAPSHOTNUM", String.valueOf(0xFFFFFFFFL));
        }
        if (NumberUtil.convertToInteger(props.get("WEEKLYSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "WEEKLYDAYS");
            this.putValueToParam(paramMap, props, "STARTTIMEOFWEEK");
            this.putValueToParam(paramMap, props, "WEEKLYSNAPSHOTNUM");
        } else if (NumberUtil.convertToInteger(props.get("WEEKLYSNAPSHOTNUM")) == 0) {
            paramMap.put("WEEKLYDAYS", "[]");
            paramMap.put("STARTTIMEOFWEEK", "");
            paramMap.put("WEEKLYSNAPSHOTNUM", String.valueOf(0xFFFFFFFFL));
        }
        if (NumberUtil.convertToInteger(props.get("MONTHSNAPSHOTNUM")) > 0) {
            this.putValueToParam(paramMap, props, "MONTHDAYS");
            this.putValueToParam(paramMap, props, "STARTTIMEOFMONTH");
            this.putValueToParam(paramMap, props, "MONTHSNAPSHOTNUM");
        } else if (NumberUtil.convertToInteger(props.get("MONTHSNAPSHOTNUM")) == 0) {
            paramMap.put("MONTHDAYS", "[]");
            paramMap.put("STARTTIMEOFMONTH", "");
            paramMap.put("MONTHSNAPSHOTNUM", String.valueOf(0xFFFFFFFFL));
        }
        return paramMap;
    }

    private void putValueToParam(Map<String, String> paramMap, Map<String, String> props, String name) {
        if (props.get(name) != null) {
            paramMap.put(name, props.get(name));
        }
    }

    @Override
    public SnapshotSchedule query(String devSn, String scheduleId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId});
        logger.debug((Object)("query HyperCDPSchedule: devSn:" + devSn + ", scheduleId:" + scheduleId));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/snapshot_schedule/" + scheduleId + "?SCHEDULETYPE=" + SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue();
        try {
            logger.debug((Object)"start to HyperCDPSchedule.url=%s,devSn=%s", new Object[]{url, devSn});
            Map map = connection.get(url, null);
            if (!VerifyUtil.isEmpty((Map)map)) {
                SnapshotSchedule result = HVSRestTransitionExtend.transitionHyperCDPSchedule(map);
                result.setDevSn(devSn);
                logger.debug((Object)("query HyperCDPSchedule:" + result.toString()));
                return result;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query HyperCDPSchedule error.url=" + url + ", devSn=" + devSn), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query HyperCDPSchedule error.url=" + url + ", devSn=" + devSn), (Throwable)e);
            throw new LegoCheckedException("query HyperCDPSchedule failed.", (Throwable)e);
        }
    }

    public void addLunConsistencyGroupToHyperCDPSchedule(String devSn, String hyperCDPId, String lunConsistencyGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, hyperCDPId, lunConsistencyGroupId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", hyperCDPId);
        paramMap.put("ASSOCIATEOBJTYPE", String.valueOf(XveMOType.LUN_CONSISTENCY_GROUP.getValue()));
        paramMap.put("ASSOCIATEOBJID", lunConsistencyGroupId);
        paramMap.put("SCHEDULETYPE", String.valueOf(SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue()));
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/snapshot_schedule/create_associate";
        try {
            logger.debug((Object)"start to add lunConsistencyGroup.url=%s, devSn=%s, hyperCDPId=%s, lunConsistencyGroupId=%s", new Object[]{url, devSn, hyperCDPId, lunConsistencyGroupId});
            connection.post(url, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("add lun from lunConsistencyGroup failed.url=" + url + ", param=" + paramMap), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("add lun from lunConsistencyGroup failed.url=" + url + ", param=" + paramMap), (Throwable)e);
            throw new LegoCheckedException("add lun from HyperCDPSchedule failed.", (Throwable)e);
        }
    }

    public void removeLunCgFromHyperCDPSchedule(String devSn, String hyperCDPId, String lunConsistencyGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, hyperCDPId, lunConsistencyGroupId});
        String request = "?SCHEDULETYPE=" + SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue() + "&ID=" + hyperCDPId + "&ASSOCIATEOBJTYPE=" + XveMOType.LUN_CONSISTENCY_GROUP.getValue() + "&ASSOCIATEOBJID=" + lunConsistencyGroupId;
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/SNAPSHOT_SCHEDULE/REMOVE_ASSOCIATE" + request;
        try {
            connection.delete(url, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("remove lunConsistencyGroup from HyperCDP schedule failed.url=" + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("remove lunConsistencyGroup from HyperCDP schedule failed.url=" + url), (Throwable)e);
            throw new LegoCheckedException("remove lunConsistencyGroup from HyperCDP schedule  failed.", (Throwable)e);
        }
    }
}

