/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.sdk.model.CIFSShareAuthClient;
import com.huawei.ism.drm.storage.manager.sdk.model.NFSShareAuthClient;
import com.huawei.ism.drm.storage.manager.sdk.model.NFSShareAuthClientVO;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.sdk.constant.ShareType;
import com.huawei.ism.drm.storage.sdk.model.CIFSShare;
import com.huawei.ism.drm.storage.sdk.model.NFSShare;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HvsStorageFileSystemManager
implements IStorageFileSystemManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageFileSystemManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public List<NasFileSystem> queryFileSystems(String devSn, List<String> fsIds, String vstoreId) {
        ArrayList<NasFileSystem> list = new ArrayList<NasFileSystem>();
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        for (String fsId : fsIds) {
            String url = "/rest/${deviceID}/filesystem/" + fsId;
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Get fileSystems: url = %s", new Object[]{url});
            Map record = connection.get(url, null);
            logger.debug((Object)"Get fileSystems: url = %s, result = %s", new Object[]{url, record});
            NasFileSystem fileSystem = HVSRestTransition.transitionFileSystem((String)devSn, (Map)record);
            list.add(fileSystem);
        }
        return list;
    }

    public NFSShare createNFSShare(String devSn, String fsId, String sharePath, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("FSID", fsId);
        paramMap.put("SHAREPATH", sharePath);
        paramMap.put("DESCRIPTION", "");
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Post createNFSShare: url = %s, paramMap = %s", new Object[]{url, paramMap});
        Map result = connection.post(url, paramMap);
        logger.debug((Object)"createNFSShare: result = %s", new Object[]{result});
        String id = (String)result.get("ID");
        NFSShare nfsShare = new NFSShare();
        nfsShare.setDevSn(devSn);
        nfsShare.setFileSystemId(fsId);
        nfsShare.setSharePath(sharePath);
        nfsShare.setId(id);
        return nfsShare;
    }

    public OperationResult deleteNFSShare(String devSn, String nfsShareId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        try {
            String url = "/rest/${deviceID}/NFSHARE/" + nfsShareId;
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Delete NFSShare: url = %s", new Object[]{url});
            connection.delete(url, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("delete nfsshare failed. DevSn:" + devSn + ",Id:" + nfsShareId), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.delete.nfsshare.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.delete.nfsshare.operation", true, true, new String[]{nfsShareId});
    }

    public OperationResult createNFSShareAuthClient(String deviceSn, String nfsShareId, NFSShareAuthClientVO nfsShareAuthClientVO, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PARENTID", nfsShareId);
        paramMap.put("NAME", nfsShareAuthClientVO.getName());
        paramMap.put("ACCESSVAL", String.valueOf(nfsShareAuthClientVO.getAccessVal()));
        paramMap.put("SYNC", String.valueOf(nfsShareAuthClientVO.getSync()));
        paramMap.put("ALLSQUASH", String.valueOf(nfsShareAuthClientVO.getAllSquash()));
        paramMap.put("ROOTSQUASH", String.valueOf(nfsShareAuthClientVO.getRootSquash()));
        paramMap.put("TYPE", String.valueOf(XveMOType.NFS_SHARE_AUTH_CLIENT.getValue()));
        RestConnection connection = RestConnectionManager.getInstance().getConnection(deviceSn);
        try {
            String url = "/rest/${deviceID}/NFS_SHARE_AUTH_CLIENT";
            if (!VerifyUtil.isEmpty((String)vstoreId)) {
                url = url + "?vstoreId=" + vstoreId;
            }
            logger.debug((Object)"Post createNFSShareAuthClient: url = %s, params = %s", new Object[]{url, paramMap});
            connection.post(url, paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create nfsShareAuthClient failed. DevSn:" + deviceSn + ",Id:" + nfsShareId + ",Name:" + nfsShareAuthClientVO.getName()), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.create.nfsshareauthclient.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.create.nfsshareauthclient.operation", true, true, new String[0]);
    }

    public NFSShare getNFSShare(String devSn, String fsId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE?range=[0-100]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get nfsshare: url = %s", new Object[]{url});
        List results = connection.getBatch(url, null);
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"GetNFSShare result is null");
            return null;
        }
        NFSShare nfsShare = null;
        for (Map result : results) {
            String fsIdValue = (String)result.get("FSID");
            if (null == fsIdValue) {
                logger.error((Object)("get 'FSID' is null, devSn: " + devSn + ", fsId:" + fsId));
                continue;
            }
            if (!fsIdValue.equals(fsId)) continue;
            nfsShare = new NFSShare();
            nfsShare.setId((String)result.get("ID"));
            nfsShare.setSharePath((String)result.get("SHAREPATH"));
            nfsShare.setDevSn(devSn);
            nfsShare.setFileSystemId(fsId);
            nfsShare.setName((String)result.get("NAME"));
            break;
        }
        return nfsShare;
    }

    public List<NasFileSystem> queryFileSystems(String devSn, String vstoreId) {
        logger.debug((Object)("Enter batchQueryNasFileSystem, sn=" + devSn));
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/filesystem?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get fileSystems: url = %s", new Object[]{url});
        List records = connection.getBatch(url, null);
        ArrayList<NasFileSystem> list = new ArrayList<NasFileSystem>();
        for (Map record : records) {
            logger.debug((Object)record);
            NasFileSystem fileSystem = HVSRestTransition.transitionFileSystem((String)devSn, (Map)record);
            list.add(fileSystem);
        }
        logger.debug((Object)"Exit batchQueryNasFileSystem");
        return list;
    }

    public List<NFSShare> getNFSShareTemplates(String devSn, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        this.checkConnection(devSn, connection);
        List results = connection.getBatch(url, null);
        ArrayList<NFSShare> nfsShares = new ArrayList<NFSShare>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.info((Object)"Get NFSShare result is null.");
            return nfsShares;
        }
        for (Map result : results) {
            NFSShare nfsShare = new NFSShare();
            nfsShare.setId((String)result.get("ID"));
            nfsShare.setSharePath((String)result.get("SHAREPATH"));
            nfsShare.setDevSn(devSn);
            nfsShare.setFileSystemId((String)result.get("FSID"));
            nfsShare.setName((String)result.get("NAME"));
            nfsShares.add(nfsShare);
        }
        return nfsShares;
    }

    public int getShareAuthClientCount(String shareType, String devSn, String templateId, String vstoreId) {
        String url = "/rest/${deviceID}/NFS_SHARE_AUTH_CLIENT/count?vstoreId=${vstoreId}&filter=PARENTID::${parentId}";
        if (shareType.equals(ShareType.CIFS.getValue())) {
            url = "/rest/${deviceID}/CIFS_SHARE_AUTH_CLIENT/count?vstoreId=${vstoreId}&filter=PARENTID:${parentId}";
        }
        if (VerifyUtil.isEmpty((String)vstoreId) || VerifyUtil.isEmpty((String)templateId)) {
            logger.error((Object)"Params is invalid, vstoreId=%s, templateId=%s.", new Object[]{vstoreId, templateId});
            throw new LegoCheckedException(1073947393L);
        }
        url = url.replace("${vstoreId}", vstoreId).replace("${parentId}", templateId);
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        Map resMap = connection.get(url, null);
        if (VerifyUtil.isEmpty((Map)resMap)) {
            logger.info((Object)"Get NFSShare authClient count result is null.");
            return 0;
        }
        return Integer.parseInt(resMap.getOrDefault("COUNT", "0"));
    }

    public List<CIFSShare> getCIFSShareTemplates(String devSn, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/CIFSHARE?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&filter=subType::2&vstoreId=" + vstoreId;
        }
        this.checkConnection(devSn, connection);
        List results = connection.getBatch(url, null);
        ArrayList<CIFSShare> cifsShares = new ArrayList<CIFSShare>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.info((Object)"Get CIFSShare result is null.");
            return cifsShares;
        }
        for (Map result : results) {
            CIFSShare cifsShare = new CIFSShare();
            cifsShare.setId((String)result.get("ID"));
            cifsShare.setSharePath((String)result.get("SHAREPATH"));
            cifsShare.setDevSn(devSn);
            cifsShare.setFileSystemId((String)result.get("FSID"));
            cifsShare.setName((String)result.get("NAME"));
            cifsShares.add(cifsShare);
        }
        return cifsShares;
    }

    public OperationResult deleteFileSystem(String devSn, String fsId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vstoreId", vstoreId);
        try {
            String url = "/rest/${deviceID}/filesystem/${id}";
            url = url.replace("${id}", fsId);
            connection.delete(url, paramMap);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Delete fileSystem failed, devSn:%s, fsId:%s.", new Object[]{devSn, fsId});
            return new OperationResult("ism.drm.delete.fileSystem.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.delete.fileSystem.operation", true, true, new String[]{fsId});
    }

    public NFSShare getNFSShareByShareId(String devSn, String shareId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceID}/NFSSHARE/${id}";
        url = url.replace("${id}", shareId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        Map result = connection.get(url, null);
        NFSShare nfsShare = null;
        if (VerifyUtil.isEmpty((Map)result)) {
            logger.debug((Object)"GetCIFSShare result is null.");
            return nfsShare;
        }
        nfsShare = new NFSShare();
        nfsShare.setSharePath((String)result.get("SHAREPATH"));
        nfsShare.setId((String)result.get("ID"));
        nfsShare.setDescription((String)result.get("DESCRIPTION"));
        nfsShare.setFileSystemId((String)result.get("FSID"));
        nfsShare.setVstoreId((String)result.get("vstoreId"));
        nfsShare.setCharacterEncoding((String)result.get("CHARACTERENCODING"));
        nfsShare.setEnableShowSnapshot((String)result.get("ENABLESHOWSNAPSHOT"));
        nfsShare.setName((String)result.get("NAME"));
        nfsShare.setDevSn(devSn);
        return nfsShare;
    }

    public NFSShare createNFSShareByTemplate(String devSn, NFSShare nfsShareTemp, String fsId, String sharePath, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("FSID", fsId);
        paramMap.put("SHAREPATH", sharePath);
        paramMap.put("DESCRIPTION", nfsShareTemp.getDescription());
        paramMap.put("CHARACTERENCODING", nfsShareTemp.getCharacterEncoding());
        paramMap.put("ENABLESHOWSNAPSHOT", nfsShareTemp.getEnableShowSnapshot());
        paramMap.put("vstoreId", vstoreId);
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceID}/NFSHARE";
        String res = connection.postForObject(url, paramMap);
        JSONObject result = JSONObject.fromObject((Object)res);
        String id = result.getString("ID");
        NFSShare nfsShare = new NFSShare();
        nfsShare.setDevSn(devSn);
        nfsShare.setFileSystemId(fsId);
        nfsShare.setSharePath(sharePath);
        nfsShare.setId(id);
        return nfsShare;
    }

    public List<NFSShare> queryNFSSharesByFsId(String devSn, String fsId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        String url = "/rest/${deviceId}/NFSSHARE?vstoreId=${vstoreId}&range=[0-65536]&filter=FSID::${id}";
        url = url.replace("${id}", fsId).replace("${vstoreId}", vstoreId);
        List results = connection.getBatch(url, null);
        ArrayList<NFSShare> nfsShares = new ArrayList<NFSShare>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"GetNFSShare result is null.");
            return nfsShares;
        }
        for (Map result : results) {
            NFSShare nfsShare = new NFSShare();
            nfsShare.setId((String)result.get("ID"));
            nfsShare.setSharePath((String)result.get("SHAREPATH"));
            nfsShare.setDevSn(devSn);
            nfsShare.setFileSystemId(fsId);
            nfsShare.setName((String)result.get("NAME"));
            nfsShares.add(nfsShare);
        }
        return nfsShares;
    }

    public List<NFSShareAuthClient> queryNFSShareAuthClients(String devSn, String vstoreId, String templateId) {
        String url = "/rest/${deviceID}/NFS_SHARE_AUTH_CLIENT?vstoreId=${vstoreId}&range=[0-65536]&filter=PARENTID::${parentId}";
        url = url.replace("${vstoreId}", vstoreId).replace("${parentId}", templateId);
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        List results = connection.getBatch(url, null);
        ArrayList<NFSShareAuthClient> nfsShareAuthClients = new ArrayList<NFSShareAuthClient>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.info((Object)"Get CIFSShare result is null.");
            return nfsShareAuthClients;
        }
        return this.transitionNFSAuthClient(results);
    }

    private List<NFSShareAuthClient> transitionNFSAuthClient(List<Map<String, String>> results) {
        ArrayList<NFSShareAuthClient> nfsShareAuthClients = new ArrayList<NFSShareAuthClient>();
        for (Map<String, String> result : results) {
            NFSShareAuthClient nfsShareAuthClient = new NFSShareAuthClient();
            nfsShareAuthClient.setName(result.get("NAME"));
            nfsShareAuthClient.setAccessVal(result.get("ACCESSVAL"));
            nfsShareAuthClient.setAccessKrb5(result.get("ACCESSKRB5"));
            nfsShareAuthClient.setAccessKrb5i(result.get("ACCESSKRB5I"));
            nfsShareAuthClient.setAccessKrb5p(result.get("ACCESSKRB5P"));
            nfsShareAuthClient.setAllSquash(result.get("ALLSQUASH"));
            nfsShareAuthClient.setRootSquash(result.get("ROOTSQUASH"));
            nfsShareAuthClient.setSync(result.get("SYNC"));
            nfsShareAuthClient.setSecure(result.get("SECURE"));
            nfsShareAuthClient.setAnonymousId(Integer.parseInt(result.get("ANONYMOUSID")));
            nfsShareAuthClient.setId(result.get("ID"));
            nfsShareAuthClient.setParentId(result.get("PARENTID"));
            nfsShareAuthClient.setVstoreId(result.get("vstoreId"));
            nfsShareAuthClients.add(nfsShareAuthClient);
        }
        return nfsShareAuthClients;
    }

    public Optional<NFSShareAuthClient> createNFSShareAuthClientV2(String devSn, String nfsShareId, NFSShareAuthClient nfsShareAuthClient, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PARENTID", nfsShareId);
        paramMap.put("NAME", nfsShareAuthClient.getName());
        paramMap.put("ACCESSVAL", nfsShareAuthClient.getAccessVal());
        paramMap.put("ACCESSKRB5", nfsShareAuthClient.getAccessKrb5());
        paramMap.put("ACCESSKRB5I", nfsShareAuthClient.getAccessKrb5i());
        paramMap.put("ACCESSKRB5P", nfsShareAuthClient.getAccessKrb5p());
        paramMap.put("SYNC", nfsShareAuthClient.getSync());
        paramMap.put("ALLSQUASH", nfsShareAuthClient.getAllSquash());
        paramMap.put("ROOTSQUASH", nfsShareAuthClient.getRootSquash());
        paramMap.put("TYPE", String.valueOf(XveMOType.NFS_SHARE_AUTH_CLIENT.getValue()));
        paramMap.put("SECURE", nfsShareAuthClient.getSecure());
        paramMap.put("ANONYMOUSID", String.valueOf(nfsShareAuthClient.getAnonymousId()));
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceId}/NFS_SHARE_AUTH_CLIENT";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        try {
            Map res = connection.post(url, paramMap);
            NFSShareAuthClient shareAuthClient = new NFSShareAuthClient();
            shareAuthClient.setId((String)res.get("ID"));
            return Optional.of(shareAuthClient);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create nfsShareAuthClient failed. DevSn:%s, Id:%s, Name:%s, error:%s.", new Object[]{devSn, nfsShareId, nfsShareAuthClient.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
    }

    public OperationResult deleteShareAuthClient(String devSn, String shareType, String vstoreId, String authId) {
        String url = "/rest/${deviceId}/NFS_SHARE_AUTH_CLIENT/${id}";
        if (shareType.equals(ShareType.CIFS.getValue())) {
            url = "/rest/${deviceId}/CIFS_SHARE_AUTH_CLIENT/${id}";
        }
        url = url.replace("${id}", authId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        try {
            connection.delete(url, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"delete authclient failed. DevSn:%s, Id:%s, shareType:%s ,e:%s", new Object[]{devSn, authId, shareType, ExceptionUtil.getErrorMessage((Throwable)e)});
            return new OperationResult("ism.drm.delete.authclient.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.delete.authclient.operation", true, true, new String[]{authId});
    }

    public List<CIFSShareAuthClient> queryCIFSShareAuthClients(String devSn, String vstoreId, String templateId) {
        String url = "/rest/${deviceID}/CIFS_SHARE_AUTH_CLIENT?vstoreId=${vstoreId}&range=[0-65536]&filter=PARENTID::${parentId}";
        url = url.replace("${vstoreId}", vstoreId).replace("${parentId}", templateId);
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        List results = connection.getBatch(url, null);
        ArrayList<CIFSShareAuthClient> cifsShareAuthClients = new ArrayList<CIFSShareAuthClient>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.info((Object)"Get CIFSShare result is null.");
            return cifsShareAuthClients;
        }
        return this.transitionCIFSAuthClient(results);
    }

    private List<CIFSShareAuthClient> transitionCIFSAuthClient(List<Map<String, String>> results) {
        ArrayList<CIFSShareAuthClient> cifsShareAuthClients = new ArrayList<CIFSShareAuthClient>();
        for (Map<String, String> result : results) {
            CIFSShareAuthClient cifsShareAuthClient = new CIFSShareAuthClient();
            cifsShareAuthClient.setName(result.get("NAME"));
            cifsShareAuthClient.setId(result.get("ID"));
            cifsShareAuthClient.setVstoreId(result.get("vstoreId"));
            cifsShareAuthClient.setParentId(result.get("PARENTID"));
            cifsShareAuthClient.setShareName(result.get("shareName"));
            cifsShareAuthClient.setDomainType(result.get("DOMAINTYPE"));
            cifsShareAuthClient.setPermission(result.get("PERMISSION"));
            cifsShareAuthClient.setVstoreName(result.get("vstoreName"));
            cifsShareAuthClients.add(cifsShareAuthClient);
        }
        return cifsShareAuthClients;
    }

    public Optional<CIFSShareAuthClient> createCIFSShareAuthClient(String devSn, String cifsShareId, CIFSShareAuthClient cifsShareAuthClient, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PARENTID", cifsShareId);
        paramMap.put("NAME", cifsShareAuthClient.getName());
        paramMap.put("DOMAINTYPE", cifsShareAuthClient.getDomainType());
        paramMap.put("PERMISSION", cifsShareAuthClient.getPermission());
        paramMap.put("vstoreId", cifsShareAuthClient.getVstoreId());
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceId}/CIFS_SHARE_AUTH_CLIENT";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        try {
            Map res = connection.post(url, paramMap);
            CIFSShareAuthClient shareAuthClient = new CIFSShareAuthClient();
            shareAuthClient.setId((String)res.get("ID"));
            shareAuthClient.setName((String)res.get("NAME"));
            shareAuthClient.setParentId((String)res.get("PARENTID"));
            shareAuthClient.setDomainType((String)res.get("DOMAINTYPE"));
            shareAuthClient.setPermission((String)res.get("PERMISSION"));
            shareAuthClient.setVstoreId((String)res.get("vstoreId"));
            shareAuthClient.setVstoreName((String)res.get("vstoreName"));
            return Optional.of(shareAuthClient);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create CIFSShareAuthClient failed. DevSn:%s, Id:%s, Name:%s, error:%s.", new Object[]{devSn, cifsShareId, cifsShareAuthClient.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return Optional.empty();
        }
    }

    public CIFSShare getCIFSShareByShareId(String devSn, String shareId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceID}/CIFSHARE/${id}";
        url = url.replace("${id}", shareId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        Map result = connection.get(url, null);
        CIFSShare cifsShare = null;
        if (VerifyUtil.isEmpty((Map)result)) {
            logger.debug((Object)"GetCIFSShare result is null.");
            return cifsShare;
        }
        cifsShare = new CIFSShare();
        cifsShare.setId((String)result.get("ID"));
        cifsShare.setVstoreId((String)result.get("vstoreId"));
        cifsShare.setFileSystemId((String)result.get("FSID"));
        cifsShare.setAbeEnable((String)result.get("ABEENABLE"));
        cifsShare.setDescription((String)result.get("DESCRIPTION"));
        cifsShare.setEnableCa((String)result.get("ENABLECA"));
        cifsShare.setEnableNotify((String)result.get("ENABLENOTIFY"));
        cifsShare.setEnableShowPreviousVersions((String)result.get("ENABLESHOWPREVIOUSVERSIONS"));
        cifsShare.setEnableShowSnapshot((String)result.get("ENABLESHOWSNAPSHOT"));
        cifsShare.setName((String)result.get("NAME"));
        cifsShare.setOfflineFilemode((String)result.get("OFFLINEFILEMODE"));
        cifsShare.setSharePath((String)result.get("SHAREPATH"));
        cifsShare.setSmb3EncryptionEnable((String)result.get("smb3EncryptionEnable"));
        cifsShare.setUnencryptedAccess((String)result.get("unencryptedAccess"));
        cifsShare.setDevSn(devSn);
        return cifsShare;
    }

    public CIFSShare createCIFSShareByTemplate(String devSn, CIFSShare cifsShareTemp, String fsId, String shareName, String vstoreId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("FSID", fsId);
        paramMap.put("SHAREPATH", "/" + shareName + "/");
        paramMap.put("NAME", shareName);
        paramMap.put("ABEENABLE", cifsShareTemp.getAbeEnable());
        paramMap.put("DESCRIPTION", cifsShareTemp.getDescription());
        paramMap.put("ENABLECA", cifsShareTemp.getEnableCa());
        paramMap.put("ENABLENOTIFY", cifsShareTemp.getEnableNotify());
        paramMap.put("ENABLESHOWPREVIOUSVERSIONS", cifsShareTemp.getEnableShowPreviousVersions());
        paramMap.put("ENABLESHOWSNAPSHOT", cifsShareTemp.getEnableShowSnapshot());
        paramMap.put("OFFLINEFILEMODE", cifsShareTemp.getOfflineFilemode());
        paramMap.put("smb3EncryptionEnable", cifsShareTemp.getSmb3EncryptionEnable());
        paramMap.put("unencryptedAccess", cifsShareTemp.getUnencryptedAccess());
        String url = "/rest/${deviceID}/CIFSHARE";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        Map result = connection.post(url, paramMap);
        String id = (String)result.get("ID");
        CIFSShare cifsShare = new CIFSShare();
        cifsShare.setDevSn(devSn);
        cifsShare.setFileSystemId(fsId);
        cifsShare.setSharePath(shareName);
        cifsShare.setId(id);
        return cifsShare;
    }

    public OperationResult deleteCIFSShare(String devSn, String cifsShareId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceID}/CIFSHARE/${id}";
        url = url.replace("${id}", cifsShareId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        try {
            connection.delete(url, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("delete nfsshare failed. DevSn:" + devSn + ",Id:" + cifsShareId), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.delete.nfsshare.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return new OperationResult("ism.drm.delete.nfsshare.operation", true, true, new String[]{cifsShareId});
    }

    public List<CIFSShare> queryCIFSSharesByFsId(String devSn, String fsId, String vstoreId) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        this.checkConnection(devSn, connection);
        String url = "/rest/${deviceId}/CIFSHARE?vstoreId=${vstoreId}&range=[0-65536]&filter=FSID::${id}";
        url = url.replace("${id}", fsId).replace("${vstoreId}", vstoreId);
        List results = connection.getBatch(url, null);
        ArrayList<CIFSShare> cifsShares = new ArrayList<CIFSShare>();
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"GetCIFSShare result is null.");
            return cifsShares;
        }
        for (Map result : results) {
            CIFSShare cifsShare = new CIFSShare();
            cifsShare.setId((String)result.get("ID"));
            cifsShare.setSharePath((String)result.get("SHAREPATH"));
            cifsShare.setDevSn(devSn);
            cifsShare.setFileSystemId(fsId);
            cifsShare.setName((String)result.get("NAME"));
            cifsShares.add(cifsShare);
        }
        return cifsShares;
    }

    private void checkConnection(String devSn, RestConnection connection) {
        if (VerifyUtil.isEmpty((Object)connection)) {
            logger.error((Object)"Failed to get the connection. devSn=%s.", new Object[]{devSn});
            throw new LegoCheckedException(1073947393L);
        }
    }
}

