/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.ArraySnapshot;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HvsStorageSnapshotManager
extends BaseHvsStorageManager
implements IStorageSnapshotManager {
    private static final Log logger = LogFactory.getInstance(HvsStorageSnapshotManager.class);
    private IStorageSnapshotHandler handler;

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public OperationResult addSnapshotToHost(String deviceId, String srcResourceId, Snapshot arraySnapshot) {
        MappingView mappingView;
        try {
            mappingView = this.getMappingViewByLun(deviceId, srcResourceId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Getting mappingview by lun failed. SnapId:" + arraySnapshot.getSnapshotId() + ",SnapName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceId + ",LunId:" + srcResourceId), (Throwable)e, 90160758784001L);
            OperationResult operationResult = new OperationResult("ism.drm.add.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
            return operationResult;
        }
        return this.addSnapshotToMappingView(deviceId, mappingView, String.valueOf(arraySnapshot.getSnapshotId()));
    }

    public OperationResult removeSnapshotFromHost(String deviceId, Snapshot arraySnapshot, HostVO host) {
        logger.debug((Object)("deviceId:" + deviceId));
        return this.removeSnapshotMapping(deviceId, arraySnapshot);
    }

    public OperationResult removeSnapshotFromHostGroup(String deviceId, Snapshot arraySnapshot, HostGroupVO hostGroup) {
        logger.debug((Object)("deviceId:" + deviceId));
        return this.removeSnapshotMapping(deviceId, arraySnapshot);
    }

    public OperationResult removeSnapshotBySrcLUN(String deviceId, Snapshot arraySnapshot, String srcResourceId) {
        logger.debug((Object)("deviceId:" + deviceId));
        return this.removeSnapshotMapping(deviceId, arraySnapshot);
    }

    public Snapshot createSnapshot(String deviceSN, List<String> srcResourceIds, Snapshot snapshot) {
        if (VerifyUtil.isEmpty(srcResourceIds) || VerifyUtil.isEmpty((Object)snapshot)) {
            logger.error((Object)"Input srcResourceIds: %s", new Object[]{srcResourceIds});
            throw new LegoCheckedException(1073947393L);
        }
        XveMOType parentType = XveMOType.LUN;
        ManagedObject mo = snapshot.getParentMo();
        if (!VerifyUtil.isEmpty((Object)mo) && mo instanceof Snapshot) {
            parentType = XveMOType.SNAPSHOT;
        }
        return this.handler.createSnapshot(deviceSN, NumberUtil.convertToInteger((Object)srcResourceIds.get(0)).intValue(), snapshot.getSnapshotName(), snapshot.getDescription(), parentType);
    }

    public List<Snapshot> getSnapshot(String deviceSN, Snapshot snapshot) {
        logger.debug((Object)("deviceSN:" + deviceSN));
        ArraySnapshot s = this.handler.getArraySnapshot(deviceSN, snapshot.getId());
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        if (null != s) {
            result.add((Snapshot)s);
        }
        return result;
    }

    public OperationResult deleteSnapshot(String deviceSN, Snapshot arraySnapshot) {
        OperationResult operationResult;
        ArraySnapshot snapshot;
        try {
            snapshot = this.handler.getArraySnapshot(deviceSN, String.valueOf(arraySnapshot.getSnapshotId()));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Query snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            OperationResult operationResult2 = this.generateResult(arraySnapshot, e);
            return operationResult2;
        }
        if (null == snapshot) {
            OperationResult operationResult3 = new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
            return operationResult3;
        }
        if (null != snapshot.getIsMapped() && snapshot.getIsMapped().booleanValue()) {
            logger.error((Object)("snapshot is mapped, can not delete. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN));
            OperationResult operationResult4 = new OperationResult("ism.drm.delete.snapshot.operation", true, false, "1077937899", new String[0]);
            return operationResult4;
        }
        int runningState = NumberUtil.convertToInteger((Object)snapshot.getRunningState());
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (!isVasa && XveEuumDefineParent.RUNNING_STATUS_E.STOP.getValue() != runningState) {
            try {
                this.handler.stopSnapshot(deviceSN, String.valueOf(arraySnapshot.getSnapshotId()));
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Stopping snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
                OperationResult operationResult5 = this.generateResult(arraySnapshot, e);
                return operationResult5;
            }
        }
        try {
            this.handler.deleteSnapshot(deviceSN, String.valueOf(arraySnapshot.getSnapshotId()));
            operationResult = new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Deleting snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            operationResult = this.generateResult(arraySnapshot, e);
        }
        return operationResult;
    }

    public OperationResult deleteSnapshot(String deviceSN, List<Snapshot> snapshotList) {
        OperationResult operationResult;
        List<String> snapshotIds = snapshotList.stream().map(Snapshot::getSnapshotId).collect(Collectors.toList());
        try {
            this.handler.deleteSnapshot(deviceSN, snapshotIds);
            operationResult = new OperationResult("ism.drm.delete.snapshot.operation", true, true, snapshotIds.toArray(new String[snapshotIds.size()]));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"batch delete snapshot failed, snapshotIds:%s", new Object[]{snapshotIds});
            operationResult = new OperationResult("ism.drm.delete.snapshot.operation", true, false, snapshotIds.toArray(new String[snapshotIds.size()]));
        }
        return operationResult;
    }

    private OperationResult generateResult(Snapshot arraySnapshot, LegoCheckedException e) {
        OperationResult operationResult = 1077937880L == e.getErrorCode() ? new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()}) : new OperationResult("ism.drm.delete.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        return operationResult;
    }

    public OperationResult activeSnapshot(String deviceSN, List<String> snapshotIds) {
        OperationResult operationResult;
        try {
            this.handler.activeSnapshot(deviceSN, snapshotIds);
            operationResult = new OperationResult("ism.drm.active.snapshot.operation", true, true, new String[0]);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Active snapshot failed. SnapshotIds:" + snapshotIds.toString() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    public OperationResult activeSnapshotAfterStop(String deviceSN, List<String> snapshotIds) {
        logger.debug((Object)("deviceSN:" + deviceSN));
        OperationResult operationResult = this.reCreateSnapshot(deviceSN, snapshotIds);
        return operationResult;
    }

    public OperationResult reCreateSnapshot(String deviceSN, List<String> snapshotIds) {
        OperationResult operationResult;
        try {
            this.handler.reCreateSnapshot(deviceSN, snapshotIds);
            operationResult = new OperationResult("ism.drm.active.snapshot.operation", true, true, new String[0]);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Recreate snapshot failed. SnapshotIds:" + snapshotIds.toString() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    public OperationResult activeOrReCreateSnapshot(String devSn, Snapshot arraySnapshot) {
        ArraySnapshot snapshot;
        String snapshotId = String.valueOf(arraySnapshot.getSnapshotId());
        try {
            snapshot = this.handler.getArraySnapshot(devSn, snapshotId);
        }
        catch (LegoCheckedException e) {
            OperationResult operationResult = new OperationResult("ism.drm.active.recreate.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
            return operationResult;
        }
        if (null == snapshot) {
            logger.error((Object)("The snapshot does not exist. devSn:" + devSn + ", SnapId:" + snapshotId));
            OperationResult operationResult = new OperationResult("ism.drm.active.recreate.snapshot.operation", true, false, String.valueOf(1073947394L), new String[0]);
            return operationResult;
        }
        ArrayList<String> snapshotIds = new ArrayList<String>();
        snapshotIds.add(snapshotId);
        int runningState = NumberUtil.convertToInteger((Object)snapshot.getRunningState());
        OperationResult operationResult = XveEuumDefineParent.RUNNING_STATUS_E.ACTIVATED.getValue() == runningState ? this.reCreateSnapshot(devSn, snapshotIds) : this.activeSnapshot(devSn, snapshotIds);
        return operationResult;
    }

    public OperationResult disableSnapshot(String devSn, Snapshot arraySnapshot) {
        OperationResult operationResult;
        try {
            this.handler.stopSnapshot(devSn, String.valueOf(arraySnapshot.getSnapshotId()));
            operationResult = new OperationResult("ism.drm.stop.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Stopping snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + devSn), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.stop.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    public boolean isSnapshotExist(String deviceSN, Snapshot arraySnapshot) {
        boolean isSnapshotExist = true;
        try {
            ArraySnapshot snapshot = this.handler.getArraySnapshot(deviceSN, String.valueOf(arraySnapshot.getSnapshotId()));
            if (null == snapshot) {
                logger.error((Object)("Snapshot does not exist. DevSN:" + deviceSN + ",SnapshotId:" + arraySnapshot.getSnapshotId()), 90160758784001L);
                isSnapshotExist = false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Snapshot does not exist. DevSN:" + deviceSN + ",SnapshotId:" + arraySnapshot.getSnapshotId()), (Throwable)e, 90160758784001L);
            isSnapshotExist = false;
        }
        return isSnapshotExist;
    }

    public OperationResult addSnapshotToLunGroup(String devSn, Snapshot snapshot, String lunGroupId, Map<String, Object> cache) {
        OperationResult operationResult;
        logger.info((Object)("Enter add snapshot to lunGroup, devSn=" + devSn + ", lunGroupId:" + lunGroupId));
        this.checkParam(devSn, snapshot);
        if (VerifyUtil.isEmpty((String)lunGroupId)) {
            logger.error((Object)("lunGroupIdObj is null.lunGroupId:" + lunGroupId));
            throw new LegoCheckedException(1073947393L);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            mappingHandler.addObjectToLunGroup(devSn, lunGroupId, XveMOType.SNAPSHOT, snapshot.getId());
            operationResult = new OperationResult("ism.drm.add.snapshot.mapping.operation", true, true, new String[]{snapshot.getId()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("add snapshot to lunGroup failed. SnapshotId:" + snapshot.getId() + ",DeviceId:" + devSn + ",lunGroupId:" + lunGroupId), (Throwable)e);
            String[] successParameters = new String[]{snapshot.getId()};
            operationResult = this.generateOperationResult(e, "ism.drm.add.snapshot.mapping.operation", successParameters);
        }
        return operationResult;
    }

    private void checkParam(String devSn, Snapshot snapshot) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == snapshot) {
            logger.error((Object)"snapshot is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)snapshot.getId())) {
            logger.error((Object)"snapshot id is empty!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostVO hostVo) {
        MappingView mappingView;
        logger.info((Object)("Enter auto mapping snapshot to host, devSn=" + devSn + ", srcResourceId=" + srcResourceId), 90160758784000L);
        this.checkParam(devSn, snapshot);
        if (null == hostVo) {
            logger.error((Object)"input parameter hostVo is null");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            List<ArrayHost> hosts = this.prepareHosts(devSn, hostVo, true);
            ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
            mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.SNAPSHOT, snapshot.getId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Getting mappingview by host failed. SnapId:" + snapshot.getId() + ",SnapName:" + snapshot.getSnapshotName() + ",DeviceId:" + devSn + ",LunId:" + srcResourceId + ",hostUuid:" + hostVo.getId() + ",hostName:" + hostVo.getName()), (Throwable)e, 90160758784001L);
            OperationResult operationResult = new OperationResult("ism.drm.add.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
            return operationResult;
        }
        OperationResult operationResult = this.addSnapshotToMappingView(devSn, mappingView, snapshot.getId());
        logger.info((Object)"Exit auto mapping snapshot to host", 90160758784000L);
        return operationResult;
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostGroupVO hgVo) {
        MappingView mappingView;
        logger.info((Object)("Enter auto mapping snapshot to hostgroup, devSn=" + devSn + ", srcResourceId=" + srcResourceId), 90160758784000L);
        this.checkParam(devSn, snapshot);
        if (null == hgVo) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
            for (HostVO hostVo : hgVo.getHostVOs()) {
                List<ArrayHost> host = this.prepareHosts(devSn, hostVo, true);
                hosts.addAll(host);
            }
            ArrayHostGroup hostGroup = this.prepareHostGroup(devSn, hosts);
            mappingView = this.prepareMappingView(devSn, hostGroup.getHostGroupId(), XveMOType.SNAPSHOT, snapshot.getId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Getting mappingview by host failed. SnapId:" + snapshot.getId() + ",SnapName:" + snapshot.getSnapshotName() + ",DeviceId:" + devSn + ",LunId:" + srcResourceId + ",hostUuid:" + hgVo.getId() + ",hostName:" + hgVo.getName()), (Throwable)e, 90160758784001L);
            OperationResult operationResult = new OperationResult("ism.drm.add.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
            return operationResult;
        }
        OperationResult operationResult = this.addSnapshotToMappingView(devSn, mappingView, snapshot.getId());
        logger.info((Object)"Exit auto mapping snapshot to hostgroup", 90160758784000L);
        return operationResult;
    }

    private MappingView getMappingViewByLun(String deviceId, String lunId) {
        IStorageLunHandler lunHandler = this.getHandlerMgr().getLunHandler();
        if (null == lunHandler) {
            logger.error((Object)"lun handler is null.");
            throw new LegoCheckedException(1073947395L);
        }
        Lun lun = lunHandler.queryStorageLun(deviceId, lunId);
        if (null == lun) {
            throw new LegoCheckedException(1073948705L);
        }
        if (!lun.getMapped().booleanValue()) {
            String[] params = new String[]{lunId, deviceId};
            throw new LegoCheckedException(1073948751L, params);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        MappingView mappingView = mappingHandler.getMappingViewByLunId(deviceId, lunId);
        if (null == mappingView) {
            String[] params = new String[]{lunId, deviceId};
            throw new LegoCheckedException(1073948751L, params);
        }
        return mappingView;
    }

    private OperationResult addSnapshotToMappingView(String devSn, MappingView mappingView, String snapshotId) {
        OperationResult operationResult;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            XveLunGroup lunGroup = this.prepareLunGroup(devSn, mappingView);
            mappingHandler.addObjectToLunGroup(devSn, lunGroup.getLunGroupId(), XveMOType.SNAPSHOT, snapshotId);
            operationResult = new OperationResult("ism.drm.add.snapshot.mapping.operation", true, true, new String[]{snapshotId, mappingView.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Mapping snapshot failed. SnapshotId:" + snapshotId + ",DeviceId:" + devSn + ",mappingViewId:" + mappingView.getMappingViewId() + ",mappingViewName:" + mappingView.getName()), (Throwable)e, 90160758784001L);
            String[] successParameters = new String[]{snapshotId, mappingView.getName()};
            operationResult = this.generateOperationResult(e, "ism.drm.add.snapshot.mapping.operation", successParameters);
        }
        return operationResult;
    }

    public OperationResult restoreSnapshot(String deviceSN, Snapshot arraySnapshot, String restoreSpeed) {
        OperationResult operationResult;
        try {
            this.handler.restoreSnapshot(deviceSN, String.valueOf(arraySnapshot.getSnapshotId()), restoreSpeed, String.valueOf(arraySnapshot.getSrcResourceId()));
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("restore snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }

    private OperationResult removeSnapshotMapping(String deviceId, Snapshot arraySnapshot) {
        OperationResult result;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        try {
            String snapshotId = String.valueOf(arraySnapshot.getSnapshotId());
            logger.info((Object)("Begin query MappingView, devSn=" + deviceId + ", snapShotId=" + snapshotId), 90160758784000L);
            MappingView mappingView = mappingHandler.getMappingViewBySnapshotId(deviceId, snapshotId);
            logger.info((Object)"End query MappingView", 90160758784000L);
            if (null != mappingView) {
                logger.info((Object)("Begin remove snap mapping, devSn=" + deviceId + ", snapShotId=" + snapshotId + ", mappnigView=" + mappingView.getName()), 90160758784000L);
                mappingHandler.removeSnapshotFromMappingView(deviceId, mappingView, snapshotId);
                logger.info((Object)"End remove snap mapping", 90160758784000L);
            } else {
                logger.info((Object)("The associated mapping view does not exist. DevSN:" + deviceId + ",SnapId:" + snapshotId), 90160758784000L);
            }
            result = new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Remove snapshot mapping from host failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceId), (Throwable)e);
            if (1077951822L == e.getErrorCode() || 1077948996L == e.getErrorCode() || 1077937880L == e.getErrorCode()) {
                logger.info((Object)("The snapshot mapping is already deleted or snapshot does not exist. Id:" + arraySnapshot.getSnapshotId() + ",ErrorId:" + e.getErrorCode()));
                result = new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
            }
            result = new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return result;
    }

    public Snapshot copySnapshot(String devSn, String srcSnapshotId, String copyName) {
        return this.copySnapshot(devSn, srcSnapshotId, copyName, false);
    }

    public Snapshot copySnapshot(String sn, String srcSnapshotId, String copyName, boolean isHyperCDP) {
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty((String)srcSnapshotId) || VerifyUtil.isEmpty((String)copyName)) {
            logger.error((Object)"Error while coping snapshot, devSn=%s, id=%s, name=%s", new Object[]{sn, srcSnapshotId, copyName});
            throw new LegoCheckedException(1073947393L);
        }
        return this.getHandler().copySnapshot(sn, srcSnapshotId, copyName, isHyperCDP);
    }

    @Override
    public String prepareMapping(String devSn, HostVO hostVo) {
        return super.prepareMapping(devSn, hostVo);
    }

    @Override
    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        logger.debug((Object)("devSn:" + devSn));
        return super.prepareMapping(devSn, hostGroupVo);
    }

    @Override
    protected boolean isResourceMapped(String devSn, String resourceId) {
        logger.warn((Object)("not supported!devSn:" + devSn));
        throw new LegoUnsupportedOperationException("not supported.");
    }

    public IStorageSnapshotHandler getHandler() {
        return this.handler;
    }

    public void setHandler(IStorageSnapshotHandler handler) {
        this.handler = handler;
    }

    public List<Snapshot> querySnapshotByLun(String deviceSn, String lunId) {
        logger.debug((Object)("deviceSN:" + deviceSn));
        return this.handler.querySnapshotsByLun(deviceSn, lunId);
    }

    public List<Snapshot> queryHyperCdpSnapshotsByLun(String devSn, String lunId) {
        return this.handler.queryHyperCdpSnapshotsByLun(devSn, lunId);
    }

    public List<Snapshot> querySnapshots(String devSn, XveMOType associateObjType, String associateObjId) {
        return this.handler.querySnapshots(devSn, associateObjType, associateObjId);
    }

    public Snapshot renameSnapshot(String devSn, Snapshot snapshot, String newName) {
        return this.handler.renameSnapshot(devSn, snapshot, newName);
    }

    public Optional<Snapshot> querySpecificSnapshot(String devSn, String lunId, String snapshotId) {
        return this.handler.querySpecificSnapshot(devSn, lunId, snapshotId);
    }
}

