/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.replica.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.replica.builder.ArrayAsyncHyperMetroBuilder;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ArrayAsyncHyperMetroRingBuilder
extends ArrayAsyncHyperMetroBuilder {
    public int getType() {
        return 27;
    }

    public void buildReplica(ProtectGroup protectGroup) {
        super.buildReplica(protectGroup);
        DRRingUtil.updateProtectGroupUsedDRRingIdAfterReplicaBuild(protectGroup);
    }

    protected ProtectGroupReplica createProtectGroupReplica(ProtectGroup protectGroup, ExecutionContext context) {
        ProtectGroupReplica replica = super.createProtectGroupReplica(protectGroup, context);
        replica.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        return replica;
    }

    protected List<ReplicationPair> getPairsByResources(StorageResource srcRes, Integer resourceType) {
        if (!(srcRes instanceof Lun)) {
            return Collections.emptyList();
        }
        Lun lun = (Lun)Lun.class.cast(srcRes);
        Collection<Lun> lunList = DRRingUtil.convertWwnToLun(Arrays.asList(lun.getWwn()));
        Collection<Object> pairs = new HashSet<ReplicationPair>();
        for (Lun each : lunList) {
            List realtimePairs = super.getPairsByResources((StorageResource)each, resourceType);
            pairs.addAll(DRRingUtil.defaults(realtimePairs));
        }
        if (pairs.isEmpty()) {
            return Collections.emptyList();
        }
        pairs = DRRingUtil.backfillMissedDRRingIdAndIgnoreWeeds(pairs);
        Map<String, Collection<ReplicationPair>> secondaryStoragePairMap = ReplicationUtil.classifyReplicationPairBySecondaryStorageSN(pairs);
        pairs = DRRingUtil.getWhichNotContainStandby(secondaryStoragePairMap.values());
        return new ArrayList<ReplicationPair>(pairs);
    }
}

