/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.replica.calculator;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IExecuteReplicaCalculator;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;

public abstract class HyperDRRingReplicaCalculator
implements IExecuteReplicaCalculator {
    private static final Log logger = LogFactory.getInstance(HyperDRRingReplicaCalculator.class);

    protected abstract int getProtectGroupReplicaLimits();

    protected abstract void updateReplica(ProtectGroupReplica var1);

    public ProtectGroupReplica calculateExecutedReplica(ProtectGroup protectGroup, int protectLocation) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null");
            return null;
        }
        Collection<ProtectGroupReplica> replicas = CommonUtil.defaults(protectGroup.getReplicaList());
        if (replicas.size() != this.getProtectGroupReplicaLimits()) {
            logger.error((Object)("protect group replica size is not " + this.getProtectGroupReplicaLimits()));
            return null;
        }
        ProtectGroupReplica replica = DRRingUtil.getProtectGroupReplicaByLocation(replicas, protectLocation);
        if (replica == null) {
            logger.error((Object)("not found protect group replica for location " + protectLocation));
            return null;
        }
        if (protectLocation == DrmEnumDefine.ProtectLocation.C_C.getValue()) {
            this.updateReplica(replica);
        }
        return replica;
    }
}

