/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.replica.calculator;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.impl.BaseReplicaCalculator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IExecuteReplicaCalculator;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsyncReplicationFilter;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SyncAsyncRingReplicaCalculator
extends BaseReplicaCalculator
implements IExecuteReplicaCalculator {
    private static final Log logger = LogFactory.getInstance(SyncAsyncRingReplicaCalculator.class);
    private static final Set<PolicyTemplateType.PolicyTemplateE> SUPPORTED_TEMPLATES = new HashSet<PolicyTemplateType.PolicyTemplateE>(Arrays.asList(PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_SYNC_ASYNC, PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_SYNC_ASYNC));
    private ArrayAsyncReplicationFilter asyncReplicationFilter;

    public ArrayAsyncReplicationFilter getAsyncReplicationFilter() {
        return this.asyncReplicationFilter;
    }

    public void setAsyncReplicationFilter(ArrayAsyncReplicationFilter asyncReplicationFilter) {
        this.asyncReplicationFilter = asyncReplicationFilter;
    }

    public Set<PolicyTemplateType.PolicyTemplateE> getSupportPolicyTemplate() {
        return SUPPORTED_TEMPLATES;
    }

    public ProtectGroupReplica calculateExecutedReplica(ProtectGroup pg, int protectLocation) {
        ProtectGroupReplica syncReplic;
        if (pg == null) {
            logger.error((Object)"protectGroup is null");
            return null;
        }
        Collection<ProtectGroupReplica> replicas = CommonUtil.defaults(pg.getReplicaList());
        if (replicas.size() != 2) {
            logger.error((Object)"protect group replica size is not 2.");
            return null;
        }
        ProtectGroupReplica replica = DRRingUtil.getProtectGroupReplicaByLocation(replicas, protectLocation);
        if (replica == null) {
            logger.error((Object)("not found protect group replica for location " + protectLocation));
            return null;
        }
        if (protectLocation == DrmEnumDefine.ProtectLocation.C_C.getValue()) {
            syncReplic = DRRingUtil.getProtectGroupReplicaByLocation(replicas, DrmEnumDefine.ProtectLocation.A_B.getValue());
            if (syncReplic == null) {
                logger.error((Object)("not found protect group replica for location " + protectLocation));
                return null;
            }
        } else {
            return super.calculateExecutedReplica(pg, protectLocation);
        }
        this.updateReplica(syncReplic, replica);
        return replica;
    }

    private void updateReplica(ProtectGroupReplica syncReplic, ProtectGroupReplica asyncReplica) {
        HashMap<String, List<ReplicationPair>> ringIdAndPairs = new HashMap<String, List<ReplicationPair>>();
        Set<RemoteStorageReplica> remoteReplica = this.getAsyncRemoteStorageReplica(asyncReplica);
        HashSet syncMasterLun = new HashSet();
        HashSet syncSlaveLun = new HashSet();
        DRRingCommUtil.initAllLunByPgReplica((ProtectGroupReplica)syncReplic, syncMasterLun, syncSlaveLun);
        Collection masterPairs = this.asyncReplicationFilter.getPairsByLun(syncMasterLun);
        Collection slavePairs = this.asyncReplicationFilter.getPairsByLun(syncSlaveLun);
        this.classifyNormalPairsByRingId(ringIdAndPairs, masterPairs, slavePairs);
        this.checkPairsFromOneDevice(ringIdAndPairs);
        Map<String, Collection<RemoteStorageReplica>> replicaGroups = CommonUtil.classify(remoteReplica, "drRingId", String.class);
        if (ringIdAndPairs.size() == 0 || ringIdAndPairs.size() != replicaGroups.size()) {
            logger.error((Object)("pairs DRRing id not match replica DRRing id. ringIdAndPairs size: " + ringIdAndPairs.size() + "replicaGroups size: " + replicaGroups.size()));
            throw new LegoCheckedException(1073947393L);
        }
        HashSet<String> productStorageSn = new HashSet<String>();
        HashSet<String> drRingIds = new HashSet<String>();
        Set<Map.Entry<String, Collection<RemoteStorageReplica>>> entries = replicaGroups.entrySet();
        for (Map.Entry<String, Collection<RemoteStorageReplica>> entry : entries) {
            Collection<RemoteStorageReplica> remoteStorageReplicas = entry.getValue();
            List ringPairs = (List)ringIdAndPairs.get(entry.getKey());
            if (null == ringPairs) {
                logger.error((Object)("ringPairs is empty. ringId : " + entry.getKey()));
                throw new LegoCheckedException(1073947393L);
            }
            for (RemoteStorageReplica remoteStorageReplica : remoteStorageReplicas) {
                this.rebuildRemoteStorageReplica(remoteStorageReplica, ringPairs);
                productStorageSn.add(remoteStorageReplica.getSrcStorageProviderSN());
                drRingIds.add(remoteStorageReplica.getDrRingId());
            }
        }
        StringBuilder message = DRRingUtil.checkRunningStatusNotMatchedRings(productStorageSn, drRingIds, String.valueOf(2));
        if (message.length() != 0) {
            logger.error((Object)("running status of dr ring is not enabled. " + message));
            throw new LegoCheckedException(1073948257L);
        }
    }

    private void rebuildRemoteStorageReplica(RemoteStorageReplica remoteStorageReplica, List<ReplicationPair> ringPairs) {
        String recoverySn = remoteStorageReplica.getStorageProviderSN();
        String recoveryLunId = remoteStorageReplica.getStorageId();
        if (VerifyUtil.isEmpty((String)recoverySn) || VerifyUtil.isEmpty((String)recoveryLunId)) {
            logger.error((Object)"remoteStorageReplica recoverySn or recoveryLunId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ReplicationPair pair : ringPairs) {
            for (ReplicationTargetLun target : pair.getRepTgtLuns()) {
                if (!recoverySn.equals(target.getTgtDevSN()) || !recoveryLunId.equals(target.getTgtLunId())) continue;
                remoteStorageReplica.setSrcStorageId(pair.getSrcLunId());
                remoteStorageReplica.setSrcStorageProviderSN(pair.getSrcDevSN());
                remoteStorageReplica.setStorageId(target.getTgtLunId());
                remoteStorageReplica.setStorageProviderSN(target.getTgtDevSN());
                remoteStorageReplica.setReplicationPairId(pair.getReplicationId());
                remoteStorageReplica.setConsistentGroupId(pair.getConsistentGroupId());
            }
        }
    }

    private Set<RemoteStorageReplica> getAsyncRemoteStorageReplica(ProtectGroupReplica asyncReplica) {
        HashSet<RemoteStorageReplica> remoteStorageReplicas = new HashSet<RemoteStorageReplica>();
        for (ProtectObjectReplica poReplica : asyncReplica.getReplicas()) {
            for (RelicaStorageInfo relicaStorageInfo : poReplica.getStorageInfos()) {
                if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(relicaStorageInfo);
                remoteStorageReplicas.add(remoteStorageReplica);
            }
        }
        return remoteStorageReplicas;
    }

    private void checkPairsFromOneDevice(Map<String, List<ReplicationPair>> ringIdAndPairs) {
        for (List<ReplicationPair> pairs : ringIdAndPairs.values()) {
            String srcSn = null;
            for (ReplicationPair replicationPair : pairs) {
                if (null == srcSn) {
                    String pairSn = replicationPair.getSrcDevSN();
                    if (VerifyUtil.isEmpty((String)pairSn)) {
                        logger.error((Object)("pair sn or lunId is empty. pair id : " + replicationPair.getId()));
                        throw new LegoCheckedException(1073947393L);
                    }
                    srcSn = pairSn;
                    continue;
                }
                if (srcSn.equals(replicationPair.getSrcDevSN())) continue;
                logger.error((Object)"srcSn = %s, replicationPair.getSrcDevSn() = %s, pairId = %s", new Object[]{srcSn, replicationPair.getSrcDevSN(), replicationPair.getId()});
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private void classifyNormalPairsByRingId(Map<String, List<ReplicationPair>> ringIdAndPairs, Collection<ReplicationPair> masterPairs, Collection<ReplicationPair> slavePairs) {
        HashSet<ReplicationPair> pairs = new HashSet<ReplicationPair>();
        if (!VerifyUtil.isEmpty(masterPairs)) {
            pairs.addAll(masterPairs);
        }
        if (!VerifyUtil.isEmpty(slavePairs)) {
            pairs.addAll(slavePairs);
        }
        for (ReplicationPair replicationPair : pairs) {
            String status = ReplicationUtil.getReplicationRelationRunningStatus((ReplicationRelation)replicationPair);
            if (String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.STANDBY.getValue()).equals(status)) continue;
            if ((replicationPair.isNormal() || replicationPair.isSplit()) && replicationPair.getReplicationMode() == 2) {
                String drRingId = replicationPair.getDrRingId();
                if (VerifyUtil.isEmpty((String)drRingId) || "--".equals(drRingId)) continue;
                List<ReplicationPair> tempPairs = ringIdAndPairs.get(drRingId);
                if (VerifyUtil.isEmpty(tempPairs)) {
                    ArrayList<ReplicationPair> temp = new ArrayList<ReplicationPair>();
                    temp.add(replicationPair);
                    ringIdAndPairs.put(drRingId, temp);
                } else {
                    tempPairs.add(replicationPair);
                }
            }
            if (replicationPair.isNormal() || replicationPair.isSplit() || replicationPair.getReplicationMode() != 2) continue;
            String errorMsg = MessageFormatUtil.format((String)"ReplicationPair is abnormal, cannot be executed. ReplicationId:{0}[Source DeviceSn:{1}, LunId:{2}][ Target DeviceSn:{3}, LunId:{4}].", (Object[])new Object[]{replicationPair.getReplicationId(), replicationPair.getSrcDevSN(), replicationPair.getSrcLunId(), replicationPair.getTgtDevSN(), replicationPair.getTgtLunId()});
            logger.error((Object)errorMsg, 1073948462L);
            throw new LegoCheckedException(1073948462L, errorMsg);
        }
    }
}

