/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsyncReplicationFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ArrayAsyncReplicationDRRingFilter
extends ArrayAsyncReplicationFilter {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncReplicationDRRingFilter.class);

    protected void checkAllTargetLunBelongToSameDevice() {
        this.checkAllTargetLunBelongDevice();
        Collection values = this.getLunTgtDevs().values();
        if (VerifyUtil.isEmpty(values)) {
            logger.error((Object)"values is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        List targetDevSnList = values.stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (VerifyUtil.isEmpty((Collection)this.getTgtDevs())) {
            this.getTgtDevs().addAll(targetDevSnList);
        } else {
            for (String tgt : targetDevSnList) {
                if (this.getTgtDevs().contains(tgt)) continue;
                logger.error((Object)"Target devSn: %s, tgt not found=%s", new Object[]{targetDevSnList, tgt});
                throw new LegoCheckedException(1073948191L);
            }
        }
    }

    private void checkAllTargetLunBelongDevice() {
        HashSet tgtDevSet = new HashSet();
        for (String lunId : this.getLunTgtDevs().keySet()) {
            tgtDevSet.addAll((Collection)this.getLunTgtDevs().get(lunId));
        }
        if (tgtDevSet.size() > 2) {
            logger.error((Object)"The count of tgt devSns 3dc ring is over than 2: %s", new Object[]{tgtDevSet});
            throw new LegoCheckedException(1073948191L);
        }
    }
}

