/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.sdk.utils;

import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.PersistentVolumeClaimInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Optional;

public class KubeCommonUtils {
    private static final Log LOGGER = LogFactory.getInstance(KubeCommonUtils.class);
    private static final String PVC_STATUS_BOUND = "Bound";

    public static ProtectObject transHyperMetroProtectObject(String kubeSn, Domain domain, String backend, PersistentVolumeClaimInfo pvc) {
        ProtectObject po = new ProtectObject();
        po.setMoUuid(String.join((CharSequence)"/", pvc.getNameSpace(), pvc.getName()));
        po.setName(pvc.getName());
        po.setPoType(21);
        po.setProviderSN(kubeSn);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("storage_class", pvc.getStorageClassName());
        props.put("format", pvc.getFormat());
        props.put("PvcSize", pvc.getAmount());
        props.put("labels", pvc.getLabels());
        props.put("status", PVC_STATUS_BOUND);
        props.put("storageBackend", backend);
        props.put("namespace", pvc.getNameSpace());
        props.put("kube_persistent_volume", pvc.getVolumeName());
        props.put("domainName", domain.getName());
        props.put("hyperMetroDomainName", domain.getHyperMetroDomainName());
        props.put("domainType", domain.getType());
        props.put("poSubType", "HyperMetro");
        props.put("domainIp", domain.getIpAddress());
        po.setProps(props);
        return po;
    }

    public static void sleepAndCatchInterrupt(long time) {
        if (Thread.currentThread().isInterrupted()) {
            LOGGER.error((Object)"Current thread is interrupted, it's probably timed out.");
            throw new LegoCheckedException(1073947433L);
        }
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Current thread is interrupted, it's probably timed out.");
            throw new LegoCheckedException(1073947433L);
        }
    }

    public static KubeStorage getHyperMetroSystemVStoreBackend(ProtectGroup protectGroup) {
        String productionBackend = protectGroup.getProperty("kubeSourceStorage");
        if (VerifyUtil.isEmpty((String)productionBackend)) {
            LOGGER.error((Object)"Could not find kubeSourceStorage from protectGroup: %s.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return KubeCommonUtils.getStorageBackend(protectGroup.getPoProviderSN(), productionBackend);
    }

    public static KubeStorage getHyperMetroPvcBackend(ProtectGroup protectGroup) {
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        String pvBackend = protectObject.getProperty("storageBackend");
        if (VerifyUtil.isEmpty((String)pvBackend)) {
            LOGGER.error((Object)"Could not find storageBackend from protectObject: %s.", new Object[]{protectObject.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return KubeCommonUtils.getStorageBackend(protectGroup.getPoProviderSN(), pvBackend);
    }

    private static KubeStorage getStorageBackend(String kubeSn, String backend) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        Optional<KubeStorage> storageOpt = kubeHandler.getStorageBackendClaims(kubeSn, backend);
        if (!storageOpt.isPresent()) {
            LOGGER.error((Object)"The backend %s is not present.", new Object[]{backend});
            throw new LegoCheckedException(2117645L);
        }
        return storageOpt.get();
    }
}

