/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.sdk.utils;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.concurrent.TimeUnit;

public class RetryableTask {
    private static final Log LOGGER = LogFactory.getInstance(RetryableTask.class);

    public void run(int retryTimes, Runner runner) {
        this.run(retryTimes, 0L, null, false, runner);
    }

    public void run(int retryTimes, long duration, TimeUnit unit, boolean shouldCheckSuccess, Runner runner) {
        for (int i = 0; i < retryTimes; ++i) {
            if (runner.run()) {
                return;
            }
            if (duration < 0L || unit == null) continue;
            CommonUtil.sleep((long)duration, (TimeUnit)unit);
        }
        if (shouldCheckSuccess) {
            LOGGER.error((Object)"Retryable task execute failed after %s retries", new Object[]{String.valueOf(retryTimes)});
            throw new LegoCheckedException(0x300001L);
        }
    }

    public static interface Runner {
        public boolean run();
    }
}

