/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.sdk.service;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Set;

public interface SaveStorageResource {
    public static final Log LOGGER = LogFactory.getInstance(SaveStorageResource.class);

    default public void saveStorageResource(RecoveryProcessorContext context, Set<StorageResource> storageResources) {
        if (!storageResources.isEmpty()) {
            ArrayList<StorageResource> result = new ArrayList<StorageResource>();
            context.removeAttribute("Target_Storage");
            for (StorageResource resource : storageResources) {
                String resourceId = resource.getResourceId();
                String resourceResourceIdentifier = resource.getResourceIndentifier();
                if (VerifyUtil.isEmpty((String)resourceId) || VerifyUtil.isEmpty((String)resourceResourceIdentifier) || VerifyUtil.isEmpty((String)resource.getDevSn())) {
                    LOGGER.error((Object)"StorageResource's id[%s] or wwn[%s] or devSn[%s]is empty.", new Object[]{resourceId, resourceResourceIdentifier, resource.getDevSn()});
                    continue;
                }
                result.add(resource);
            }
            context.setAttribute("Target_Storage", result);
        }
    }
}

