/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.ism.util.Pair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class RecoveryExtendUtil {
    private static Log logger = LogFactory.getInstance(RecoveryUtil.class);

    public static Pair<String, String> getCurrentSrcAndTgtDeviceSN(String srcDeviceId, String tgtDeviceId, String replicationId, int relationType, RecoveryProcessorContext context) {
        boolean hasReversed = context.getHasReversedReplication();
        logger.debug((Object)"Start getCurrentSrcAndTgtDeviceSN, replicationId:%s, relationType:%s, hasReversed of context:%s.", new Object[]{replicationId, relationType, hasReversed});
        if (PolicyTemplateType.AIR_GAP_NETWORKING.contains(context.getProtectGroup().getTemplate().getType())) {
            String currentSrcDeviceSN = hasReversed ? tgtDeviceId : srcDeviceId;
            String currentTargetDeviceSN = hasReversed ? srcDeviceId : tgtDeviceId;
            return new Pair((Object)currentSrcDeviceSN, (Object)currentTargetDeviceSN);
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        boolean isVstoreReplicationPair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)relationType);
        if (isVstoreReplicationPair) {
            VstoreReplicationPair vstoreReplicationPair = recoveryService.queryVstoreReplicationPair(srcDeviceId, tgtDeviceId, replicationId);
            if (vstoreReplicationPair != null) {
                hasReversed = !srcDeviceId.equals(vstoreReplicationPair.getSrcDevSN());
            }
        } else {
            ReplicationRelation replication = recoveryService.queryReplication(srcDeviceId, tgtDeviceId, replicationId, ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)relationType));
            if (replication != null) {
                hasReversed = !srcDeviceId.equals(replication.getSrcDevSN());
            }
        }
        logger.debug((Object)"End getCurrentSrcAndTgtDeviceSN, hasReversed:%s.", new Object[]{hasReversed});
        return hasReversed ? new Pair((Object)tgtDeviceId, (Object)srcDeviceId) : new Pair((Object)srcDeviceId, (Object)tgtDeviceId);
    }
}

