/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.sdk.model;

import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.io.Serializable;

public class StoragePool
extends ManagedObject
implements Serializable,
HSObject {
    private static final long serialVersionUID = 2559890740533540865L;
    private static final int DEFAULT_THRESHOLD = 70;
    private String neSN;
    private Integer poolType;
    private Integer threshold;
    private Double totalCapacity;
    private String totalCapacityUnit;
    private Double usedCapacity;
    private String usedCapacityUnit;
    private String poolId;
    private String healthStatus;
    private String runningStatus;
    private Double thinPoolVisibleCapacity;
    private String thinPoolVisibleCapacityUnit;

    public Integer getPoolType() {
        return this.poolType;
    }

    public void setPoolType(Integer poolType) {
        this.poolType = poolType;
    }

    public Integer getThreshold() {
        if (this.threshold == null || this.threshold.equals(0)) {
            return 70;
        }
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public Double getTotalCapacity() {
        return this.totalCapacity;
    }

    public void setTotalCapacity(Double totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public Double getUsedCapacity() {
        return this.usedCapacity;
    }

    public void setUsedCapacity(Double usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public String getNeSN() {
        return this.neSN;
    }

    public void setNeSN(String devSn) {
        this.neSN = devSn;
    }

    public String getTotalCapacityUnit() {
        return this.totalCapacityUnit;
    }

    public void setTotalCapacityUnit(String totalCapacityUnit) {
        this.totalCapacityUnit = totalCapacityUnit;
    }

    public String getUsedCapacityUnit() {
        return this.usedCapacityUnit;
    }

    public void setUsedCapacityUnit(String usedCapacityUnit) {
        this.usedCapacityUnit = usedCapacityUnit;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public Double getThinPoolVisibleCapacity() {
        return this.thinPoolVisibleCapacity;
    }

    public void setThinPoolVisibleCapacity(Double thinPoolVisibleCapacity) {
        this.thinPoolVisibleCapacity = thinPoolVisibleCapacity;
    }

    public String getThinPoolVisibleCapacityUnit() {
        return this.thinPoolVisibleCapacityUnit;
    }

    public void setThinPoolVisibleCapacityUnit(String thinPoolVisibleCapacityUnit) {
        this.thinPoolVisibleCapacityUnit = thinPoolVisibleCapacityUnit;
    }

    public String getRunningStatus() {
        return this.runningStatus;
    }

    public void setRunningStatus(String runningStatus) {
        this.runningStatus = runningStatus;
    }

    public String getTotalCapacityAndUnit() {
        return UnitConvert.autoConvertToAdaptedValueAndUnit(this.totalCapacity, CapabilityUnitType.valueOf(this.totalCapacityUnit));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.healthStatus == null ? 0 : this.healthStatus.hashCode());
        result = 31 * result + (this.neSN == null ? 0 : this.neSN.hashCode());
        result = 31 * result + (this.poolId == null ? 0 : this.poolId.hashCode());
        result = 31 * result + (this.poolType == null ? 0 : this.poolType.hashCode());
        result = 31 * result + (this.runningStatus == null ? 0 : this.runningStatus.hashCode());
        result = 31 * result + (this.thinPoolVisibleCapacity == null ? 0 : this.thinPoolVisibleCapacity.hashCode());
        result = 31 * result + (this.thinPoolVisibleCapacityUnit == null ? 0 : this.thinPoolVisibleCapacityUnit.hashCode());
        result = 31 * result + (this.threshold == null ? 0 : this.threshold.hashCode());
        result = 31 * result + (this.totalCapacity == null ? 0 : this.totalCapacity.hashCode());
        result = 31 * result + (this.totalCapacityUnit == null ? 0 : this.totalCapacityUnit.hashCode());
        result = 31 * result + (this.usedCapacity == null ? 0 : this.usedCapacity.hashCode());
        result = 31 * result + (this.usedCapacityUnit == null ? 0 : this.usedCapacityUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoragePool other = (StoragePool)obj;
        return this.checkProp(other);
    }

    private boolean checkProp(StoragePool other) {
        if (this.healthStatus == null ? other.healthStatus != null : !this.healthStatus.equals(other.healthStatus)) {
            return false;
        }
        if (!this.checkProp1(other)) {
            return false;
        }
        return this.checkProp2(other);
    }

    private boolean checkProp1(StoragePool other) {
        if (this.runningStatus == null ? other.runningStatus != null : !this.runningStatus.equals(other.runningStatus)) {
            return false;
        }
        return this.checkProp6(other);
    }

    private boolean checkProp6(StoragePool other) {
        if (this.thinPoolVisibleCapacityUnit == null ? other.thinPoolVisibleCapacityUnit != null : !this.thinPoolVisibleCapacityUnit.equals(other.thinPoolVisibleCapacityUnit)) {
            return false;
        }
        return this.checkThinPoolVisibleCapacity(other);
    }

    private boolean checkThinPoolVisibleCapacity(StoragePool other) {
        return !(this.thinPoolVisibleCapacity == null ? other.thinPoolVisibleCapacity != null : !this.thinPoolVisibleCapacity.equals(other.thinPoolVisibleCapacity));
    }

    private boolean checkProp2(StoragePool other) {
        if (!this.checkCapacity(other)) {
            return false;
        }
        if (this.totalCapacityUnit == null ? other.totalCapacityUnit != null : !this.totalCapacityUnit.equals(other.totalCapacityUnit)) {
            return false;
        }
        return this.checkUsedCapacityUnit(other);
    }

    private boolean checkUsedCapacityUnit(StoragePool other) {
        return !(this.usedCapacityUnit == null ? other.usedCapacityUnit != null : !this.usedCapacityUnit.equals(other.usedCapacityUnit));
    }

    private boolean checkCapacity(StoragePool other) {
        if (this.usedCapacity == null ? other.usedCapacity != null : !this.usedCapacity.equals(other.usedCapacity)) {
            return false;
        }
        return this.checkTotalCapacity(other);
    }

    private boolean checkTotalCapacity(StoragePool other) {
        return !(this.totalCapacity == null ? other.totalCapacity != null : !this.totalCapacity.equals(other.totalCapacity));
    }
}

