/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.base.sdk.model;

import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.io.Serializable;

public class StorageResource
extends ManagedObject
implements Serializable,
HSObject {
    public static final int TWO = 2;
    private static final long serialVersionUID = -6073442867807864458L;
    private String devSn;
    private Integer resourceType;
    private String resourceId;
    private String parentResourceId;
    private String resourceIndentifier;
    private Long capacity;
    private Double totalCapacity;
    private Double usedCapacity;
    private String totalCapacityDisplayValue;
    private String totalCapacityUnit;
    private String usedCapacityUnit;
    private String healthStatus;
    private String runningStatus;
    private String usedCapRatioTooltip;
    private String freeCapRatioTooltip;
    private Double freeCapacity;

    public StorageResource() {
    }

    public StorageResource(String devSn, String resourceId, String resourceIndentifier) {
        this.devSn = devSn;
        this.resourceId = resourceId;
        this.resourceIndentifier = resourceIndentifier;
    }

    public Double getFreeCapacity() {
        return this.freeCapacity;
    }

    public void setFreeCapacity(Double freeCapacity) {
        this.freeCapacity = freeCapacity;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    public Double getTotalCapacity() {
        return this.totalCapacity;
    }

    public void setTotalCapacity(Double totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public String getTotalCapacityUnit() {
        return this.totalCapacityUnit;
    }

    public Double getUsedCapacity() {
        return this.usedCapacity;
    }

    public void setUsedCapacity(Double usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    public void setTotalCapacityUnit(String totalCapacityUnit) {
        this.totalCapacityUnit = totalCapacityUnit;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public String getTotalCapacityAndUnit() {
        return UnitConvert.autoConvertToAdaptedValueAndUnit(this.totalCapacity, CapabilityUnitType.valueOf(this.totalCapacityUnit));
    }

    public String getTotalCapacityDisplayValue() {
        this.totalCapacityDisplayValue = this.getTotalCapacityAndUnit();
        return this.totalCapacityDisplayValue;
    }

    public void setTotalCapacityDisplayValue(String totalCapacityDisplayValue) {
        this.totalCapacityDisplayValue = totalCapacityDisplayValue;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getRunningStatus() {
        return this.runningStatus;
    }

    public void setRunningStatus(String runningStatus) {
        this.runningStatus = runningStatus;
    }

    public String getUsedCapacityUnit() {
        return this.usedCapacityUnit;
    }

    public String getParentResourceId() {
        return this.parentResourceId;
    }

    public void setParentResourceId(String parentResourceId) {
        this.parentResourceId = parentResourceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.devSn == null ? 0 : this.devSn.hashCode());
        result = 31 * result + (this.healthStatus == null ? 0 : this.healthStatus.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        result = 31 * result + (this.runningStatus == null ? 0 : this.runningStatus.hashCode());
        result = 31 * result + (this.totalCapacity == null ? 0 : this.totalCapacity.hashCode());
        result = 31 * result + (this.totalCapacityDisplayValue == null ? 0 : this.totalCapacityDisplayValue.hashCode());
        result = 31 * result + (this.totalCapacityUnit == null ? 0 : this.totalCapacityUnit.hashCode());
        result = 31 * result + (this.usedCapacity == null ? 0 : this.usedCapacity.hashCode());
        result = 31 * result + (this.usedCapacityUnit == null ? 0 : this.usedCapacityUnit.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.resourceIndentifier == null ? 0 : this.resourceIndentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageResource other = (StorageResource)obj;
        return this.checkProp(other);
    }

    private boolean checkProp(StorageResource other) {
        if (!this.checkCapacity(other)) {
            return false;
        }
        if (!this.checkStatus(other)) {
            return false;
        }
        return this.checkUnit(other);
    }

    private boolean checkUnit(StorageResource other) {
        if (this.totalCapacityUnit == null ? other.totalCapacityUnit != null : !this.totalCapacityUnit.equals(other.totalCapacityUnit)) {
            return false;
        }
        return this.checkUsedCapacityUnit(other);
    }

    private boolean checkUsedCapacityUnit(StorageResource other) {
        return !(this.usedCapacityUnit == null ? other.usedCapacityUnit != null : !this.usedCapacityUnit.equals(other.usedCapacityUnit));
    }

    private boolean checkStatus(StorageResource other) {
        if (this.healthStatus == null ? other.healthStatus != null : !this.healthStatus.equals(other.healthStatus)) {
            return false;
        }
        return this.checkRunningStatus(other);
    }

    private boolean checkRunningStatus(StorageResource other) {
        return !(this.runningStatus == null ? other.runningStatus != null : !this.runningStatus.equals(other.runningStatus));
    }

    private boolean checkCapacity(StorageResource other) {
        if (this.totalCapacity == null ? other.totalCapacity != null : !this.totalCapacity.equals(other.totalCapacity)) {
            return false;
        }
        return this.checkCapa1(other);
    }

    private boolean checkCapa1(StorageResource other) {
        if (this.totalCapacityDisplayValue == null ? other.totalCapacityDisplayValue != null : !this.totalCapacityDisplayValue.equals(other.totalCapacityDisplayValue)) {
            return false;
        }
        return this.checkUsedCapacity(other);
    }

    private boolean checkUsedCapacity(StorageResource other) {
        return !(this.usedCapacity == null ? other.usedCapacity != null : !this.usedCapacity.equals(other.usedCapacity));
    }

    public void setUsedCapacityUnit(String usedCapacityUnit) {
        this.usedCapacityUnit = usedCapacityUnit;
    }

    public String getUsedCapRatioTooltip() {
        return this.usedCapRatioTooltip;
    }

    public void setUsedCapRatioTooltip(String usedCapRatioTooltip) {
        this.usedCapRatioTooltip = usedCapRatioTooltip;
    }

    public String getFreeCapRatioTooltip() {
        return this.freeCapRatioTooltip;
    }

    public void setFreeCapRatioTooltip(String freeCapRatioTooltip) {
        this.freeCapRatioTooltip = freeCapRatioTooltip;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceIndentifier() {
        return this.resourceIndentifier;
    }

    public void setResourceIndentifier(String resourceIndentifier) {
        this.resourceIndentifier = resourceIndentifier;
    }
}

