/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Locale;

public class CommonComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -1280093959161908336L;
    private static final Log logger = LogFactory.getInstance(CommonComparator.class);
    private static final String DOUBLE_LINE = "--";
    private String compareFiled;
    private boolean isAsc = true;
    private boolean isSortByMethodName = false;

    public CommonComparator(String compareFiled) {
        this.compareFiled = compareFiled;
    }

    public CommonComparator(String compareFiled, boolean isAsc) {
        this.compareFiled = compareFiled;
        this.isAsc = isAsc;
    }

    public CommonComparator(String compareFiled, boolean isAsc, boolean isSortByMethodName) {
        this.compareFiled = compareFiled;
        this.isAsc = isAsc;
        this.isSortByMethodName = isSortByMethodName;
    }

    @Override
    public int compare(Object leftParam, Object rightParam) {
        Comparable rightValue;
        Comparable leftValue;
        if (this.isSortByMethodName) {
            leftValue = this.getCompareValue(leftParam, this.compareFiled);
            rightValue = this.getCompareValue(rightParam, this.compareFiled);
        } else {
            leftValue = this.getCompareValue(leftParam);
            rightValue = this.getCompareValue(rightParam);
        }
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return this.isAsc ? -1 : 1;
        }
        if (rightValue == null) {
            return this.isAsc ? 1 : -1;
        }
        if (this.isAsc) {
            return leftValue.compareTo(rightValue);
        }
        return rightValue.compareTo(leftValue);
    }

    private Comparable getCompareValue(Object obj) {
        Field f = this.getField(obj.getClass(), this.compareFiled);
        if (null == f) {
            return "";
        }
        f.setAccessible(true);
        try {
            Object fieldValue = f.get(obj);
            if (null == fieldValue) {
                return null;
            }
            if (fieldValue instanceof Number) {
                Number number = (Number)fieldValue;
                return Double.valueOf(number.doubleValue());
            }
            return 'a' + fieldValue.toString();
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e, 90160766255361L);
            return "";
        }
    }

    private Comparable getCompareValue(Object obj, String compareFiledName) {
        Method[] methods;
        if (null == obj) {
            return null;
        }
        for (Method method : methods = obj.getClass().getMethods()) {
            if (method.getReturnType() == Void.TYPE || !method.getName().equals(this.getMethodNameByReturnType(compareFiledName.trim(), method.getReturnType() == Boolean.TYPE))) continue;
            try {
                Object result = method.invoke(obj, new Object[method.getParameterTypes().length]);
                if (null == result) {
                    return null;
                }
                if (result instanceof Number) {
                    Number number = (Number)result;
                    return Double.valueOf(number.doubleValue());
                }
                String resultStr = result.toString();
                return resultStr.equals(DOUBLE_LINE) ? null : resultStr;
            }
            catch (Exception e) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160766255361L);
            }
        }
        return null;
    }

    private String getMethodNameByReturnType(String compareFiledName, boolean isBoolean) {
        return (isBoolean ? "is" : "get") + compareFiledName.substring(0, 1).toUpperCase(Locale.getDefault()) + compareFiledName.substring(1);
    }

    private Field getField(Class clazz, String fieldName) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (clazz != Object.class) {
            return this.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }
}

