/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StringUtil {
    private static final String BLANK = "";
    private static final String DEFAULT_SPLIT = ":";

    public static String arrayToString(Object[] array) {
        return StringUtil.arrayToStrWithSplit(array, DEFAULT_SPLIT);
    }

    public static <T> String listToString(List<T> list, Function<T, String> func) {
        if (VerifyUtil.isEmpty(list)) {
            return BLANK;
        }
        List transferStrs = list.stream().map(func::apply).collect(Collectors.toList());
        return String.join((CharSequence)",", transferStrs);
    }

    public static String arrayToStrWithSplit(Object[] array, String split) {
        if (null == array || array.length == 0) {
            return BLANK;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : array) {
            sb.append(object);
            sb.append(split);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static String trim(String str) {
        if (null == str) {
            return null;
        }
        return str.trim();
    }

    public static String substr(String str, int len, String encodedMode) throws UnsupportedEncodingException {
        if (VerifyUtil.isEmpty(str)) {
            return null;
        }
        if (VerifyUtil.isEmpty(encodedMode)) {
            return str.substring(0, len);
        }
        byte[] newStr = new byte[len];
        byte[] encodedBytes = str.getBytes(encodedMode);
        System.arraycopy(encodedBytes, 0, newStr, 0, len);
        String result = new String(newStr, encodedMode);
        int resLen = result.length();
        if (str.substring(0, resLen).getBytes(encodedMode).length > len) {
            result = str.substring(0, resLen - 1);
        }
        return result;
    }

    public static String format(String template, Object ... args) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (args != null) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                data.put(String.valueOf(i), args[i]);
            }
        }
        return StringUtil.format(template, data);
    }

    public static String format(String template, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            template = template.replaceAll("\\$\\{" + entry.getKey() + "\\}", Optional.ofNullable(entry.getValue()).map(Object::toString).orElse(BLANK));
        }
        return template;
    }

    public static String[] getErrorCodeParams(String[] params) {
        if (VerifyUtil.isEmpty(params)) {
            return new String[0];
        }
        String[] res = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            res[i] = "i18n:\"" + param + "\"";
        }
        return res;
    }
}

