/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.unistor.sdk.model;

import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.unit.MathUtil;

public class NasStoragePool
extends StoragePool {
    private static final long serialVersionUID = 7625774837457770711L;
    private Integer fileSystemNum;
    private Integer dataDiskNum;
    private Double freeCapacity = 0.0;
    private String freeCapacityUnit;
    private Double totalFileSystemCapacity;
    private String totalFileSystemCapacityUnit;
    private Double sharedFileSystemCapacity = 0.0;
    private String sharedFileSystemCapacityUnit;
    private Double unShareFileSystemCapacity = 0.0;
    private String unShareFileSystemCapacityUnit;
    private String sharedRatioTolltip;
    private String unSharedRatioTolltip;
    private String freeRatioTolltip;

    public String getSharedRatioTolltip() {
        return this.sharedRatioTolltip;
    }

    public void setSharedRatioTolltip(String sharedRatioTolltip) {
        this.sharedRatioTolltip = sharedRatioTolltip;
    }

    public String getUnSharedRatioTolltip() {
        return this.unSharedRatioTolltip;
    }

    public void setUnSharedRatioTolltip(String unSharedRatioTolltip) {
        this.unSharedRatioTolltip = unSharedRatioTolltip;
    }

    public String getFreeRatioTolltip() {
        return this.freeRatioTolltip;
    }

    public void setFreeRatioTolltip(String freeRatioTolltip) {
        this.freeRatioTolltip = freeRatioTolltip;
    }

    public Double getFreeCapRatio() {
        Double total = this.getNasStoragePoolTotal();
        if (null != this.freeCapacity) {
            total = total + this.freeCapacity;
        }
        return MathUtil.downScaleToDouble(NumberUtil.getSpaceUsageRatio(this.freeCapacity, total), new int[0]);
    }

    public Double getShareCapRatio() {
        Double total = this.getNasStoragePoolTotal();
        if (null != this.freeCapacity) {
            total = total + this.freeCapacity;
        }
        return MathUtil.downScaleToDouble(NumberUtil.getSpaceUsageRatio(this.sharedFileSystemCapacity, total), new int[0]);
    }

    public Double getUnShareCapRatio() {
        Double total = this.getNasStoragePoolTotal();
        if (null != this.freeCapacity) {
            total = total + this.freeCapacity;
        }
        return MathUtil.downScaleToDouble(NumberUtil.getSpaceUsageRatio(this.unShareFileSystemCapacity, total), new int[0]);
    }

    public Integer getFileSystemNum() {
        return this.fileSystemNum;
    }

    public void setFileSystemNum(Integer fileSystemNum) {
        this.fileSystemNum = fileSystemNum;
    }

    public Integer getDataDiskNum() {
        return this.dataDiskNum;
    }

    public void setDataDiskNum(Integer dataDiskNum) {
        this.dataDiskNum = dataDiskNum;
    }

    public Double getFreeCapacity() {
        return this.freeCapacity;
    }

    public void setFreeCapacity(Double freeCapacity) {
        this.freeCapacity = freeCapacity;
    }

    public String getFreeCapacityUnit() {
        return this.freeCapacityUnit;
    }

    public void setFreeCapacityUnit(String freeCapacityUnit) {
        this.freeCapacityUnit = freeCapacityUnit;
    }

    public Double getTotalFileSystemCapacity() {
        return this.totalFileSystemCapacity;
    }

    public void setTotalFileSystemCapacity(Double totalFileSystemCapacity) {
        this.totalFileSystemCapacity = totalFileSystemCapacity;
    }

    public String getTotalFileSystemCapacityUnit() {
        return this.totalFileSystemCapacityUnit;
    }

    public void setTotalFileSystemCapacityUnit(String totalFileSystemCapacityUnit) {
        this.totalFileSystemCapacityUnit = totalFileSystemCapacityUnit;
    }

    public Double getSharedFileSystemCapacity() {
        return this.sharedFileSystemCapacity;
    }

    public void setSharedFileSystemCapacity(Double sharedFileSystemCapacity) {
        this.sharedFileSystemCapacity = sharedFileSystemCapacity;
    }

    public String getSharedFileSystemCapacityUnit() {
        return this.sharedFileSystemCapacityUnit;
    }

    public void setSharedFileSystemCapacityUnit(String sharedFileSystemCapacityUnit) {
        this.sharedFileSystemCapacityUnit = sharedFileSystemCapacityUnit;
    }

    public Double getUnShareFileSystemCapacity() {
        return this.unShareFileSystemCapacity;
    }

    public void setUnShareFileSystemCapacity(Double unShareFileSystemCapacity) {
        this.unShareFileSystemCapacity = unShareFileSystemCapacity;
    }

    public String getUnShareFileSystemCapacityUnit() {
        return this.unShareFileSystemCapacityUnit;
    }

    public void setUnShareFileSystemCapacityUnit(String unShareFileSystemCapacityUnit) {
        this.unShareFileSystemCapacityUnit = unShareFileSystemCapacityUnit;
    }

    public Double getNasStoragePoolTotal() {
        return (null == this.sharedFileSystemCapacity ? 0.0 : this.sharedFileSystemCapacity) + (null == this.unShareFileSystemCapacity ? 0.0 : this.unShareFileSystemCapacity);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataDiskNum == null ? 0 : this.dataDiskNum.hashCode());
        result = 31 * result + (this.fileSystemNum == null ? 0 : this.fileSystemNum.hashCode());
        result = 31 * result + (this.freeCapacity == null ? 0 : this.freeCapacity.hashCode());
        result = 31 * result + (this.freeCapacityUnit == null ? 0 : this.freeCapacityUnit.hashCode());
        result = 31 * result + (this.sharedFileSystemCapacity == null ? 0 : this.sharedFileSystemCapacity.hashCode());
        result = 31 * result + (this.sharedFileSystemCapacityUnit == null ? 0 : this.sharedFileSystemCapacityUnit.hashCode());
        result = 31 * result + (this.totalFileSystemCapacity == null ? 0 : this.totalFileSystemCapacity.hashCode());
        result = 31 * result + (this.totalFileSystemCapacityUnit == null ? 0 : this.totalFileSystemCapacityUnit.hashCode());
        result = 31 * result + (this.unShareFileSystemCapacity == null ? 0 : this.unShareFileSystemCapacity.hashCode());
        result = 31 * result + (this.unShareFileSystemCapacityUnit == null ? 0 : this.unShareFileSystemCapacityUnit.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NasStoragePool other = (NasStoragePool)obj;
        return this.checkProp(other);
    }

    private boolean checkProp(NasStoragePool other) {
        if (!this.checkCap(other)) {
            return false;
        }
        if (!this.checkDataDiskNum(other)) {
            return false;
        }
        if (!this.checkfileSystemNum(other)) {
            return false;
        }
        return this.checkUnit(other);
    }

    private boolean checkDataDiskNum(NasStoragePool other) {
        return !(this.dataDiskNum == null ? other.dataDiskNum != null : !this.dataDiskNum.equals(other.dataDiskNum));
    }

    private boolean checkfileSystemNum(NasStoragePool other) {
        return !(this.fileSystemNum == null ? other.fileSystemNum != null : !this.fileSystemNum.equals(other.fileSystemNum));
    }

    private boolean checkUnit(NasStoragePool other) {
        if (this.freeCapacityUnit == null ? other.freeCapacityUnit != null : !this.freeCapacityUnit.equals(other.freeCapacityUnit)) {
            return false;
        }
        if (!this.checkSharedFileSystemCapacityUnit(other)) {
            return false;
        }
        if (!this.checktTotalFileSystemCapacityUnit(other)) {
            return false;
        }
        return this.checkUnShareFileSystemCapacityUnit(other);
    }

    private boolean checkSharedFileSystemCapacityUnit(NasStoragePool other) {
        return !(this.sharedFileSystemCapacityUnit == null ? other.sharedFileSystemCapacityUnit != null : !this.sharedFileSystemCapacityUnit.equals(other.sharedFileSystemCapacityUnit));
    }

    private boolean checktTotalFileSystemCapacityUnit(NasStoragePool other) {
        return !(this.totalFileSystemCapacityUnit == null ? other.totalFileSystemCapacityUnit != null : !this.totalFileSystemCapacityUnit.equals(other.totalFileSystemCapacityUnit));
    }

    private boolean checkUnShareFileSystemCapacityUnit(NasStoragePool other) {
        return !(this.unShareFileSystemCapacityUnit == null ? other.unShareFileSystemCapacityUnit != null : !this.unShareFileSystemCapacityUnit.equals(other.unShareFileSystemCapacityUnit));
    }

    private boolean checkCap(NasStoragePool other) {
        if (this.freeCapacity == null ? other.freeCapacity != null : !this.freeCapacity.equals(other.freeCapacity)) {
            return false;
        }
        if (!this.checkSharedFileSystemCapacity(other)) {
            return false;
        }
        if (!this.checkTotalFileSystemCapacity(other)) {
            return false;
        }
        return this.checkUnShareFileSystemCapacity(other);
    }

    private boolean checkTotalFileSystemCapacity(NasStoragePool other) {
        return !(this.totalFileSystemCapacity == null ? other.totalFileSystemCapacity != null : !this.totalFileSystemCapacity.equals(other.totalFileSystemCapacity));
    }

    private boolean checkSharedFileSystemCapacity(NasStoragePool other) {
        return !(this.sharedFileSystemCapacity == null ? other.sharedFileSystemCapacity != null : !this.sharedFileSystemCapacity.equals(other.sharedFileSystemCapacity));
    }

    private boolean checkUnShareFileSystemCapacity(NasStoragePool other) {
        return !(this.unShareFileSystemCapacity == null ? other.unShareFileSystemCapacity != null : !this.unShareFileSystemCapacity.equals(other.unShareFileSystemCapacity));
    }
}

