/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.app.sdk.model.ClusterInfo;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClusterAction
extends AgentRestAction {
    public ClusterAction(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
    }

    public boolean isActiveNode(String clusterType, String resourceGroup) {
        HashMap<String, String> uriVariMap = new HashMap<String, String>();
        uriVariMap.put("clusterType", clusterType);
        uriVariMap.put("resourceGroup", resourceGroup);
        String url = "/agent/cluster/activehost?resourceGroup={resourceGroup}&clusterType={clusterType}";
        String result = this.get(url, uriVariMap);
        if (this.isResultEmpty(result)) {
            return false;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        Integer isActive = JsonUtil.getInteger((JSONObject)jsonObject, (String)"isActive", (Integer[])new Integer[]{0});
        return isActive == 1;
    }

    public List<ClusterInfo> queryClusterServices(Map<String, String> params) {
        this.buildHeaders(params);
        String instanceName = params.get("INSTANCENAME");
        String databaseName = params.get("DATABASES");
        String clusterType = params.get("CLUSTER_TYPE");
        String dbType = params.get("DB_TYPE");
        HashMap<String, String> uriVariMap = new HashMap<String, String>();
        uriVariMap.put("instName", instanceName);
        uriVariMap.put("dbName", databaseName);
        uriVariMap.put("clusterType", clusterType);
        uriVariMap.put("appType", dbType);
        String url = "/agent/cluster/services?instName={instName}&dbName={dbName}&clusterType={clusterType}&appType={appType}";
        String result = this.get(url, uriVariMap);
        if (this.isResultEmpty(result)) {
            return Collections.emptyList();
        }
        HashMap<String, ClusterInfo> clusterMap = new HashMap<String, ClusterInfo>();
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        for (Object obj : myJsonArray) {
            HashSet<String> resourceGroups;
            JSONObject jsonObject = JSONObject.fromObject(obj);
            String clusterName = JsonUtil.getString((JSONObject)jsonObject, (String)"cluserName", (String[])new String[]{""});
            String vgActiveMode = JsonUtil.getString((JSONObject)jsonObject, (String)"vgActiveMode", (String[])new String[]{"--"});
            ClusterInfo clusterInfo = (ClusterInfo)clusterMap.get(clusterName);
            if (null == clusterInfo) {
                clusterInfo = new ClusterInfo();
                clusterInfo.setCluserName(clusterName);
                clusterInfo.setClusterType(NumberUtil.parseInteger((Object)clusterType));
                clusterInfo.setVgActiveMode(vgActiveMode);
                clusterMap.put(clusterName, clusterInfo);
            }
            if (null == (resourceGroups = clusterInfo.getResourceGroups())) {
                resourceGroups = new HashSet<String>();
                clusterInfo.setResourceGroups(resourceGroups);
            }
            String resourceGroup = JsonUtil.getString((JSONObject)jsonObject, (String)"resourceGroup", (String[])new String[]{""});
            resourceGroups.add(resourceGroup);
            String resourceName = JsonUtil.getString((JSONObject)jsonObject, (String)"resourceName", (String[])new String[]{"--"});
            clusterInfo.setResourceNames(resourceName);
            String networkName = JsonUtil.getString((JSONObject)jsonObject, (String)"networkName", (String[])new String[]{"--"});
            clusterInfo.setNetworkName(networkName);
            String deviceGroup = JsonUtil.getString((JSONObject)jsonObject, (String)"deviceGroup", (String[])new String[]{"--"});
            clusterInfo.setDeviceGroup(deviceGroup);
        }
        return new ArrayList<ClusterInfo>(clusterMap.values());
    }

    public void startCluster(String clusterType, String resourceGroup) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"clusterType", (Object)clusterType);
        jsonObject.put((Object)"resourceGroup", (Object)resourceGroup);
        this.put("/agent/cluster/action/start", jsonObject.toString(), Collections.emptyMap());
    }

    public void startResourceGroup(Map<String, String> params) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"clusterType", (Object)params.get("clusterType"));
        jsonObject.put((Object)"resourceGroup", (Object)params.get("resourceGroup"));
        jsonObject.put((Object)"appType", (Object)params.get("appType"));
        jsonObject.put((Object)"resourceName", (Object)(params.get("resourceName") == null ? "" : params.get("resourceName")));
        jsonObject.put((Object)"deviceGroup", (Object)(params.get("deviceGroup") == null ? "" : params.get("deviceGroup")));
        this.put("/agent/cluster/resourceGroup/action/start", jsonObject.toString(), Collections.emptyMap());
    }

    public void stopResourceGroup(Map<String, String> params) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"clusterType", (Object)params.get("clusterType"));
        jsonObject.put((Object)"resourceGroup", (Object)params.get("resourceGroup"));
        jsonObject.put((Object)"appType", (Object)params.get("appType"));
        jsonObject.put((Object)"resourceName", (Object)(params.get("resourceName") == null ? "" : params.get("resourceName")));
        jsonObject.put((Object)"deviceGroup", (Object)(params.get("deviceGroup") == null ? "" : params.get("deviceGroup")));
        this.put("/agent/cluster/resourceGroup/action/stop", jsonObject.toString(), Collections.emptyMap());
    }
}

