/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.agent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.app.sdk.model.VolumeGroup;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.host.agent.action.AgentRestAction;
import com.huawei.ism.host.sdk.model.HostFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DeviceAction
extends AgentRestAction {
    private static Log logger = LogFactory.getInstance(DeviceAction.class);
    private static String emptyString = "";

    public DeviceAction(NeMgrProtocolExtend extend, String devSn) {
        super(extend, devSn);
    }

    public List<HostFileSystem> queryFileSystems() {
        String result = this.get("/agent/device/filesystems", Collections.emptyMap());
        if (this.isResultEmpty(result)) {
            return Collections.emptyList();
        }
        JSONArray myJsonArray = JSONArray.fromObject((Object)result);
        ArrayList<HostFileSystem> hostFsList = new ArrayList<HostFileSystem>();
        for (Object obj : myJsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(obj);
            HostFileSystem fileSystem = new HostFileSystem();
            String fsType = JsonUtil.getString((JSONObject)jsonObject, (String)"fileSystemType", (String[])new String[]{""});
            String deviceName = JsonUtil.getString((JSONObject)jsonObject, (String)"deviceName", (String[])new String[]{""});
            String mountPoint = JsonUtil.getString((JSONObject)jsonObject, (String)"mountPoint", (String[])new String[]{""});
            Double capacity = JsonUtil.getDouble((JSONObject)jsonObject, (String)"capacity", (Double[])new Double[]{0.0});
            Double usedCapacity = JsonUtil.getDouble((JSONObject)jsonObject, (String)"usedCapacity", (Double[])new Double[]{0.0});
            Integer volType = JsonUtil.getInteger((JSONObject)jsonObject, (String)"volType", (Integer[])new Integer[]{0});
            if (VerifyUtil.isEmpty((String)mountPoint)) {
                logger.warn((Object)("mountpoint is empty, deviceName: " + deviceName), 90160758786816L);
                continue;
            }
            if (mountPoint.length() > 200) {
                logger.warn((Object)("mountpoint path is too long, deviceName: " + deviceName + ", mountPoint: " + mountPoint), 90160758786816L);
                continue;
            }
            fileSystem.setUuid(this.getDevSn() + ";" + mountPoint);
            fileSystem.setHostSN(this.getDevSn());
            fileSystem.setName(mountPoint);
            fileSystem.setAttachVol(deviceName);
            fileSystem.setFsType(fsType.toUpperCase(Locale.ENGLISH));
            fileSystem.setMount(mountPoint);
            fileSystem.setUsedCapcity(usedCapacity);
            fileSystem.setTotalCapcity(capacity);
            fileSystem.setFsName(mountPoint);
            fileSystem.setVolType(volType);
            hostFsList.add(fileSystem);
        }
        return hostFsList;
    }

    public void mountFileSystems(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        if (VerifyUtil.isEmpty(hostDeviceStorageInfos)) {
            logger.warn((Object)"hostDeviceStorageInfos is empty.");
            return;
        }
        HashSet<String> deviceNameSet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String deviceName = hostDeviceStorageInfo.getDeviceName();
            if (deviceNameSet.contains(deviceName)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"deviceName", (Object)deviceName);
            jsonObject.put((Object)"volType", (Object)hostDeviceStorageInfo.getStorageSubType());
            jsonObject.put((Object)"mountPoint", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            deviceNameSet.add(deviceName);
        }
        this.put("/agent/device/filesystems/action/batchMount", jsonArray.toString(), Collections.emptyMap());
    }

    public void unmountFileSystems(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        if (VerifyUtil.isEmpty(hostDeviceStorageInfos)) {
            logger.warn((Object)"hostDeviceStorageInfos is empty.");
            return;
        }
        HashSet<String> deviceNameSet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String deviceName = hostDeviceStorageInfo.getDeviceName();
            if (deviceNameSet.contains(deviceName)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"deviceName", (Object)deviceName);
            jsonObject.put((Object)"volType", (Object)hostDeviceStorageInfo.getStorageSubType());
            jsonObject.put((Object)"mountPoint", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            deviceNameSet.add(deviceName);
        }
        this.put("/agent/device/filesystems/action/batchUnmount", jsonArray.toString(), Collections.emptyMap());
    }

    public VolumeGroup queryVGInfos(String vgName, Integer volType) {
        try {
            HashMap<String, String> reqParams = new HashMap<String, String>();
            reqParams.put("vgName", vgName);
            reqParams.put("volType", String.valueOf(volType));
            String result = this.get("/agent/device/lvm/vgs?vgName={vgName}&volType={volType}", reqParams);
            if (this.isResultEmpty(result)) {
                return null;
            }
            JSONObject jsonVg = JSONObject.fromObject((Object)result);
            VolumeGroup vg = new VolumeGroup();
            vg.setVgName(JsonUtil.getString((JSONObject)jsonVg, (String)"vgName", (String[])new String[0]));
            vg.setVolType(JsonUtil.getInteger((JSONObject)jsonVg, (String)"volType", (Integer[])new Integer[]{0}));
            vg.setState(JsonUtil.getInteger((JSONObject)jsonVg, (String)"state", (Integer[])new Integer[]{0}));
            vg.setMapInfo(JsonUtil.getString((JSONObject)jsonVg, (String)"mapInfo", (String[])new String[0]));
            JSONArray jsonPvs = JsonUtil.getJSONArray((JSONObject)jsonVg, (String)"pvs");
            if (null != jsonPvs) {
                ArrayList<String> pvList = new ArrayList<String>();
                vg.setPvs(pvList);
                Iterator it = jsonPvs.iterator();
                while (it.hasNext()) {
                    pvList.add((String)it.next());
                }
            }
            return vg;
        }
        catch (Exception e) {
            logger.error((Object)("get vg info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
    }

    public void importVG(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashMap vgMap = new HashMap();
        HashMap pvKeySetMap = new HashMap();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String pvKey;
            ArrayList pvInfos;
            String vgName = hostDeviceStorageInfo.getVgName();
            if (VerifyUtil.isEmpty((String)vgName)) continue;
            HashMap<String, Object> vgAttriMap = (HashMap<String, Object>)vgMap.get(vgName);
            HashSet<String> pvKeySet = (HashSet<String>)pvKeySetMap.get(vgName);
            if (null == vgAttriMap) {
                vgAttriMap = new HashMap<String, Object>();
                vgMap.put(vgName, vgAttriMap);
                pvKeySet = new HashSet<String>();
                pvKeySetMap.put(vgName, pvKeySet);
                vgAttriMap.put("vgName", hostDeviceStorageInfo.getVgName());
                vgAttriMap.put("volType", hostDeviceStorageInfo.getStorageSubType());
                String mapInfo = hostDeviceStorageInfo.getVgMapInfo();
                vgAttriMap.put("mapInfo", null == mapInfo ? "" : mapInfo);
                pvInfos = new ArrayList();
                vgAttriMap.put("pvInfo", pvInfos);
            }
            if (pvKeySet.contains(pvKey = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getPvName())) continue;
            pvInfos = (ArrayList)vgAttriMap.get("pvInfo");
            HashMap<String, String> pvInfoMap = new HashMap<String, String>();
            pvInfoMap.put("wwn", hostDeviceStorageInfo.getWwn());
            String pvName = hostDeviceStorageInfo.getPvName();
            pvInfoMap.put("pvName", null == pvName ? "" : pvName);
            pvInfos.add(pvInfoMap);
            pvKeySet.add(pvKey);
        }
        for (Map.Entry entry : vgMap.entrySet()) {
            logger.info((Object)("send import vg command, vg name: " + (String)entry.getKey()), 90160758786816L);
            JSONObject jsonObject = JSONObject.fromObject(entry.getValue());
            this.put("/agent/device/lvm/vgs/action/import", jsonObject.toString(), Collections.emptyMap());
        }
    }

    public void exportVG(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashMap vgMap = new HashMap();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            HashMap<String, Object> vgAttriMap;
            String vgName = hostDeviceStorageInfo.getVgName();
            if (VerifyUtil.isEmpty((String)vgName) || null != (vgAttriMap = (HashMap<String, Object>)vgMap.get(vgName))) continue;
            vgAttriMap = new HashMap<String, Object>();
            vgMap.put(vgName, vgAttriMap);
            vgAttriMap.put("vgName", hostDeviceStorageInfo.getVgName());
            vgAttriMap.put("volType", hostDeviceStorageInfo.getStorageSubType());
        }
        for (Map.Entry entry : vgMap.entrySet()) {
            logger.info((Object)("send export vg command, vg name: " + (String)entry.getKey()), 90160758786816L);
            JSONObject jsonObject = JSONObject.fromObject(entry.getValue());
            this.put("/agent/device/lvm/vgs/action/export", jsonObject.toString(), Collections.emptyMap());
        }
    }

    public void activateVG(List<HostDeviceStorageInfo> hostDeviceStorageInfos, String vgActiveMode, Integer recoverType) {
        Integer volType = null;
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (jsonArray.contains((Object)hostDeviceStorageInfo.getVgName())) continue;
            jsonArray.add((Object)hostDeviceStorageInfo.getVgName());
            volType = hostDeviceStorageInfo.getStorageSubType();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"vgNames", (Object)jsonArray);
        jsonObject.put((Object)"volType", volType);
        jsonObject.put((Object)"vgActiveMode", (Object)(null == vgActiveMode || "--".equals(vgActiveMode) ? "" : vgActiveMode));
        jsonObject.put((Object)"recoverType", (Object)recoverType);
        this.put("/agent/device/lvm/vgs/action/activate", jsonObject.toString(), Collections.emptyMap());
    }

    public void deActivateVG(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        Integer volType = null;
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            if (jsonArray.contains((Object)hostDeviceStorageInfo.getVgName())) continue;
            jsonArray.add((Object)hostDeviceStorageInfo.getVgName());
            volType = hostDeviceStorageInfo.getStorageSubType();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"vgNames", (Object)jsonArray);
        jsonObject.put((Object)"volType", volType);
        this.put("/agent/device/lvm/vgs/action/deActivate", jsonObject.toString(), Collections.emptyMap());
    }

    public void preAsmlib() {
        this.put("/agent/device/asmlib", emptyString, Collections.emptyMap());
    }

    public void writeUdevRules(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> wwnSet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String wwnKey = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getDeviceName();
            if (wwnSet.contains(wwnKey) || VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getUdevRules())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"udevRule", (Object)hostDeviceStorageInfo.getUdevRules());
            jsonArray.add((Object)jsonObject);
            wwnSet.add(wwnKey);
        }
        if (!jsonArray.isEmpty()) {
            this.post("/agent/device/udev/batchRules", jsonArray.toString(), Collections.emptyMap());
        }
    }

    public void deleteUdevRules(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> wwnSet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String wwnKey = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getDeviceName();
            if (wwnSet.contains(wwnKey)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"udevRule", (Object)hostDeviceStorageInfo.getUdevRules());
            jsonArray.add((Object)jsonObject);
            wwnSet.add(wwnKey);
        }
        if (!jsonArray.isEmpty()) {
            this.delete("/agent/device/udev/batchRules", jsonArray.toString(), Collections.emptyMap());
        }
    }

    public String createRaws(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        JSONArray jsonArray = this.buildRawsRequestJsonInfo(hostDeviceStorageInfos);
        String result = null;
        if (!jsonArray.isEmpty()) {
            result = this.post("/agent/device/batchRaws", jsonArray.toString(), Collections.emptyMap());
        }
        return result;
    }

    public void deleteRaws(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        JSONArray jsonArray = this.buildRawsRequestJsonInfo(hostDeviceStorageInfos);
        if (!jsonArray.isEmpty()) {
            this.delete("/agent/device/batchRaws", jsonArray.toString(), Collections.emptyMap());
        }
    }

    private JSONArray buildRawsRequestJsonInfo(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> keySet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getDeviceName();
            if (keySet.contains(key) || VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getMountPoint())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"deviceName", (Object)hostDeviceStorageInfo.getDeviceName());
            jsonObject.put((Object)"devicePath", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            keySet.add(key);
        }
        return jsonArray;
    }

    public void createLinks(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> keySet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getDeviceName();
            if (keySet.contains(key) || VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getMountPoint())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"deviceName", (Object)hostDeviceStorageInfo.getDeviceName());
            jsonObject.put((Object)"linkName", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            keySet.add(key);
        }
        if (!jsonArray.isEmpty()) {
            this.post("/agent/device/batchLinks", jsonArray.toString(), Collections.emptyMap());
        }
    }

    public void deleteLinks(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> keySet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getDeviceName();
            if (keySet.contains(key) || VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getMountPoint())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"deviceName", (Object)hostDeviceStorageInfo.getDeviceName());
            jsonObject.put((Object)"linkName", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            keySet.add(key);
        }
        if (!jsonArray.isEmpty()) {
            this.delete("/agent/device/batchLinks", jsonArray.toString(), Collections.emptyMap());
        }
    }

    public void setPermission(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashSet<String> keySet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String key = hostDeviceStorageInfo.getWwn() + "_" + hostDeviceStorageInfo.getMountPoint();
            if (keySet.contains(key) || VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getMountPoint())) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)hostDeviceStorageInfo.getWwn());
            jsonObject.put((Object)"appType", (Object)hostDeviceStorageInfo.getAppType());
            jsonObject.put((Object)"appVersion", (Object)hostDeviceStorageInfo.getAppVersion());
            jsonObject.put((Object)"deviceName", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonObject.put((Object)"userName", (Object)hostDeviceStorageInfo.getAppUserName());
            jsonObject.put((Object)"privMode", (Object)"660");
            jsonArray.add((Object)jsonObject);
            keySet.add(key);
        }
        if (!jsonArray.isEmpty()) {
            this.post("/agent/device/permission", jsonArray.toString(), Collections.emptyMap());
        }
    }

    public void freezeFileSystems(String[] mountPoints) {
        if (VerifyUtil.isEmpty((Object[])mountPoints)) {
            logger.error((Object)"mountPoints is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"diskNames", (Object)JSONArray.fromObject((Object)mountPoints));
        this.put("/agent/device/filesystems/action/freeze", jsonObject.toString(), Collections.emptyMap());
    }

    public void thawFileSystems(String[] mountPoints) {
        if (VerifyUtil.isEmpty((Object[])mountPoints)) {
            logger.error((Object)"mountPoints is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"diskNames", (Object)JSONArray.fromObject((Object)mountPoints));
        this.put("/agent/device/filesystems/action/unfreeze", jsonObject.toString(), Collections.emptyMap());
    }

    public void deleteDriveLetter(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        if (VerifyUtil.isEmpty(hostDeviceStorageInfos)) {
            logger.warn((Object)"hostDeviceStorageInfos is empty.");
            return;
        }
        HashSet<String> deviceNameSet = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String deviceName = hostDeviceStorageInfo.getDeviceName();
            if (deviceNameSet.contains(deviceName)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"deviceName", (Object)deviceName);
            jsonObject.put((Object)"volType", (Object)hostDeviceStorageInfo.getStorageSubType());
            jsonObject.put((Object)"mountPoint", (Object)hostDeviceStorageInfo.getMountPoint());
            jsonArray.add((Object)jsonObject);
            deviceNameSet.add(deviceName);
        }
        this.put("/agent/device/driveletter/action/batchdel", jsonArray.toString(), Collections.emptyMap());
    }

    public void scanVxvmDisk() {
        this.put("/agent/device/lvm/action/scandisks", emptyString, Collections.emptyMap());
    }

    public void configureMultipath(List<Map<String, String>> multipathList) {
        JSONArray jsonArray = new JSONArray();
        for (Map<String, String> multipath : multipathList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)("3" + multipath.get("wwn")));
            jsonObject.put((Object)"alias", (Object)multipath.get("alias"));
            jsonArray.add((Object)jsonObject);
        }
        if (!jsonArray.isEmpty()) {
            this.post("/agent/device/multipath/batchrules", jsonArray.toString(), null);
        }
    }

    public void deleteMultipath(List<Map<String, String>> multipathList) {
        JSONArray jsonArray = new JSONArray();
        for (Map<String, String> multipath : multipathList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wwn", (Object)("3" + multipath.get("wwn")));
            jsonObject.put((Object)"alias", (Object)multipath.get("alias"));
            jsonArray.add((Object)jsonObject);
        }
        if (!jsonArray.isEmpty()) {
            this.delete("/agent/device/multipath/batchrules", jsonArray.toString(), null);
        }
    }
}

