/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.device.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.host.agent.action.DeviceAction;
import com.huawei.ism.drm.host.device.process.IDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostDeviceUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinkProcessor
implements IDeviceProcessor {
    private static final Log LOGGER = LogFactory.getInstance(LinkProcessor.class);
    private static final int PROCESS_ORDER = 170;
    private static final int CLEAN_ORDER = 130;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> linkStorageInfos = this.buildLinkStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(linkStorageInfos)) {
            return true;
        }
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.createLinks(linkStorageInfos);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(linkStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    @Override
    public boolean clean(RecoveryProcessorContext context) {
        NeMgrProtocolExtend neMgrExtend = (NeMgrProtocolExtend)context.getAttribute("HOST_AUTH_INFO");
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        List<HostDeviceStorageInfo> linkStorageInfos = this.buildLinkStorageInfos(hostDeviceStorageInfos);
        if (VerifyUtil.isEmpty(linkStorageInfos)) {
            return true;
        }
        try {
            DeviceAction deviceAction = new DeviceAction(neMgrExtend, drHost.getDeviceSn());
            deviceAction.deleteLinks(linkStorageInfos);
        }
        catch (LegoCheckedException legoEx) {
            LOGGER.error((Object)legoEx.getMessage(), (Throwable)legoEx, 90160758787071L);
            Map<String, List<HostDeviceStorageInfo>> storageInfoMap = DrHostDeviceUtil.buildStorageInfoMapByWwn(linkStorageInfos);
            DrHostDeviceUtil.parseAndUpdateStorageErrorCodeInfo(legoEx, "wwn", storageInfoMap);
            return false;
        }
        return true;
    }

    private List<HostDeviceStorageInfo> buildLinkStorageInfos(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        ArrayList<HostDeviceStorageInfo> linkStorageInfos = new ArrayList<HostDeviceStorageInfo>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            int storageType = hostDeviceStorageInfo.getStorageType();
            if (storageType != 4) continue;
            if (hostDeviceStorageInfo.getErrorCode() != 0L) {
                LOGGER.warn((Object)("The storage info(wwn: " + hostDeviceStorageInfo.getWwn() + ", deviceName" + hostDeviceStorageInfo.getDeviceName() + ") has error, errorCode: " + hostDeviceStorageInfo.getErrorCode()), 90160758786989L);
                continue;
            }
            linkStorageInfos.add(hostDeviceStorageInfo);
        }
        return linkStorageInfos;
    }

    @Override
    public boolean needProcess(RecoveryProcessorContext context) {
        List hostDeviceStorageInfos = (List)context.getAttribute("HOST_DEVICE_INFO");
        DrHost drHost = (DrHost)context.getAttribute("HOST_INFO");
        Integer iOsType = NumberUtil.parseInteger((Object)drHost.getOsType());
        DrmAppEnumDefine.OS_TYPE_E osType = DrmAppEnumDefine.OS_TYPE_E.getType((int)iOsType);
        if (DrmAppEnumDefine.OS_TYPE_E.WINDOWS == osType) {
            return false;
        }
        return !VerifyUtil.isEmpty(this.buildLinkStorageInfos(hostDeviceStorageInfos));
    }

    @Override
    public int getProcessOrder() {
        return 170;
    }

    @Override
    public int getCleanOrder() {
        return 130;
    }
}

