/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.service.IHostDiscoveryService;
import com.huawei.ism.drm.host.util.DrHostValidUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HostResourceManager
implements IResourceManager {
    private static final Log LOGGER = LogFactory.getInstance(HostResourceManager.class);
    private IMoDao moDao;
    private IHostDiscoveryService hostDiscoveryService;
    private IManagementProtocolService managementProtocolService;

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void setHostDiscoveryService(IHostDiscoveryService hostDiscoveryService) {
        this.hostDiscoveryService = hostDiscoveryService;
    }

    public void setManagementProtocolService(IManagementProtocolService managementProtocolService) {
        this.managementProtocolService = managementProtocolService;
    }

    public String getResourceType() {
        return "ism.drm.deviceType.drhost.mainType";
    }

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        NeMgrProtocolExtend neMgrProtocolExtend = this.managementProtocolService.findByMoId(moId);
        neMgrProtocolExtend.setNetworkPassword("");
        this.setExtendParam(neMgrProtocolExtend);
        return neMgrProtocolExtend;
    }

    private void setExtendParam(NeMgrProtocolExtend neMgrProtocolExtend) {
        Map paramMap = neMgrProtocolExtend.getExtendParams();
        String engunedId = (String)paramMap.get("snmpContextEngineId");
        if (VerifyUtil.isEmpty((String)engunedId)) {
            paramMap.put("snmpContextEngineId", paramMap.get("mac_address"));
        }
        paramMap.put("snmpAuthPwd", "");
        paramMap.put("snmpEncryptPwd", "");
    }

    public void validate(NeMgrProtocolExtend neMgrProtocol) {
        long moId = neMgrProtocol.getMoId();
        NeMgrProtocolExtend oldExtend = this.managementProtocolService.findByMoId(Long.valueOf(moId));
        String ipAddress = neMgrProtocol.getNetworkIpAddress();
        if (VerifyUtil.isEmpty((String)ipAddress) || Objects.equals(ipAddress, oldExtend.getNetworkIpAddress())) {
            return;
        }
        this.validatePwd(neMgrProtocol.getNetworkPassword());
        if (!neMgrProtocol.isModifyAuthInfo()) {
            LOGGER.error((Object)"The host password does not change with the IP address changed.");
            throw new LegoCheckedException(2099466L);
        }
    }

    private void validatePwd(String pwd) {
        if (!ValidateUtil.checkLength((String)pwd, (int)1, (int)32)) {
            throw new LegoCheckedException(2099466L);
        }
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        if (VerifyUtil.isEmpty((Object)neMgrProtocol.getMoId())) {
            LOGGER.error((Object)"mo id is null!");
            throw new LegoCheckedException(1073947393L);
        }
        Host host = (Host)this.moDao.getMo(Host.class, "moId", (Object)neMgrProtocol.getMoId());
        if (neMgrProtocol.isModifyAuthInfo()) {
            if (!(DrHostValidUtil.checkUserName(neMgrProtocol.getNetworkUserName()) && CommUtil.checkDrmIpParam((String)neMgrProtocol.getNetworkIpAddress()) && DrHostValidUtil.checkPort((String)neMgrProtocol.getExtendParams().get("port")))) {
                throw new LegoCheckedException(1073947393L);
            }
            String password = neMgrProtocol.getNetworkPassword();
            if (!VerifyUtil.isEmpty((String)password) && !DrHostValidUtil.checkPwd(password)) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        if (!VerifyUtil.isEmpty((String)((String)neMgrProtocol.getExtendParams().get("snmpVersion")))) {
            this.setManagementProtocolMap(host, neMgrProtocol.getExtendParams());
            DiscParamVilidateResult result = DrHostValidUtil.checkSNMP(neMgrProtocol.getExtendParams());
            if (!result.isResult()) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        this.hostDiscoveryService.updateHost(host, neMgrProtocol, true);
    }

    private void setManagementProtocolMap(Host host, Map<String, String> paramMap) {
        if (null == paramMap.get("snmpVersion")) {
            return;
        }
        paramMap.put("snmpContextEngineId", "");
        NeMgrProtocolExtend neMgrProtocolExtend = this.managementProtocolService.findByMoId(host.getMoId());
        SnmpPara snmpPara = new SnmpPara();
        snmpPara.setAuthProtocol(paramMap.get("snmpAuthProtocol"));
        String authPwd = this.getPwd("snmpAuthPwd", paramMap, neMgrProtocolExtend, "snmpAuthProtocol");
        snmpPara.setAuthPwd(authPwd);
        String engunedId = paramMap.get("snmpContextEngineId");
        if (VerifyUtil.isEmpty((String)engunedId.trim())) {
            snmpPara.setContextEngineId(host.getSn());
            paramMap.put("snmpContextEngineId", host.getSn());
        } else {
            snmpPara.setContextEngineId(engunedId);
        }
        snmpPara.setContextName(paramMap.get("snmpContextName"));
        snmpPara.setEncryptProtocol(paramMap.get("snmpEncryptProtocol"));
        String encryptPwd = this.getPwd("snmpEncryptPwd", paramMap, neMgrProtocolExtend, "snmpEncryptProtocol");
        snmpPara.setEncryptPwd(encryptPwd);
        snmpPara.setRetries(NumberUtil.convertToInteger((Object)paramMap.get("snmpRetries")).intValue());
        snmpPara.setSecurityName(paramMap.get("snmpSecurityName"));
        snmpPara.setTimeout(NumberUtil.convertToInteger((Object)paramMap.get("snmpTimeout")).intValue());
        if (!"SNMPv3".equals(paramMap.get("snmpVersion"))) {
            return;
        }
        snmpPara.setVersion(3);
        snmpPara.setPort(NumberUtil.convertToInteger((Object)paramMap.get("snmpPort")).intValue());
        snmpPara.setNode((Node)host);
        HashMap<String, SnmpPara> protocolMap = new HashMap<String, SnmpPara>();
        protocolMap.put(SnmpPara.class.getName(), snmpPara);
        host.setManagementProtocolMap(protocolMap);
    }

    private String getPwd(String pwdKey, Map<String, String> paramMap, NeMgrProtocolExtend neMgrProtocolExtend, String protocolTypeKey) {
        if (!VerifyUtil.isEmpty((String)paramMap.get(pwdKey))) {
            return paramMap.get(pwdKey);
        }
        if (null == neMgrProtocolExtend) {
            LOGGER.error((Object)"neMgrProtocolExtend is null.", 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        Map extendParams = neMgrProtocolExtend.getExtendParams();
        if (VerifyUtil.isEmpty((Map)extendParams)) {
            LOGGER.error((Object)"neMgrProtocolExtend.getExtendParams() is null.", 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        String encodePwd = (String)extendParams.get(pwdKey);
        String protocolType = (String)extendParams.get(protocolTypeKey);
        if (VerifyUtil.isEmpty((String)encodePwd) && !VerifyUtil.isEmpty((String)protocolType)) {
            LOGGER.error((Object)("neMgrProtocolExtend.getExtendParams() pwd is null,key:" + pwdKey), 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            String pwd = WccEncryptor.decrypt((String)encodePwd);
            if (VerifyUtil.isEmpty((String)pwd) && !VerifyUtil.isEmpty((String)protocolType)) {
                LOGGER.error((Object)("get failed,key:" + pwdKey), 90160777660713L);
                throw new LegoCheckedException(1073947393L);
            }
            paramMap.put(pwdKey, pwd);
            return pwd;
        }
        catch (Exception e) {
            String errorMsg = "get exception,key:" + pwdKey;
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)1073947393L, null, (Log)LOGGER);
            return "";
        }
    }
}

