/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.discovery.proxy;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationDiscoverer;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HostApplicationDiscoverProxy {
    private static final Log LOGGER = LogFactory.getInstance(HostApplicationDiscoverProxy.class);
    private static HostApplicationDiscoverProxy instance = null;
    private Map<Integer, IApplicationDiscoverer> appDiscovererMapping = new HashMap<Integer, IApplicationDiscoverer>();

    private HostApplicationDiscoverProxy() {
    }

    public static synchronized HostApplicationDiscoverProxy getInstance() {
        if (null == instance) {
            instance = new HostApplicationDiscoverProxy();
        }
        return instance;
    }

    public void onBind(IApplicationDiscoverer appDiscoverer, Map<?, ?> properties) {
        this.appDiscovererMapping.put(appDiscoverer.getAppType(), appDiscoverer);
    }

    public void onUnbind(IApplicationDiscoverer appDiscoverer, Map<?, ?> properties) {
        this.appDiscovererMapping.remove(appDiscoverer.getAppType());
    }

    public Map<Integer, List<ManagedObject>> discoverApplication(NeMgrProtocolExtend extend) {
        HashMap<Integer, List<ManagedObject>> resultMap = new HashMap<Integer, List<ManagedObject>>();
        if (VerifyUtil.isEmpty(this.appDiscovererMapping)) {
            return resultMap;
        }
        for (IApplicationDiscoverer applicationDiscover : this.appDiscovererMapping.values()) {
            try {
                ArrayList appResults = applicationDiscover.discoverApplication(extend);
                if (VerifyUtil.isEmpty((Collection)appResults)) {
                    appResults = new ArrayList();
                }
                resultMap.put(applicationDiscover.getAppType(), appResults);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Query database instance error, IP: %s", new Object[]{e, new Object[]{extend.getNetworkIpAddress()}});
            }
        }
        if (VerifyUtil.isEmpty(resultMap)) {
            LOGGER.warn((Object)"Query all database instance is null, IP: %s", new Object[]{extend.getNetworkIpAddress()});
        }
        return resultMap;
    }
}

