/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class BaseThawAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BaseThawAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BaseThawAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        if (this.checkIsFreeze(context)) {
            return this.thaw(context, protectGroup);
        }
        return false;
    }

    protected boolean thaw(ActionContext context, ProtectGroup protectGroup) {
        Set freezePo = (Set)context.getObject("FREEZE_PO_ENTITY");
        long errorCode = 0L;
        for (ProtectObject po : freezePo) {
            logger.info((Object)("begin to thaw app,pgId:" + protectGroup.getUuid() + ",poName" + po.getName()), 90160758786988L);
            try {
                ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).thaw(po);
            }
            catch (LegoCheckedException e) {
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                logger.error((Object)("BaseThawAction failed,pgId:" + protectGroup.getUuid()), (Throwable)e, 90160758786989L);
            }
            catch (Exception e) {
                errorCode = 1073948172L;
                this.setDetail("lego.err.1073948172");
                logger.error((Object)("BaseThawAction failed,pgId:" + protectGroup.getUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
            logger.info((Object)("End to thaw app:" + protectGroup.getUuid() + ",poName" + po.getName()), 90160758786988L);
        }
        return 0L == errorCode;
    }

    public boolean checkIsFreeze(ActionContext context) {
        int flag = (Integer)context.getObject("EXECUTE_FREEZE_FLAG_KEY");
        if (0 == flag) {
            LegoCheckedException e = (LegoCheckedException)((Object)context.getObject("EXECUTE_FREEZE_EXCEPTION_KEY"));
            if (null != e) {
                this.setDetail(e.getErrorMessageKey());
            } else {
                this.setDetail("lego.err.1073947393");
            }
            return false;
        }
        return true;
    }
}

