/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.protection.action;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class MapReplicaTask
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getInstance(MapReplicaTask.class);
    private final String devSn;
    private final String lunId;
    private final Snapshot snapshot;
    private final String lunGroupId;
    private final ResourceVO resourceVO;

    public MapReplicaTask(String devSn, String lunId, Snapshot snapshot, String lunGroupId, ResourceVO resourceVO) {
        this.devSn = devSn;
        this.lunId = lunId;
        this.snapshot = snapshot;
        this.lunGroupId = lunGroupId;
        this.resourceVO = resourceVO;
    }

    @Override
    public Boolean call() {
        OperationResult operationResult;
        if (null != this.snapshot) {
            IStorageSnapshotManager proxy = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.devSn);
            if (!HvsUnit.class.getName().equals(proxy.getStorageType())) {
                logger.error((Object)("dev(" + this.devSn + ") is not a Hvs."));
                return false;
            }
            operationResult = proxy.addSnapshotToLunGroup(this.devSn, this.snapshot, this.lunGroupId, null);
            logger.debug((Object)("add snapshot(devSn:" + this.devSn + ";snapshotId:" + this.snapshot.getSnapshotId() + ") to lungroup(" + this.lunGroupId + ") result is " + operationResult.isSuccess()));
        } else {
            IStorageLunBaseManager proxy = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.devSn);
            if (!HvsUnit.class.getName().equals(proxy.getStorageType())) {
                logger.error((Object)("dev(" + this.devSn + ") is not a Hvs."));
                return false;
            }
            ArrayList<HostVO> hostVoList = new ArrayList<HostVO>();
            if (this.resourceVO instanceof HostVO) {
                hostVoList.add((HostVO)this.resourceVO);
            } else {
                hostVoList.addAll(((HostGroupVO)this.resourceVO).getHostVOs());
            }
            operationResult = proxy.addLunToLunGroup(this.devSn, this.lunId, hostVoList, this.lunGroupId, null);
        }
        return operationResult.isSuccess();
    }
}

