/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeleteCloneVolumeMappingSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8236347839046897699L;
    private static final Log LOGGER = LogFactory.getInstance(DeleteCloneVolumeMappingSubProcessor.class);
    private static final long LOG_CODE = -1L;
    private static final int REPEAT_TIMES = 10;
    private static final long RETRY_INTERVAL_TIME_UNIT = 2000L;
    private String deviceId;
    private String lunId;
    private String lunName;
    private String hostOrGroupId;
    private String hostOrGroupName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            LOGGER.info((Object)("getProcStatus is success:" + this.getLunName() + "-" + this.getHostOrGroupName()), -1L);
            this.updateProcessNameParams(new String[]{this.getLunName(), this.getHostOrGroupName()});
            this.updateProcessDetail("ism.drm.recovery.snapshot.cloneVolume.already.unmapped", new String[]{this.getLunName(), this.getHostOrGroupName()});
            return true;
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DrResource drHostOrGroup = recoveryService.getDrResourceByID(this.getHostOrGroupId());
        if (null == drHostOrGroup) {
            LOGGER.error((Object)("getHostByMoID is null:" + this.getHostOrGroupId()), -1L);
            this.updateProcessName("ism.drm.recovery.snapshot.cloneVolume.unmapping.failed");
            this.updateProcessDetail("lego.err.1073948686", new String[]{this.getHostOrGroupId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.updateProcessNameParams(new String[]{this.getLunName(), drHostOrGroup.getName()});
        this.setHostOrGroupName(drHostOrGroup.getName());
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        StorageLunManagerProxy storageLunManagerProxy = StorageLunManagerProxy.getInstance();
        IStorageLunBaseManager lunManager = storageLunManagerProxy.getStorageLunMgrByDevType(deviceType);
        ArrayList<String> lunNames = new ArrayList<String>();
        lunNames.add(this.getLunName());
        List luns = lunManager.queryLunsByNames(this.getDeviceId(), lunNames);
        if (VerifyUtil.isEmpty((Collection)luns)) {
            LOGGER.error((Object)"snapshot copyVolume  got error ");
            throw new LegoCheckedException(1073947393L);
        }
        OperationResult result = this.tryRepeatDeleteMapping(lunManager, this.getDeviceId(), (Lun)CommonUtil.getFirstElement((Collection)luns), drHostOrGroup);
        if (null == result) {
            LOGGER.error((Object)"tryRepeatDeleteMapping got error , result is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (!result.isSuccess()) {
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private OperationResult tryRepeatDeleteMapping(IStorageLunBaseManager lunManager, String tgtDeviceId, Lun lun, DrResource drHostOrGroup) {
        OperationResult result = null;
        for (int i = 10; i > 0; --i) {
            if (drHostOrGroup instanceof DrHost) {
                DrHost drHost = (DrHost)drHostOrGroup;
                HostVO hostVO = new HostVO();
                hostVO.setId(drHost.getDeviceSn());
                hostVO.setName(drHost.getName());
                hostVO.setIpAddress(drHost.getIpAddress());
                hostVO.setExtProperty(drHost.getExtProperty());
                result = lunManager.removeLunMapping(tgtDeviceId, lun.getLunId(), hostVO);
            } else {
                DrHostGroup drHostGroup = (DrHostGroup)drHostOrGroup;
                HostGroupVO hostGroupVO = new HostGroupVO();
                hostGroupVO.setId(drHostGroup.getDeviceSn());
                hostGroupVO.setName(drHostGroup.getName());
                ArrayList hostVOS = new ArrayList();
                Set resourceSet = drHostOrGroup.getChildResources();
                if (!VerifyUtil.isEmpty((Collection)resourceSet) && resourceSet.size() > 0) {
                    drHostGroup.getChildResources().forEach(item -> {
                        HostVO hostVO = new HostVO();
                        hostVO.setIpAddress(item.getIpAddress());
                        hostVO.setExtProperty(item.getExtProperty());
                        hostVOS.add(hostVO);
                    });
                }
                hostGroupVO.setHostVOs(hostVOS);
                result = lunManager.removeLunMapping(tgtDeviceId, lun.getLunId(), hostGroupVO);
            }
            if (!VerifyUtil.isEmpty((Object)result) && result.isSuccess()) break;
            LOGGER.info((Object)("removeSnapshotFromHost faild: waiting for " + i + " seconds to retry."), -1L);
            CommUtil.pauseThread((long)((long)i * 2000L));
        }
        return result;
    }
}

